/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.feature.launcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.shared.utils.Os;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ProcessTracker {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessTracker.class);
    private final Object sync = new Object();
    private boolean hookAdded = false;
    private final Map<String, Process> processes = new HashMap<String, Process>();

    static void stop(Process process) throws InterruptedException {
        if (Os.isFamily((String)"windows")) {
            ProcessTracker.stopWithDescendants(process, false);
        } else {
            ProcessTracker.stopDirectly(process, false);
        }
    }

    static void stopForcibly(Process process) throws InterruptedException {
        if (Os.isFamily((String)"windows")) {
            ProcessTracker.stopWithDescendants(process, true);
        } else {
            ProcessTracker.stopDirectly(process, true);
        }
    }

    private static void stopDirectly(Process process, boolean forcibly) throws InterruptedException {
        if (forcibly) {
            LOG.debug("Forcibly destroy process: {}", (Object)process);
            process.destroyForcibly();
            return;
        }
        LOG.debug("Destroy process: {}", (Object)process);
        process.destroy();
        boolean stopped = process.waitFor(30L, TimeUnit.SECONDS);
        if (!stopped) {
            LOG.debug("Forcibly destroy process after 30sec: {}", (Object)process);
            process.destroyForcibly();
        }
        LOG.debug("Destroy process finished: {}", (Object)process);
    }

    private static void stopWithDescendants(Process process, boolean forcibly) throws InterruptedException {
        LOG.debug("Destroy process with descendants: {}", (Object)process);
        ProcessHandle processHandle = ProcessHandle.of(process.pid()).orElse(null);
        if (processHandle == null) {
            LOG.error("Unable to shutdown process, no process handle for pid {}", (Object)process.pid());
            return;
        }
        for (ProcessHandle childProcess : processHandle.descendants().collect(Collectors.toList())) {
            if (forcibly) {
                LOG.debug("Forcibly destroy child process: {}", (Object)childProcess);
                childProcess.destroyForcibly();
                return;
            }
            LOG.debug("Destroy child process: {}", (Object)childProcess);
            childProcess.destroy();
            try {
                boolean stopped;
                boolean bl = stopped = childProcess.onExit().get(30L, TimeUnit.SECONDS) != null;
                if (!stopped) {
                    LOG.debug("Forcibly destroy child process after 30sec: {}", (Object)childProcess);
                    childProcess.destroyForcibly();
                }
                LOG.debug("Destroy child process finished: {}", (Object)childProcess);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOG.error("Error while stopping child process {}: {}", new Object[]{childProcess, ex.getMessage(), ex});
            }
        }
        ProcessTracker.stopDirectly(process, forcibly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(final String launchId, final Process process) {
        Object object = this.sync;
        synchronized (object) {
            if (this.processes.containsKey(launchId)) {
                throw new IllegalArgumentException("Launch id " + launchId + " already associated with a process");
            }
            LOG.debug("Start tracking process for launch {}: {}", (Object)launchId, (Object)process);
            this.processes.put(launchId, process);
            if (!this.hookAdded) {
                Runtime.getRuntime().addShutdownHook(new Thread("process-tracker-shutdown"){

                    @Override
                    public void run() {
                        LOG.debug("Shutdown hook  is running for launch {}: {}", (Object)launchId, (Object)process);
                        for (Map.Entry<String, Process> entry : ProcessTracker.this.processes.entrySet()) {
                            LOG.error("Launch {} was not shut down! Destroying forcibly from shutdown hook.", (Object)entry.getKey());
                            try {
                                ProcessTracker.stopForcibly(process);
                            }
                            catch (InterruptedException e) {
                                this.interrupt();
                            }
                        }
                    }
                });
                this.hookAdded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String id) throws InterruptedException {
        Process process;
        Object object = this.sync;
        synchronized (object) {
            process = this.processes.remove(id);
        }
        if (process == null) {
            LOG.warn("Process not found in process list, skip stopping: {}", (Object)id);
            return;
        }
        ProcessTracker.stop(process);
    }
}

