/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.scheduler.impl;

import org.quartz.spi.ThreadPool;

public class QuartzThreadPool
implements ThreadPool {
    private volatile org.apache.sling.commons.threads.ThreadPool executor;
    private final Object lock = new Object();
    private volatile int counter;

    public QuartzThreadPool(org.apache.sling.commons.threads.ThreadPool executor) {
        this.executor = executor;
        this.counter = executor.getConfiguration().getMaxPoolSize();
    }

    @Override
    public int getPoolSize() {
        return this.executor.getConfiguration().getMaxPoolSize();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setInstanceId(String id) {
    }

    @Override
    public void setInstanceName(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runInThread(Runnable job) {
        Object object = this.lock;
        synchronized (object) {
            if (this.counter == 0) {
                return false;
            }
            --this.counter;
        }
        Runnable r = () -> {
            try {
                job.run();
            }
            finally {
                Object object = this.lock;
                synchronized (object) {
                    ++this.counter;
                    this.lock.notify();
                }
            }
        };
        this.executor.execute(r);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int blockForAvailableThreads() {
        Object object = this.lock;
        synchronized (object) {
            while (this.counter == 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean waitForJobsToComplete) {
        Object object = this.lock;
        synchronized (object) {
            this.counter = Integer.MAX_VALUE;
            this.lock.notify();
        }
        this.executor = null;
    }
}

