/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.request;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.javaxwrappers.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletResponse;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.RequestUtil;
import org.apache.sling.api.request.TooManyCallsException;
import org.apache.sling.api.request.builder.Builders;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletResponseWrapper;
import org.apache.sling.engine.impl.SlingJakartaHttpServletRequestImpl;
import org.apache.sling.engine.impl.SlingJakartaHttpServletResponseImpl;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.adapter.SlingServletRequestAdapter;
import org.apache.sling.engine.impl.adapter.SlingServletResponseAdapter;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.DispatchingInfo;
import org.apache.sling.engine.impl.request.SlingRequestPathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestData {
    private static final Logger log = LoggerFactory.getLogger(RequestData.class);
    public static final String REQUEST_RESOURCE_PATH_ATTR = "$$sling.request.resource$$";
    private static String REQUEST_MAX_CALL_OVERRIDE = "sling.max.calls";
    private final SlingRequestProcessorImpl slingRequestProcessor;
    private final long startTimestamp = System.currentTimeMillis();
    private final HttpServletRequest servletRequest;
    private final HttpServletResponse servletResponse;
    private final SlingJakartaHttpServletRequest slingRequest;
    private final SlingJakartaHttpServletResponse slingResponse;
    private final boolean protectHeadersOnInclude;
    private final boolean checkContentTypeOnInclude;
    private ParameterSupport parameterSupport;
    private ResourceResolver resourceResolver;
    private final RequestProgressTracker requestProgressTracker;
    private ContentData currentContentData;
    private int servletCallCounter;
    private String activeServletName;
    private int recursionDepth;
    private int peakRecusionDepth;
    private DispatchingInfo dispatchingInfo;
    private final boolean disableCheckCompliantGetUserPrincipal;
    private static volatile boolean loggedNonCompliantGetUserPrincipalWarning = false;
    private static final Set<Character> SKIPPED_TRAVERSAL_CHARS = new HashSet<Character>();

    public RequestData(SlingRequestProcessorImpl slingRequestProcessor, HttpServletRequest request, HttpServletResponse response, boolean protectHeadersOnInclude, boolean checkContentTypeOnInclude, boolean disableCheckCompliantGetUserPrincipal) {
        this.slingRequestProcessor = slingRequestProcessor;
        this.servletRequest = request;
        this.servletResponse = response;
        this.protectHeadersOnInclude = protectHeadersOnInclude;
        this.checkContentTypeOnInclude = checkContentTypeOnInclude;
        this.disableCheckCompliantGetUserPrincipal = disableCheckCompliantGetUserPrincipal;
        this.slingRequest = new SlingJakartaHttpServletRequestImpl(this, this.servletRequest);
        this.slingResponse = new SlingJakartaHttpServletResponseImpl(this, this.servletResponse);
        if (request instanceof SlingJakartaHttpServletRequest) {
            this.requestProgressTracker = ((SlingJakartaHttpServletRequest)request).getRequestProgressTracker();
        } else {
            Object o = request.getAttribute(RequestProgressTracker.class.getName());
            if (o instanceof RequestProgressTracker) {
                this.requestProgressTracker = (RequestProgressTracker)o;
            } else {
                log.warn("RequestProgressTracker not found in request attributes");
                this.requestProgressTracker = Builders.newRequestProgressTracker();
                this.requestProgressTracker.log("Method={0}, PathInfo={1}", new Object[]{request.getMethod(), request.getPathInfo()});
            }
        }
    }

    public Resource initResource(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.requestProgressTracker.startTimer("ResourceResolution");
        SlingJakartaHttpServletRequest request = this.getSlingRequest();
        StringBuffer requestURL = this.servletRequest.getRequestURL();
        String path = request.getPathInfo();
        if (requestURL.indexOf(";") > -1 && !path.contains(";")) {
            try {
                URL rUrl = new URL(requestURL.toString());
                String prefix = request.getContextPath().concat(request.getServletPath());
                path = rUrl.getPath().substring(prefix.length());
            }
            catch (MalformedURLException rUrl) {
                // empty catch block
            }
        }
        Resource resource = resourceResolver.resolve((HttpServletRequest)request, path);
        if (request.getAttribute(REQUEST_RESOURCE_PATH_ATTR) == null) {
            request.setAttribute(REQUEST_RESOURCE_PATH_ATTR, (Object)resource.getPath());
        }
        this.requestProgressTracker.logTimer("ResourceResolution", "URI={0} resolves to Resource={1}", new Object[]{this.getServletRequest().getRequestURI(), resource});
        return resource;
    }

    public void initServlet(Resource resource, ServletResolver sr) {
        SlingRequestPathInfo requestPathInfo = new SlingRequestPathInfo(resource);
        ContentData contentData = this.setContent(resource, requestPathInfo);
        this.requestProgressTracker.log("Resource Path Info: {0}", new Object[]{requestPathInfo});
        this.requestProgressTracker.startTimer("ServletResolution");
        Servlet servlet = sr.resolve(this.slingRequest);
        this.requestProgressTracker.logTimer("ServletResolution", "URI={0} handled by Servlet={1}", new Object[]{this.getServletRequest().getRequestURI(), servlet == null ? "-none-" : RequestUtil.getServletName((Servlet)servlet)});
        contentData.setServlet(servlet);
    }

    public SlingRequestProcessorImpl getSlingRequestProcessor() {
        return this.slingRequestProcessor;
    }

    public HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public SlingJakartaHttpServletRequest getSlingRequest() {
        return this.slingRequest;
    }

    public SlingJakartaHttpServletResponse getSlingResponse() {
        return this.slingResponse;
    }

    public DispatchingInfo getDispatchingInfo() {
        return this.dispatchingInfo;
    }

    public void setDispatchingInfo(DispatchingInfo dispatchingInfo) {
        this.dispatchingInfo = dispatchingInfo;
    }

    public static SlingJakartaHttpServletRequest unwrap(jakarta.servlet.ServletRequest request) {
        if (request instanceof SlingJakartaHttpServletRequest) {
            return (SlingJakartaHttpServletRequest)request;
        }
        while (request instanceof ServletRequestWrapper) {
            if (!((request = ((ServletRequestWrapper)request).getRequest()) instanceof SlingJakartaHttpServletRequest)) continue;
            return (SlingJakartaHttpServletRequest)request;
        }
        if (request instanceof HttpServletRequestWrapper) {
            Object req = ((HttpServletRequestWrapper)request).getRequest();
            while (req instanceof javax.servlet.ServletRequestWrapper) {
                req = ((javax.servlet.ServletRequestWrapper)req).getRequest();
            }
            if (req instanceof org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper) {
                return RequestData.unwrap(((org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper)req).getRequest());
            }
            if (req instanceof SlingHttpServletRequest) {
                req = ((HttpServletRequestWrapper)request).getRequest();
                do {
                    if (!(req instanceof SlingHttpServletRequest)) continue;
                    return JavaxToJakartaRequestWrapper.toJakartaRequest((SlingHttpServletRequest)((SlingHttpServletRequest)req));
                } while ((req = req instanceof javax.servlet.ServletRequestWrapper ? ((javax.servlet.ServletRequestWrapper)req).getRequest() : null) != null);
            }
            throw new IllegalArgumentException("ServletRequest not wrapping SlingJakartaHttpServletRequest: " + String.valueOf(req));
        }
        throw new IllegalArgumentException("ServletRequest not wrapping SlingJakartaHttpServletRequest: " + String.valueOf(request));
    }

    public static SlingJakartaHttpServletRequestImpl unwrap(SlingJakartaHttpServletRequest request) {
        while (request instanceof SlingJakartaHttpServletRequestWrapper) {
            request = ((SlingJakartaHttpServletRequestWrapper)request).getSlingRequest();
        }
        if (request instanceof HttpServletRequestWrapper) {
            ServletRequest req = ((HttpServletRequestWrapper)request).getRequest();
            while (req instanceof javax.servlet.ServletRequestWrapper) {
                req = ((javax.servlet.ServletRequestWrapper)req).getRequest();
            }
            if (req instanceof org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper) {
                jakarta.servlet.ServletRequest r = ((org.apache.felix.http.javaxwrappers.HttpServletRequestWrapper)req).getRequest();
                if (r instanceof SlingJakartaHttpServletRequest) {
                    return RequestData.unwrap((SlingJakartaHttpServletRequest)r);
                }
                throw new IllegalArgumentException("SlingJakartaHttpServletRequest not of correct type: " + String.valueOf(r));
            }
            throw new IllegalArgumentException("SlingJakartaHttpServletRequest not of correct type: " + String.valueOf(req));
        }
        if (request instanceof SlingJakartaHttpServletRequestImpl) {
            return (SlingJakartaHttpServletRequestImpl)request;
        }
        throw new IllegalArgumentException("SlingJakartaHttpServletRequest not of correct type: " + String.valueOf(request));
    }

    public static SlingJakartaHttpServletResponse unwrap(jakarta.servlet.ServletResponse response) {
        if (response instanceof SlingJakartaHttpServletResponse) {
            return (SlingJakartaHttpServletResponse)response;
        }
        while (response instanceof jakarta.servlet.ServletResponseWrapper) {
            if (!((response = ((jakarta.servlet.ServletResponseWrapper)response).getResponse()) instanceof SlingJakartaHttpServletResponse)) continue;
            return (SlingJakartaHttpServletResponse)response;
        }
        if (response instanceof org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper) {
            Object res = ((org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper)response).getResponse();
            while (res instanceof ServletResponseWrapper) {
                res = ((ServletResponseWrapper)res).getResponse();
            }
            if (res instanceof HttpServletResponseWrapper) {
                return RequestData.unwrap(((HttpServletResponseWrapper)res).getResponse());
            }
            if (res instanceof SlingHttpServletResponse) {
                res = ((org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper)response).getResponse();
                do {
                    if (!(res instanceof SlingHttpServletResponse)) continue;
                    return JavaxToJakartaResponseWrapper.toJakartaResponse((SlingHttpServletResponse)((SlingHttpServletResponse)res));
                } while ((res = res instanceof ServletResponseWrapper ? ((ServletResponseWrapper)res).getResponse() : null) != null);
            }
            throw new IllegalArgumentException("ServletResponse not wrapping SlingJakartaHttpServletResponse: " + String.valueOf(res));
        }
        throw new IllegalArgumentException("ServletResponse not wrapping SlingJakartaHttpServletResponse: " + String.valueOf(response));
    }

    public static SlingJakartaHttpServletResponseImpl unwrap(SlingJakartaHttpServletResponse response) {
        while (response instanceof SlingJakartaHttpServletResponseWrapper) {
            response = ((SlingJakartaHttpServletResponseWrapper)response).getSlingResponse();
        }
        if (response instanceof org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper) {
            ServletResponse res = ((org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper)response).getResponse();
            while (res instanceof ServletResponseWrapper) {
                res = ((ServletResponseWrapper)res).getResponse();
            }
            if (res instanceof HttpServletResponseWrapper) {
                jakarta.servlet.ServletResponse r = ((HttpServletResponseWrapper)res).getResponse();
                if (r instanceof SlingJakartaHttpServletResponse) {
                    return RequestData.unwrap((SlingJakartaHttpServletResponse)r);
                }
                throw new IllegalArgumentException("SlingJakartaHttpServletResponse not of correct type: " + String.valueOf(r));
            }
            throw new IllegalArgumentException("SlingJakartaHttpServletResponse not of correct type: " + String.valueOf(res));
        }
        if (response instanceof SlingJakartaHttpServletResponseImpl) {
            return (SlingJakartaHttpServletResponseImpl)response;
        }
        throw new IllegalArgumentException("SlingJakartaHttpServletResponse not of correct type: " + String.valueOf(response));
    }

    public static RequestData getRequestData(jakarta.servlet.ServletRequest request) {
        return RequestData.unwrap(RequestData.unwrap(request)).getRequestData();
    }

    public static RequestData getRequestData(SlingJakartaHttpServletRequest request) {
        return RequestData.unwrap(request).getRequestData();
    }

    public static SlingJakartaHttpServletRequest toSlingHttpServletRequest(jakarta.servlet.ServletRequest request) {
        SlingJakartaHttpServletRequest cRequest = RequestData.unwrap(request);
        RequestData.unwrap(cRequest);
        if (cRequest == request) {
            return cRequest;
        }
        if (!(request instanceof HttpServletRequest)) {
            throw new IllegalArgumentException("Request is not an HTTP request");
        }
        return new SlingServletRequestAdapter(cRequest, (HttpServletRequest)request);
    }

    public static SlingJakartaHttpServletResponse toSlingHttpServletResponse(jakarta.servlet.ServletResponse response) {
        SlingJakartaHttpServletResponse cResponse = RequestData.unwrap(response);
        if (cResponse == response) {
            return cResponse;
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new IllegalArgumentException("Response is not an HTTP response");
        }
        return new SlingServletResponseAdapter(cResponse, (HttpServletResponse)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void service(SlingJakartaHttpServletRequest request, SlingJakartaHttpServletResponse response) throws IOException, ServletException {
        if (!RequestData.isValidRequest(request.getRequestPathInfo().getResourcePath(), request.getRequestPathInfo().getSelectors())) {
            response.sendError(400, "Malformed request syntax");
            return;
        }
        RequestData requestData = RequestData.getRequestData(request);
        Servlet servlet = requestData.getContentData().getServlet();
        if (servlet == null) {
            log.warn("Did not find a servlet to handle the request (path={},selectors={},extension={},suffix={})", new Object[]{request.getRequestPathInfo().getResourcePath(), Arrays.toString(request.getRequestPathInfo().getSelectors()), request.getRequestPathInfo().getExtension(), request.getRequestPathInfo().getSuffix()});
            response.sendError(404, "No Servlet to handle request");
        } else {
            String name = RequestUtil.getServletName((Servlet)servlet);
            if (requestData.hasServletMaxCallCount((jakarta.servlet.ServletRequest)request)) {
                throw new TooManyCallsException(name);
            }
            Object oldValue = request.getAttribute("sling.core.current.servletName");
            request.setAttribute("sling.core.current.servletName", (Object)name);
            String timerName = name + "#" + requestData.servletCallCounter;
            ++requestData.servletCallCounter;
            requestData.getRequestProgressTracker().startTimer(timerName);
            String prevServletName = requestData.setActiveServletName(name);
            try {
                servlet.service((jakarta.servlet.ServletRequest)request, (jakarta.servlet.ServletResponse)response);
            }
            finally {
                requestData.setActiveServletName(prevServletName);
                request.setAttribute("sling.core.current.servletName", oldValue);
                requestData.getRequestProgressTracker().logTimer(timerName);
            }
        }
    }

    static boolean isValidRequest(String resourcePath, String ... selectors) {
        for (String selector : selectors) {
            if (!selector.trim().isEmpty()) continue;
            return false;
        }
        return resourcePath == null || !RequestData.traversesParentPath(resourcePath);
    }

    public ContentData setContent(Resource resource, RequestPathInfo requestPathInfo) {
        if (this.recursionDepth >= this.slingRequestProcessor.getMaxIncludeCounter()) {
            throw new RecursionTooDeepException(requestPathInfo.getResourcePath());
        }
        ++this.recursionDepth;
        if (this.recursionDepth > this.peakRecusionDepth) {
            this.peakRecusionDepth = this.recursionDepth;
        }
        this.currentContentData = new ContentData(resource, requestPathInfo);
        return this.currentContentData;
    }

    public void resetContent(ContentData data) {
        --this.recursionDepth;
        this.currentContentData = data;
    }

    public ContentData getContentData() {
        return this.currentContentData;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public RequestProgressTracker getRequestProgressTracker() {
        return this.requestProgressTracker;
    }

    public int getPeakRecusionDepth() {
        return this.peakRecusionDepth;
    }

    public int getServletCallCount() {
        return this.servletCallCounter;
    }

    public boolean protectHeadersOnInclude() {
        return this.protectHeadersOnInclude;
    }

    public boolean checkContentTypeOnInclude() {
        return this.checkContentTypeOnInclude;
    }

    private boolean hasServletMaxCallCount(jakarta.servlet.ServletRequest request) {
        log.debug("Servlet call counter : {}", (Object)this.getServletCallCount());
        int maxCallCounter = this.slingRequestProcessor.getMaxCallCounter();
        Object reqMaxOverride = request.getAttribute(REQUEST_MAX_CALL_OVERRIDE);
        if (reqMaxOverride instanceof Number) {
            maxCallCounter = ((Number)reqMaxOverride).intValue();
        }
        return maxCallCounter >= 0 && this.getServletCallCount() >= maxCallCounter;
    }

    public long getElapsedTimeMsec() {
        return System.currentTimeMillis() - this.startTimestamp;
    }

    public String setActiveServletName(String servletName) {
        String old = this.activeServletName;
        this.activeServletName = servletName;
        return old;
    }

    public String getActiveServletName() {
        return this.activeServletName;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getInputStream();
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IOException {
        if (this.parameterSupport != null && this.parameterSupport.requestDataUsed()) {
            throw new IllegalStateException("Request Data has already been read");
        }
        return this.getServletRequest().getReader();
    }

    public ParameterSupport getParameterSupport() {
        if (this.parameterSupport == null) {
            this.parameterSupport = ParameterSupport.getInstance(this.getServletRequest());
        }
        return this.parameterSupport;
    }

    private static boolean traversesParentPath(String path) {
        for (int index = 0; index < path.length(); ++index) {
            int charCount = 0;
            int dotCount = 0;
            while (index < path.length() && path.charAt(index) != '/') {
                char c = path.charAt(index);
                if (!SKIPPED_TRAVERSAL_CHARS.contains(Character.valueOf(c))) {
                    if (c == '.') {
                        ++dotCount;
                    }
                    ++charCount;
                }
                ++index;
            }
            if (charCount <= true || dotCount != charCount) continue;
            return true;
        }
        return false;
    }

    public boolean isDisableCheckCompliantGetUserPrincipal() {
        return this.disableCheckCompliantGetUserPrincipal;
    }

    public void logNonCompliantGetUserPrincipalWarning() {
        if (!loggedNonCompliantGetUserPrincipalWarning) {
            loggedNonCompliantGetUserPrincipalWarning = true;
            log.warn("Request.getUserPrincipal() called without a remoteUser set. This is not compliant to the servlet spec and might return a principal even if the request is not authenticated. Please update your code to use getAuthType() to check for anonymous requests first.");
        }
    }

    static {
        SKIPPED_TRAVERSAL_CHARS.add(Character.valueOf('['));
        SKIPPED_TRAVERSAL_CHARS.add(Character.valueOf('}'));
    }
}

