/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonException;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonArrayImpl;
import org.apache.johnzon.core.JsonDoubleImpl;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;
import org.apache.johnzon.core.util.ArrayUtil;

class JsonArrayBuilderImpl
implements JsonArrayBuilder,
Serializable {
    private RejectDuplicateKeysMode rejectDuplicateKeysMode;
    private List<JsonValue> tmpList;
    private BufferStrategy.BufferProvider<char[]> bufferProvider;

    protected JsonArrayBuilderImpl() {
    }

    public JsonArrayBuilderImpl(JsonArray initialData, BufferStrategy.BufferProvider<char[]> provider, RejectDuplicateKeysMode rejectDuplicateKeysMode) {
        this.tmpList = new ArrayList<JsonValue>((Collection<JsonValue>)initialData);
        this.bufferProvider = provider;
        this.rejectDuplicateKeysMode = rejectDuplicateKeysMode;
    }

    public JsonArrayBuilderImpl(Collection<?> initialData, BufferStrategy.BufferProvider<char[]> provider, RejectDuplicateKeysMode rejectDuplicateKeysMode) {
        this.bufferProvider = provider;
        this.rejectDuplicateKeysMode = rejectDuplicateKeysMode;
        this.tmpList = new ArrayList<JsonValue>();
        if (!initialData.isEmpty()) {
            for (Object initialValue : initialData) {
                this.add(initialValue);
            }
        }
    }

    public JsonArrayBuilder addAll(JsonArrayBuilder builder) {
        builder.build().forEach(this::add);
        return this;
    }

    public JsonArrayBuilder add(int index, JsonValue value) {
        this.addValue(index, value);
        return this;
    }

    public JsonArrayBuilder add(int index, String value) {
        this.addValue(index, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, BigDecimal value) {
        this.addValue(index, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, BigInteger value) {
        this.addValue(index, (JsonValue)new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    public JsonArrayBuilder add(int index, int value) {
        this.addValue(index, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, long value) {
        this.addValue(index, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, double value) {
        this.addValue(index, (JsonValue)new JsonDoubleImpl(value));
        return this;
    }

    public JsonArrayBuilder add(int index, boolean value) {
        this.addValue(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull(int index) {
        this.addValue(index, JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(int index, JsonObjectBuilder builder) {
        this.addValue(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(int index, JsonArrayBuilder builder) {
        this.addValue(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder set(int index, JsonValue value) {
        this.setValue(index, value);
        return this;
    }

    public JsonArrayBuilder set(int index, String value) {
        this.setValue(index, (JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, BigDecimal value) {
        this.setValue(index, (JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, BigInteger value) {
        this.setValue(index, (JsonValue)new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    public JsonArrayBuilder set(int index, int value) {
        this.setValue(index, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, long value) {
        this.setValue(index, (JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, double value) {
        this.setValue(index, (JsonValue)new JsonDoubleImpl(value));
        return this;
    }

    public JsonArrayBuilder set(int index, boolean value) {
        this.setValue(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder setNull(int index) {
        this.setValue(index, JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder set(int index, JsonObjectBuilder builder) {
        this.setValue(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder set(int index, JsonArrayBuilder builder) {
        this.setValue(index, (JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder remove(int index) {
        this.tmpList.remove(index);
        return this;
    }

    public JsonArrayBuilder add(Object value) {
        if (value instanceof JsonValue) {
            this.add((JsonValue)value);
        } else if (value instanceof BigDecimal) {
            this.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.add((BigInteger)value);
        } else if (value instanceof Boolean) {
            this.add((Boolean)value);
        } else if (value instanceof Double) {
            this.add((Double)value);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof Long) {
            this.add((Long)value);
        } else if (value instanceof String) {
            this.add((String)value);
        } else if (value instanceof Map) {
            this.add((JsonValue)new JsonObjectBuilderImpl((Map)Map.class.cast(value), this.bufferProvider, this.rejectDuplicateKeysMode).build());
        } else if (value instanceof Collection) {
            this.add((JsonValue)new JsonArrayBuilderImpl((Collection)Collection.class.cast(value), this.bufferProvider, this.rejectDuplicateKeysMode).build());
        } else if (value.getClass().isArray()) {
            Collection<Object> collection = ArrayUtil.newCollection(value);
            this.add((JsonValue)new JsonArrayBuilderImpl(collection, this.bufferProvider, this.rejectDuplicateKeysMode).build());
        } else {
            throw new JsonException("Illegal JSON type! type=" + value.getClass());
        }
        return this;
    }

    public JsonArrayBuilder add(JsonValue value) {
        this.addValue(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        this.addValue((JsonValue)new JsonStringImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        this.addValue((JsonValue)new JsonNumberImpl(value));
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        this.addValue((JsonValue)new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.addValue((JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.addValue((JsonValue)new JsonLongImpl(value));
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.addValue((JsonValue)new JsonDoubleImpl(value));
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.addValue(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.addValue(JsonValue.NULL);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.addValue((JsonValue)builder.build());
        return this;
    }

    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.addValue((JsonValue)builder.build());
        return this;
    }

    private void setValue(int idx, JsonValue value) {
        if (value == null || this.tmpList == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        this.tmpList.set(idx, value);
    }

    private void addValue(JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(value);
    }

    private void addValue(int idx, JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(idx, value);
    }

    public JsonArray build() {
        if (this.tmpList == null) {
            return JsonValue.EMPTY_JSON_ARRAY;
        }
        return new JsonArrayImpl(Collections.unmodifiableList(this.tmpList), this.bufferProvider);
    }

    private static NullPointerException npe() {
        throw new NullPointerException("value/builder must not be null");
    }
}

