/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Default;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ExtraDefaultTests {
    @Mock
    private Resource resource;
    private ModelAdapterFactory factory;

    ExtraDefaultTests() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{EmptyDefaultsModel.class, WrongTypeDefaultsModel.class});
    }

    @Test
    void testEmptyDefaultsPrimitiveArrays() {
        EmptyDefaultsModel model = (EmptyDefaultsModel)this.factory.getAdapter((Object)this.resource, EmptyDefaultsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.booleanArray);
        Assert.assertEquals((long)0L, (long)model.booleanArray.length);
        Assert.assertNotNull((Object)model.doubleArray);
        Assert.assertEquals((long)0L, (long)model.doubleArray.length);
        Assert.assertNotNull((Object)model.floatArray);
        Assert.assertEquals((long)0L, (long)model.floatArray.length);
        Assert.assertNotNull((Object)model.intArray);
        Assert.assertEquals((long)0L, (long)model.intArray.length);
        Assert.assertNotNull((Object)model.longArray);
        Assert.assertEquals((long)0L, (long)model.longArray.length);
        Assert.assertNotNull((Object)model.shortArray);
        Assert.assertEquals((long)0L, (long)model.shortArray.length);
    }

    @Test
    void testEmptyDefaultsWrapperArrays() {
        EmptyDefaultsModel model = (EmptyDefaultsModel)this.factory.getAdapter((Object)this.resource, EmptyDefaultsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.booleanWrapperArray);
        Assert.assertEquals((long)0L, (long)model.booleanWrapperArray.length);
        Assert.assertNotNull((Object)model.doubleWrapperArray);
        Assert.assertEquals((long)0L, (long)model.doubleWrapperArray.length);
        Assert.assertNotNull((Object)model.floatWrapperArray);
        Assert.assertEquals((long)0L, (long)model.floatWrapperArray.length);
        Assert.assertNotNull((Object)model.intWrapperArray);
        Assert.assertEquals((long)0L, (long)model.intWrapperArray.length);
        Assert.assertNotNull((Object)model.longWrapperArray);
        Assert.assertEquals((long)0L, (long)model.longWrapperArray.length);
        Assert.assertNotNull((Object)model.shortWrapperArray);
        Assert.assertEquals((long)0L, (long)model.shortWrapperArray.length);
        Assert.assertNotNull((Object)model.stringArray);
        Assert.assertEquals((long)0L, (long)model.stringArray.length);
    }

    @Test
    void testEmptyDefaultsScalars() {
        EmptyDefaultsModel model = (EmptyDefaultsModel)this.factory.getAdapter((Object)this.resource, EmptyDefaultsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)false, (Object)model.singleBoolean);
        Assert.assertEquals((double)0.0, (double)model.singleDouble, (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)model.singleFloat, (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)model.singleInt);
        Assert.assertEquals((long)0L, (long)model.singleLong);
        Assert.assertEquals((long)0L, (long)model.singleShort);
        Assert.assertEquals((Object)false, (Object)model.singleBooleanWrapper);
        Assert.assertEquals((double)0.0, (double)model.singleDoubleWrapper, (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)model.singleFloatWrapper.floatValue(), (double)1.0E-4);
        Assert.assertEquals((long)0L, (long)model.singleIntWrapper.intValue());
        Assert.assertEquals((long)0L, (long)model.singleShortWrapper.shortValue());
        Assert.assertEquals((long)0L, (long)model.singleLongWrapper);
        Assert.assertEquals((Object)"", (Object)model.singleString);
    }

    @Test
    void testWrongDefaultValues() {
        WrongTypeDefaultsModel model = (WrongTypeDefaultsModel)this.factory.getAdapter((Object)this.resource, WrongTypeDefaultsModel.class);
        Assert.assertNotNull((Object)model);
        Assert.assertNotNull((Object)model.booleanArray);
        Assert.assertEquals((long)0L, (long)model.booleanArray.length);
        Assert.assertNotNull((Object)model.doubleArray);
        Assert.assertEquals((long)0L, (long)model.doubleArray.length);
        Assert.assertNotNull((Object)model.floatArray);
        Assert.assertEquals((long)0L, (long)model.floatArray.length);
        Assert.assertNotNull((Object)model.intArray);
        Assert.assertEquals((long)0L, (long)model.intArray.length);
        Assert.assertNotNull((Object)model.longArray);
        Assert.assertEquals((long)0L, (long)model.longArray.length);
        Assert.assertNotNull((Object)model.shortArray);
        Assert.assertEquals((long)0L, (long)model.shortArray.length);
        Assert.assertNotNull((Object)model.stringArray);
        Assert.assertEquals((long)0L, (long)model.stringArray.length);
    }

    @Model(adaptables={Resource.class})
    public static class EmptyDefaultsModel {
        @Inject
        @Default
        private boolean[] booleanArray;
        @Inject
        @Default
        private double[] doubleArray;
        @Inject
        @Default
        private float[] floatArray;
        @Inject
        @Default
        private int[] intArray;
        @Inject
        @Default
        private long[] longArray;
        @Inject
        @Default
        private short[] shortArray;
        @Inject
        @Default
        private Boolean[] booleanWrapperArray;
        @Inject
        @Default
        private Double[] doubleWrapperArray;
        @Inject
        @Default
        private Float[] floatWrapperArray;
        @Inject
        @Default
        private Integer[] intWrapperArray;
        @Inject
        @Default
        private Long[] longWrapperArray;
        @Inject
        @Default
        private Short[] shortWrapperArray;
        @Inject
        @Default
        private String[] stringArray;
        @Inject
        @Default
        private boolean singleBoolean;
        @Inject
        @Default
        private double singleDouble;
        @Inject
        @Default
        private float singleFloat;
        @Inject
        @Default
        private int singleInt;
        @Inject
        @Default
        private long singleLong;
        @Inject
        @Default
        private short singleShort;
        @Inject
        @Default
        private Boolean singleBooleanWrapper;
        @Inject
        @Default
        private Double singleDoubleWrapper;
        @Inject
        @Default
        private Float singleFloatWrapper;
        @Inject
        @Default
        private Integer singleIntWrapper;
        @Inject
        @Default
        private Long singleLongWrapper;
        @Inject
        @Default
        private Short singleShortWrapper;
        @Inject
        @Default
        private String singleString;
    }

    @Model(adaptables={Resource.class})
    public static class WrongTypeDefaultsModel {
        @Inject
        @Default(intValues={1, 1})
        private boolean[] booleanArray;
        @Inject
        @Default(intValues={1, 1})
        private double[] doubleArray;
        @Inject
        @Default(intValues={1, 1})
        private float[] floatArray;
        @Inject
        @Default(longValues={1L, 1L})
        private int[] intArray;
        @Inject
        @Default(intValues={1, 1})
        private long[] longArray;
        @Inject
        @Default(intValues={1, 1})
        private short[] shortArray;
        @Inject
        @Default(intValues={1, 1})
        private String[] stringArray;
    }
}

