/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.SlingJakartaHttpServletRequestWrapper;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.spi.DisposalCallback;
import org.apache.sling.models.spi.DisposalCallbackRegistry;
import org.apache.sling.models.spi.Injector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;

@ExtendWith(value={MockitoExtension.class})
class RequestDisposalTest {
    @Mock
    private Resource resource;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private ServletContext servletContext;
    private ModelAdapterFactory factory;
    private Set<TestDisposalCallback> callbacks;

    RequestDisposalTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new DisposedInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{TestModel.class});
        final HashMap attributes = new HashMap();
        ((SlingJakartaHttpServletRequest)Mockito.lenient().doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) {
                attributes.put((String)invocation.getArguments()[0], invocation.getArguments()[1]);
                return null;
            }
        }).when((Object)this.request)).setAttribute((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any());
        Mockito.lenient().when(this.request.getAttribute((String)ArgumentMatchers.any(String.class))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) {
                return attributes.get(invocation.getArguments()[0]);
            }
        });
        this.callbacks = new HashSet<TestDisposalCallback>();
    }

    @Test
    void testWithInitializedRequest() {
        SlingJakartaHttpServletRequestWrapper destroyedRequest = new SlingJakartaHttpServletRequestWrapper(this.request);
        this.factory.requestInitialized(new ServletRequestEvent(this.servletContext, (ServletRequest)destroyedRequest));
        SlingJakartaHttpServletRequestWrapper adaptableRequest = new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)destroyedRequest));
        TestModel model = (TestModel)this.factory.getAdapter((Object)adaptableRequest, TestModel.class);
        Assert.assertEquals((Object)"teststring", (Object)model.testString);
        this.assertNoneDisposed();
        this.factory.requestDestroyed(new ServletRequestEvent(this.servletContext, (ServletRequest)destroyedRequest));
        this.assertAllDisposed();
    }

    @Test
    void testTwoInstancesWithInitializedRequest() {
        SlingJakartaHttpServletRequestWrapper destroyedRequest = new SlingJakartaHttpServletRequestWrapper(this.request);
        this.factory.requestInitialized(new ServletRequestEvent(this.servletContext, (ServletRequest)destroyedRequest));
        SlingJakartaHttpServletRequestWrapper adaptableRequest = new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)destroyedRequest));
        TestModel model = (TestModel)this.factory.getAdapter((Object)adaptableRequest, TestModel.class);
        Assert.assertEquals((Object)"teststring", (Object)model.testString);
        TestModel model2 = (TestModel)this.factory.getAdapter((Object)adaptableRequest, TestModel.class);
        Assert.assertEquals((Object)"teststring", (Object)model2.testString);
        this.assertNoneDisposed();
        this.factory.requestDestroyed(new ServletRequestEvent(this.servletContext, (ServletRequest)destroyedRequest));
        this.assertAllDisposed();
    }

    @Test
    void testWithUnitializedRequest() {
        SlingJakartaHttpServletRequestWrapper destroyedRequest = new SlingJakartaHttpServletRequestWrapper(this.request);
        SlingJakartaHttpServletRequestWrapper adaptableRequest = new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)new SlingJakartaHttpServletRequestWrapper((SlingJakartaHttpServletRequest)destroyedRequest));
        TestModel model = (TestModel)this.factory.getAdapter((Object)adaptableRequest, TestModel.class);
        Assert.assertEquals((Object)"teststring", (Object)model.testString);
        this.assertNoneDisposed();
        this.factory.requestDestroyed(new ServletRequestEvent(this.servletContext, (ServletRequest)destroyedRequest));
        this.assertNoneDisposed();
    }

    private void assertNoneDisposed() {
        for (TestDisposalCallback callback : this.callbacks) {
            Assert.assertFalse((boolean)callback.isDisposed());
        }
    }

    private void assertAllDisposed() {
        for (TestDisposalCallback callback : this.callbacks) {
            Assert.assertTrue((boolean)callback.isDisposed());
        }
    }

    private class DisposedInjector
    implements Injector {
        private DisposedInjector() {
        }

        @NotNull
        public String getName() {
            return "disposed";
        }

        @Nullable
        public Object getValue(@NotNull Object o, String s, @NotNull Type type, @NotNull AnnotatedElement annotatedElement, @NotNull DisposalCallbackRegistry disposalCallbackRegistry) {
            TestDisposalCallback callback = new TestDisposalCallback();
            RequestDisposalTest.this.callbacks.add(callback);
            disposalCallbackRegistry.addDisposalCallback((DisposalCallback)callback);
            return "teststring";
        }
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class TestModel {
        @Inject
        public String testString;
    }

    private class TestDisposalCallback
    implements DisposalCallback {
        private boolean disposed = false;

        private TestDisposalCallback() {
        }

        public void onDisposed() {
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

