/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.chain;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.chain.Chain;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ChainReducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private Chain chain;

    public static void setReducer(Job job, Class<? extends Reducer> klass, Class<?> inputKeyClass, Class<?> inputValueClass, Class<?> outputKeyClass, Class<?> outputValueClass, Configuration reducerConf) {
        job.setReducerClass(ChainReducer.class);
        job.setOutputKeyClass(outputKeyClass);
        job.setOutputValueClass(outputValueClass);
        Chain.setReducer(job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, reducerConf);
    }

    public static void addMapper(Job job, Class<? extends Mapper> klass, Class<?> inputKeyClass, Class<?> inputValueClass, Class<?> outputKeyClass, Class<?> outputValueClass, Configuration mapperConf) throws IOException {
        job.setOutputKeyClass(outputKeyClass);
        job.setOutputValueClass(outputValueClass);
        Chain.addMapper(false, job, klass, inputKeyClass, inputValueClass, outputKeyClass, outputValueClass, mapperConf);
    }

    @Override
    protected void setup(Reducer.Context context) {
        this.chain = new Chain(false);
        this.chain.setup(context.getConfiguration());
    }

    @Override
    public void run(Reducer.Context context) throws IOException, InterruptedException {
        this.setup(context);
        if (this.chain.getReducer() == null) {
            return;
        }
        int numMappers = this.chain.getAllMappers().size();
        if (numMappers == 0) {
            this.chain.runReducer(context);
            return;
        }
        Chain.ChainBlockingQueue<Chain.KeyValuePair<?, ?>> outputqueue = this.chain.createBlockingQueue();
        this.chain.addReducer(context, outputqueue);
        for (int i = 0; i < numMappers - 1; ++i) {
            Chain.ChainBlockingQueue<Chain.KeyValuePair<?, ?>> inputqueue = outputqueue;
            outputqueue = this.chain.createBlockingQueue();
            this.chain.addMapper(inputqueue, outputqueue, context, i);
        }
        this.chain.addMapper(outputqueue, context, numMappers - 1);
        this.chain.startAllThreads();
        this.chain.joinAllThreads();
    }
}

