/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.kafka;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.storm.kafka.BrokerHosts;
import org.apache.storm.kafka.ZkHosts;
import org.apache.storm.kafka.trident.OpaqueTridentKafkaSpout;
import org.apache.storm.kafka.trident.TridentKafkaConfig;
import org.apache.storm.kafka.trident.TridentKafkaStateFactory;
import org.apache.storm.kafka.trident.TridentKafkaUpdater;
import org.apache.storm.kafka.trident.mapper.TridentTupleToKafkaMapper;
import org.apache.storm.kafka.trident.selector.DefaultTopicSelector;
import org.apache.storm.kafka.trident.selector.KafkaTopicSelector;
import org.apache.storm.spout.Scheme;
import org.apache.storm.spout.SchemeAsMultiScheme;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.sql.runtime.SimpleSqlTridentConsumer;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.trident.spout.ITridentDataSource;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.tuple.TridentTuple;

public class KafkaDataSourcesProvider
implements DataSourcesProvider {
    private static final int DEFAULT_ZK_PORT = 2181;

    public String scheme() {
        return "kafka";
    }

    public DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        throw new UnsupportedOperationException();
    }

    public ISqlTridentDataSource constructTrident(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        int port = uri.getPort() != -1 ? uri.getPort() : 2181;
        ZkHosts zk = new ZkHosts(uri.getHost() + ":" + port, uri.getPath());
        Map<String, String> values = KafkaDataSourcesProvider.parseURIParams(uri.getQuery());
        String topic = values.get("topic");
        Preconditions.checkNotNull((Object)topic, (Object)"No topic of the spout is specified");
        TridentKafkaConfig conf = new TridentKafkaConfig((BrokerHosts)zk, topic);
        ArrayList<String> fieldNames = new ArrayList<String>();
        int primaryIndex = -1;
        for (int i = 0; i < fields.size(); ++i) {
            FieldInfo f = fields.get(i);
            fieldNames.add(f.name());
            if (!f.isPrimary()) continue;
            primaryIndex = i;
        }
        Preconditions.checkState((primaryIndex != -1 ? 1 : 0) != 0, (Object)"Kafka stream table must have a primary key");
        Scheme scheme = SerdeUtils.getScheme((String)inputFormatClass, (Properties)properties, fieldNames);
        conf.scheme = new SchemeAsMultiScheme(scheme);
        IOutputSerializer serializer = SerdeUtils.getSerializer((String)outputFormatClass, (Properties)properties, fieldNames);
        return new KafkaTridentDataSource(conf, topic, primaryIndex, properties, serializer);
    }

    private static Map<String, String> parseURIParams(String query) {
        String[] params;
        HashMap<String, String> res = new HashMap<String, String>();
        if (query == null) {
            return res;
        }
        for (String p : params = query.split("&")) {
            String[] v = p.split("=", 2);
            if (v.length <= 1) continue;
            res.put(v[0], v[1]);
        }
        return res;
    }

    private static class KafkaTridentDataSource
    implements ISqlTridentDataSource {
        private final TridentKafkaConfig conf;
        private final String topic;
        private final int primaryKeyIndex;
        private final Properties props;
        private final IOutputSerializer serializer;

        private KafkaTridentDataSource(TridentKafkaConfig conf, String topic, int primaryKeyIndex, Properties props, IOutputSerializer serializer) {
            this.conf = conf;
            this.topic = topic;
            this.primaryKeyIndex = primaryKeyIndex;
            this.props = props;
            this.serializer = serializer;
        }

        public ITridentDataSource getProducer() {
            return new OpaqueTridentKafkaSpout(this.conf);
        }

        public ISqlTridentDataSource.SqlTridentConsumer getConsumer() {
            Preconditions.checkArgument((!this.props.isEmpty() ? 1 : 0) != 0, (Object)("Writable Kafka Table " + this.topic + " must contain producer config"));
            HashMap producerConfig = (HashMap)this.props.get("producer");
            this.props.putAll((Map<?, ?>)producerConfig);
            Preconditions.checkState((boolean)this.props.containsKey("bootstrap.servers"), (Object)("Writable Kafka Table " + this.topic + " must contain \"bootstrap.servers\" config"));
            SqlKafkaMapper mapper = new SqlKafkaMapper(this.primaryKeyIndex, this.serializer);
            TridentKafkaStateFactory stateFactory = new TridentKafkaStateFactory().withKafkaTopicSelector((KafkaTopicSelector)new DefaultTopicSelector(this.topic)).withProducerProperties(this.props).withTridentTupleToKafkaMapper((TridentTupleToKafkaMapper)mapper);
            TridentKafkaUpdater stateUpdater = new TridentKafkaUpdater();
            return new SimpleSqlTridentConsumer((StateFactory)stateFactory, (StateUpdater)stateUpdater);
        }
    }

    private static class SqlKafkaMapper
    implements TridentTupleToKafkaMapper<Object, ByteBuffer> {
        private final int primaryKeyIndex;
        private final IOutputSerializer serializer;

        private SqlKafkaMapper(int primaryKeyIndex, IOutputSerializer serializer) {
            this.primaryKeyIndex = primaryKeyIndex;
            this.serializer = serializer;
        }

        public Object getKeyFromTuple(TridentTuple tuple) {
            return tuple.get(this.primaryKeyIndex);
        }

        public ByteBuffer getMessageFromTuple(TridentTuple tuple) {
            return this.serializer.write(tuple.getValues(), null);
        }
    }
}

