/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import org.apache.tiles.CompareUtil;

public class Expression {
    private String expression;
    private String language;

    public Expression(String expression, String language) {
        this.expression = expression;
        this.language = language;
    }

    public Expression(String expression) {
        this(expression, null);
    }

    public Expression(Expression toCopy) {
        this.expression = toCopy.expression;
        this.language = toCopy.language;
    }

    public static Expression createExpressionFromDescribedExpression(String describedExpression) {
        if (describedExpression != null) {
            String language = null;
            String expression = describedExpression;
            if (describedExpression.matches("[a-zA-Z0-9]+:.+")) {
                language = describedExpression.substring(0, describedExpression.indexOf(58));
                expression = describedExpression.substring(describedExpression.indexOf(58) + 1);
            }
            return new Expression(expression, language);
        }
        return null;
    }

    public static Expression createExpression(String expression, String language) {
        if (expression != null) {
            return new Expression(expression, language);
        }
        return null;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean equals(Object obj) {
        Expression exp = (Expression)obj;
        return CompareUtil.nullSafeEquals(this.expression, exp.expression) && CompareUtil.nullSafeEquals(this.language, exp.language);
    }

    public int hashCode() {
        return CompareUtil.nullSafeHashCode(this.expression) + CompareUtil.nullSafeHashCode(this.language);
    }

    public String toString() {
        return (this.language == null ? "DEFAULT" : this.language) + ":" + this.expression;
    }
}

