/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.ant;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.ImmutableSortedSet;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.Compiler;
import com.google.gxp.compiler.Configuration;
import com.google.gxp.compiler.InvalidConfigException;
import com.google.gxp.compiler.Phase;
import com.google.gxp.compiler.alerts.Alert;
import com.google.gxp.compiler.alerts.AlertCounter;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.ConfigurableAlertPolicy;
import com.google.gxp.compiler.ant.LoggingAlertSink;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.codegen.CodeGeneratorFactory;
import com.google.gxp.compiler.codegen.DefaultCodeGeneratorFactory;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileSystem;
import com.google.gxp.compiler.fs.SourcePathFileSystem;
import com.google.gxp.compiler.fs.SystemFileSystem;
import com.google.gxp.compiler.i18ncheck.UnextractableContentAlert;
import com.google.gxp.compiler.parser.FileSystemEntityResolver;
import com.google.gxp.compiler.parser.SourceEntityResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import java.util.SortedSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Task;

public class GxpcTask
extends Task
implements Configuration {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.gxp"};
    private final FileSystem fs;
    private final FileRef cwd;
    private final FileScanner fileScanner = new DirectoryScanner();
    private ImmutableSet<FileRef> sourceFiles;
    private ImmutableSet<FileRef> schemaFiles;
    private ImmutableSet<OutputLanguage> outputLanguages;
    private DefaultCodeGeneratorFactory codeGeneratorFactory;
    private FileRef propertiesFile;
    private AlertPolicy alertPolicy;
    private ImmutableSortedSet<Phase> dotPhases;
    private SourceEntityResolver sourceEntityResolver;
    private String srcpaths;
    private String schemas = null;
    private String destdir;
    private String target;
    private boolean dynamic = false;
    private boolean i18nwarn = false;

    public GxpcTask(FileSystem fs, FileRef cwd) {
        this.fs = Preconditions.checkNotNull(fs);
        this.cwd = Preconditions.checkNotNull(cwd);
        this.fileScanner.setIncludes(DEFAULT_INCLUDES);
    }

    public GxpcTask() {
        this(SystemFileSystem.INSTANCE, SystemFileSystem.INSTANCE.parseFilename(System.getProperty("user.dir")));
    }

    public void execute() throws BuildException {
        this.configure();
        LoggingAlertSink alertSink = new LoggingAlertSink(this.getAlertPolicy(), this);
        AlertCounter counter = new AlertCounter(alertSink, this.getAlertPolicy());
        try {
            new Compiler(this).call(counter);
        }
        catch (InvalidConfigException e) {
            throw new BuildException((Throwable)e);
        }
        if (counter.getErrorCount() > 0) {
            throw new BuildException("Compile failed; see the compiler error output for details.");
        }
    }

    public void configure() throws BuildException {
        if (this.fileScanner.getBasedir() == null) {
            throw new BuildException("Attribute 'srcdir' was not set.");
        }
        this.fileScanner.scan();
        String baseDir = this.fileScanner.getBasedir().getPath() + File.separator;
        ArrayList<FileRef> underlyingInputFiles = Lists.newArrayList();
        for (String includedFile : this.fileScanner.getIncludedFiles()) {
            underlyingInputFiles.add(this.fs.parseFilename(baseDir + includedFile));
        }
        if (this.destdir == null) {
            this.log("Attribute 'destdir' was not set, the current working directory will be used.", 1);
        }
        FileRef outputDir = this.destdir == null ? this.cwd : this.fs.parseFilename(this.destdir);
        ImmutableSet<FileRef> sourcePaths = this.srcpaths == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.fs.parseFilenameList(this.srcpaths));
        SourcePathFileSystem sourcePathFs = new SourcePathFileSystem(this.fs, sourcePaths, underlyingInputFiles, outputDir);
        this.sourceFiles = ImmutableSet.copyOf(sourcePathFs.getSourceFileRefs());
        this.schemaFiles = this.schemas == null ? ImmutableSet.of() : ImmutableSet.copyOf(this.fs.parseFilenameList(this.schemas));
        this.outputLanguages = ImmutableSet.of(OutputLanguage.JAVA);
        this.propertiesFile = this.target != null ? outputDir.join("/" + this.target.replace(".", "/") + "_en.properties") : null;
        this.alertPolicy = this.computeAlertPolicy();
        this.dotPhases = GxpcTask.computeDotPhases();
        this.sourceEntityResolver = new FileSystemEntityResolver(sourcePathFs);
        this.codeGeneratorFactory = new DefaultCodeGeneratorFactory();
        this.codeGeneratorFactory.setRuntimeMessageSource(this.target);
        this.codeGeneratorFactory.setDynamicModeEnabled(this.dynamic);
        this.codeGeneratorFactory.setSourceFiles(this.getSourceFiles());
        this.codeGeneratorFactory.setSchemaFiles(this.getSchemaFiles());
        this.codeGeneratorFactory.setSourcePaths(sourcePaths);
        this.codeGeneratorFactory.setAlertPolicy(this.getAlertPolicy());
    }

    public void setSrcpaths(String srcpaths) {
        this.srcpaths = srcpaths;
    }

    public void setSrcdir(String srcdir) {
        this.fileScanner.setBasedir(srcdir);
    }

    public void setIncludes(String includes) {
        this.fileScanner.setIncludes(includes.split(","));
    }

    public void setExcludes(String excludes) {
        this.fileScanner.setExcludes(excludes.split(","));
    }

    public void setDestdir(String destdir) {
        this.destdir = destdir;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public void setI18nwarn(boolean i18nwarn) {
        this.i18nwarn = i18nwarn;
    }

    @Override
    public Set<FileRef> getSourceFiles() {
        return this.sourceFiles;
    }

    @Override
    public Set<FileRef> getSchemaFiles() {
        return this.schemaFiles;
    }

    @Override
    public Set<OutputLanguage> getOutputLanguages() {
        return this.outputLanguages;
    }

    @Override
    public CodeGeneratorFactory getCodeGeneratorFactory() {
        return this.codeGeneratorFactory;
    }

    @Override
    public Set<FileRef> getAllowedOutputFileRefs() {
        return ImmutableSet.of();
    }

    @Override
    public FileRef getDependencyFile() {
        return null;
    }

    @Override
    public FileRef getPropertiesFile() {
        return this.propertiesFile;
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public AlertPolicy getAlertPolicy() {
        return this.alertPolicy;
    }

    @Override
    public SortedSet<Phase> getDotPhases() {
        return this.dotPhases;
    }

    @Override
    public SourceEntityResolver getEntityResolver() {
        return this.sourceEntityResolver;
    }

    private AlertPolicy computeAlertPolicy() {
        ConfigurableAlertPolicy result = new ConfigurableAlertPolicy();
        if (this.i18nwarn) {
            result.setSeverity(UnextractableContentAlert.class, Alert.Severity.WARNING);
        }
        result.setTreatWarningsAsErrors(true);
        return result;
    }

    private static ImmutableSortedSet<Phase> computeDotPhases() {
        return ImmutableSortedSet.of();
    }
}

