/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.AxiomSOAPElementSupport;
import org.apache.axiom.soap.impl.common.Checker;
import org.apache.axiom.soap.impl.common.HeaderIterator;
import org.apache.axiom.soap.impl.common.MURoleChecker;
import org.apache.axiom.soap.impl.common.RoleChecker;
import org.apache.axiom.soap.impl.common.RolePlayerChecker;
import org.apache.axiom.soap.impl.intf.AxiomSOAPHeader;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.axiom.soap.impl.llom.SOAPEnvelopeImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SOAPHeaderImpl
extends SOAPElement
implements AxiomSOAPHeader {
    private static final Log log = LogFactory.getLog(SOAPHeaderImpl.class);

    public SOAPHeaderBlock addHeaderBlock(String localName, OMNamespace ns) throws OMException {
        SOAPHeaderBlock soapHeaderBlock;
        if (ns == null || ns.getNamespaceURI().length() == 0) {
            throw new OMException("All the SOAP Header blocks should be namespace qualified");
        }
        OMNamespace namespace = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$findNamespace(this, ns.getNamespaceURI(), ns.getPrefix());
        if (namespace != null) {
            ns = namespace;
        }
        try {
            soapHeaderBlock = ((SOAPFactory)AxiomSOAPElementSupport.ajc$interMethodDispatch1$org_apache_axiom_soap_impl_common_AxiomSOAPElementSupport$org_apache_axiom_soap_impl_intf_AxiomSOAPElement$getOMFactory(this)).createSOAPHeaderBlock(localName, ns, (SOAPHeader)this);
        }
        catch (SOAPProcessingException e) {
            throw new OMException((Throwable)e);
        }
        ((OMNodeEx)soapHeaderBlock).setComplete(true);
        return soapHeaderBlock;
    }

    public SOAPHeaderBlock addHeaderBlock(QName qname) throws OMException {
        return this.addHeaderBlock(qname.getLocalPart(), AxiomSOAPElementSupport.ajc$interMethodDispatch1$org_apache_axiom_soap_impl_common_AxiomSOAPElementSupport$org_apache_axiom_soap_impl_intf_AxiomSOAPElement$getOMFactory(this).createOMNamespace(qname.getNamespaceURI(), qname.getPrefix()));
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer) {
        return new HeaderIterator(this, new RolePlayerChecker(rolePlayer));
    }

    public Iterator getHeadersToProcess(RolePlayer rolePlayer, String namespace) {
        return new HeaderIterator(this, new RolePlayerChecker(rolePlayer, namespace));
    }

    public Iterator examineHeaderBlocks(String role) {
        return new HeaderIterator(this, new RoleChecker(role));
    }

    public abstract Iterator extractHeaderBlocks(String var1);

    public Iterator examineMustUnderstandHeaderBlocks(String actor) {
        return new HeaderIterator(this, new MURoleChecker(actor));
    }

    public Iterator examineAllHeaderBlocks() {
        class DefaultChecker
        implements Checker {
            DefaultChecker() {
            }

            public boolean checkHeader(SOAPHeaderBlock header) {
                return true;
            }
        }
        return new HeaderIterator(this, new DefaultChecker());
    }

    public Iterator extractAllHeaderBlocks() {
        ArrayList<OMElement> result = new ArrayList<OMElement>();
        Iterator iter = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getChildElements(this);
        while (iter.hasNext()) {
            OMElement headerBlock = (OMElement)iter.next();
            iter.remove();
            result.add(headerBlock);
        }
        return result.iterator();
    }

    public ArrayList getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<OMElement> headers = null;
        OMElement header = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_intf_AxiomElement$getFirstElement(this);
        if (header != null) {
            headers = new ArrayList<OMElement>();
        }
        OMElement node = header;
        while (node != null) {
            if (node.getType() == 1) {
                header = node;
                OMNamespace namespace = header.getNamespace();
                if (nsURI == null) {
                    if (namespace == null) {
                        headers.add(header);
                    }
                } else if (namespace != null && nsURI.equals(namespace.getNamespaceURI())) {
                    headers.add(header);
                }
            }
            node = node.getNextOMSibling();
        }
        return headers;
    }

    public void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }

    public void addChild(OMNode child, boolean fromBuilder) {
        if (log.isDebugEnabled() && child instanceof OMElement && !(child instanceof SOAPHeaderBlock)) {
            SOAPProcessingException e = new SOAPProcessingException("An attempt was made to add a normal OMElement as a child of a SOAPHeader.  This is not supported.  The child should be a SOAPHeaderBlock.");
            log.debug((Object)SOAPHeaderImpl.exceptionToString(e));
        }
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_intf_AxiomContainer$addChild(this, child, fromBuilder);
    }

    public static String exceptionToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        return text;
    }
}

