/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import java.io.IOException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.DefaultNHttpClientConnection;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.passthru.ClientWorker;
import org.apache.synapse.transport.passthru.DeliveryAgent;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetContext;
import org.apache.synapse.transport.passthru.TargetErrorHandler;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.connections.HostConnections;
import org.apache.synapse.transport.passthru.jmx.PassThroughTransportMetricsCollector;

public class TargetHandler
implements NHttpClientEventHandler {
    private static final Log log = LogFactory.getLog(TargetHandler.class);
    private final DeliveryAgent deliveryAgent;
    private final TargetConfiguration targetConfiguration;
    private final TargetErrorHandler targetErrorHandler;
    private PassThroughTransportMetricsCollector metrics = null;

    public TargetHandler(DeliveryAgent deliveryAgent, TargetConfiguration configuration) {
        this.targetConfiguration = configuration;
        this.deliveryAgent = deliveryAgent;
        this.targetErrorHandler = new TargetErrorHandler(this.targetConfiguration);
        this.metrics = this.targetConfiguration.getMetrics();
    }

    public void connected(NHttpClientConnection conn, Object o) {
        assert (o instanceof HostConnections) : "Attachment should be a HostConnections";
        HostConnections pool = (HostConnections)o;
        conn.getContext().setAttribute("CONNECTION_POOL", (Object)pool);
        TargetContext.create((NHttpConnection)conn, ProtocolState.REQUEST_READY, this.targetConfiguration);
        this.targetConfiguration.getConnections().addConnection(conn);
        this.deliveryAgent.connected(pool.getHost(), pool.getPort(), conn);
        conn.getContext().setAttribute("REQ_DEPARTURE_TIME", (Object)System.currentTimeMillis());
        this.metrics.connected();
    }

    public void requestReady(NHttpClientConnection conn) {
        block7: {
            ProtocolState connState = null;
            try {
                connState = TargetContext.getState((NHttpConnection)conn);
                if (connState == ProtocolState.REQUEST_DONE || connState == ProtocolState.RESPONSE_BODY) {
                    return;
                }
                if (connState != ProtocolState.REQUEST_READY) {
                    this.handleInvalidState(conn, "Request not started");
                    return;
                }
                TargetRequest request = TargetContext.getRequest((NHttpConnection)conn);
                if (request != null) {
                    request.start(conn);
                    this.metrics.incrementMessagesSent();
                }
                conn.getContext().setAttribute("REQ_DEPARTURE_TIME", (Object)System.currentTimeMillis());
            }
            catch (IOException e) {
                this.logIOException(conn, e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx != null) {
                    this.targetErrorHandler.handleError(requestMsgCtx, 101500, "Error in Sender", null, connState);
                }
            }
            catch (HttpException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx == null) break block7;
                this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
            }
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        block6: {
            ProtocolState connState = null;
            try {
                connState = TargetContext.getState((NHttpConnection)conn);
                if (connState != ProtocolState.REQUEST_HEAD && connState != ProtocolState.REQUEST_DONE) {
                    this.handleInvalidState(conn, "Writing message body");
                    return;
                }
                TargetRequest request = TargetContext.getRequest((NHttpConnection)conn);
                if (request.hasEntityBody()) {
                    int bytesWritten = request.write(conn, encoder);
                    this.metrics.incrementBytesSent(bytesWritten);
                }
            }
            catch (IOException ex) {
                this.logIOException(conn, ex);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
                this.informWriterError(conn);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx != null) {
                    this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while writing data to the target", (Throwable)e);
                TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
                this.targetConfiguration.getConnections().shutdownConnection(conn);
                this.informWriterError(conn);
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                if (requestMsgCtx == null) break block6;
                this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, connState);
            }
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        try {
            conn.getContext().setAttribute("RES_HEADER_ARRIVAL_TIME", (Object)System.currentTimeMillis());
            ProtocolState connState = TargetContext.getState((NHttpConnection)conn);
            if (connState != ProtocolState.REQUEST_DONE) {
                this.handleInvalidState(conn, "Receiving response");
                return;
            }
            HttpResponse response = conn.getHttpResponse();
            TargetRequest targetRequest = TargetContext.getRequest((NHttpConnection)conn);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Received a 100 Continue response");
                }
                return;
            }
            String method = "POST";
            if (targetRequest != null) {
                method = targetRequest.getMethod();
            }
            boolean canResponseHaveBody = this.isResponseHaveBodyExpected(method, response);
            TargetResponse targetResponse = new TargetResponse(this.targetConfiguration, response, conn, canResponseHaveBody);
            TargetContext.setResponse((NHttpConnection)conn, targetResponse);
            targetResponse.start(conn);
            MessageContext requestMsgContext = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
            if (statusCode == 202 && this.handle202(requestMsgContext)) {
                return;
            }
            this.targetConfiguration.getWorkerPool().execute((Runnable)new ClientWorker(this.targetConfiguration, requestMsgContext, targetResponse));
            this.metrics.incrementMessagesReceived();
            NHttpServerConnection sourceConn = (NHttpServerConnection)requestMsgContext.getProperty("pass-through.Source-Connection");
            if (sourceConn != null) {
                sourceConn.getContext().setAttribute("RES_HEADER_ARRIVAL_TIME", conn.getContext().getAttribute("RES_HEADER_ARRIVAL_TIME"));
                sourceConn.getContext().setAttribute("REQ_DEPARTURE_TIME", conn.getContext().getAttribute("REQ_DEPARTURE_TIME"));
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn);
        }
    }

    private boolean handle202(MessageContext requestMsgContext) throws AxisFault {
        if (requestMsgContext.isPropertyTrue("IGNORE_SC_ACCEPTED")) {
            return true;
        }
        MessageReceiver mr = requestMsgContext.getAxisOperation().getMessageReceiver();
        MessageContext responseMsgCtx = requestMsgContext.getOperationContext().getMessageContext("In");
        if (responseMsgCtx == null || requestMsgContext.getOptions().isUseSeparateListener()) {
            requestMsgContext.setProperty("HTTP_202_RECEIVED", (Object)"true");
            mr.receive(requestMsgContext);
            return true;
        }
        return false;
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        try {
            ProtocolState connState = TargetContext.getState((NHttpConnection)conn);
            if (connState.compareTo(ProtocolState.RESPONSE_HEAD) < 0) {
                return;
            }
            if (connState != ProtocolState.RESPONSE_HEAD && connState != ProtocolState.RESPONSE_BODY) {
                this.handleInvalidState(conn, "Response received");
                return;
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.RESPONSE_BODY);
            TargetResponse response = TargetContext.getResponse((NHttpConnection)conn);
            if (response != null) {
                int responseRead = response.read(conn, decoder);
                this.metrics.incrementBytesReceived(responseRead);
            }
        }
        catch (IOException e) {
            this.logIOException(conn, e);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn);
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
            this.informReaderError(conn);
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn);
        }
    }

    public void closed(NHttpClientConnection conn) {
        MessageContext requestMsgCtx;
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        boolean sendFault = false;
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Keep-Alive Connection closed");
            }
        } else if (state == ProtocolState.REQUEST_HEAD || state == ProtocolState.REQUEST_BODY) {
            this.informWriterError(conn);
            log.warn((Object)"Connection closed while sending the request");
            sendFault = true;
        } else if (state == ProtocolState.RESPONSE_HEAD || state == ProtocolState.RESPONSE_BODY) {
            this.informReaderError(conn);
            log.warn((Object)"Connection closed while receiving the response");
            sendFault = false;
        } else if (state == ProtocolState.REQUEST_DONE) {
            this.informWriterError(conn);
            log.warn((Object)"Connection closed before receiving the request");
            sendFault = true;
        }
        if (sendFault && (requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()) != null) {
            this.targetErrorHandler.handleError(requestMsgCtx, 101505, "Error in Sender", null, state);
        }
        this.metrics.disconnected();
        if (state != ProtocolState.CLOSED) {
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
            this.targetConfiguration.getConnections().shutdownConnection(conn);
        }
    }

    public void exception(NHttpClientConnection conn, IOException e) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        this.logIOException(conn, e);
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        if (requestMsgCtx != null) {
            this.targetErrorHandler.handleError(requestMsgCtx, 101500, "Error in Sender", e, state);
        }
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
        this.targetConfiguration.getConnections().shutdownConnection(conn);
    }

    private void logIOException(NHttpClientConnection conn, IOException e) {
        String message = this.getErrorMessage("I/O error : " + e.getMessage(), conn);
        if (e instanceof ConnectionClosedException || e.getMessage() != null && e.getMessage().toLowerCase().contains("connection reset by peer") || e.getMessage().toLowerCase().contains("forcibly closed")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("I/O error (Probably the keep-alive connection was closed):" + e.getMessage()));
            }
        } else if (e.getMessage() != null) {
            String msg = e.getMessage().toLowerCase();
            if (msg.contains("broken")) {
                log.warn((Object)("I/O error (Probably the connection was closed by the remote party):" + e.getMessage()));
            } else {
                log.error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
            }
        } else {
            log.error((Object)message, (Throwable)e);
        }
    }

    public void exception(NHttpClientConnection conn, HttpException e) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        String message = this.getErrorMessage("HTTP protocol violation : " + e.getMessage(), conn);
        log.error((Object)message, (Throwable)e);
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        if (requestMsgCtx != null) {
            this.targetErrorHandler.handleError(requestMsgCtx, 101506, "Error in Sender", null, state);
        }
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn);
    }

    public void timeout(NHttpClientConnection conn) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        String message = this.getErrorMessage("Connection timeout", conn);
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
        if (state != null && (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.getErrorMessage("Keep-alive connection timed out", conn));
            }
        } else if (state != null) {
            if (state == ProtocolState.REQUEST_BODY) {
                this.metrics.incrementTimeoutsSending();
                this.informWriterError(conn);
            }
            if (state == ProtocolState.RESPONSE_BODY || state == ProtocolState.REQUEST_HEAD) {
                this.metrics.incrementTimeoutsReceiving();
                this.informReaderError(conn);
            }
            if (state.compareTo(ProtocolState.REQUEST_DONE) <= 0) {
                MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
                log.warn((Object)("Connection time out while in state: " + (Object)((Object)state)));
                if (requestMsgCtx != null) {
                    this.targetErrorHandler.handleError(requestMsgCtx, 101504, "Error in Sender", null, state);
                }
            }
        }
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn);
    }

    public void endOfInput(NHttpClientConnection conn) throws IOException {
        MessageContext requestMsgCtx;
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        boolean sendFault = false;
        if (state == ProtocolState.REQUEST_READY || state == ProtocolState.RESPONSE_DONE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Keep-Alive Connection closed by the target host");
            }
        } else if (state == ProtocolState.REQUEST_HEAD || state == ProtocolState.REQUEST_BODY) {
            this.informWriterError(conn);
            log.warn((Object)"Connection closed by the target host while sending the request");
            sendFault = true;
        } else if (state == ProtocolState.RESPONSE_HEAD || state == ProtocolState.RESPONSE_BODY) {
            this.informReaderError(conn);
            log.warn((Object)"Connection closed by the target host while receiving the response");
            sendFault = false;
        } else if (state == ProtocolState.REQUEST_DONE) {
            this.informWriterError(conn);
            log.warn((Object)"Connection closed by the target host before receiving the request");
            sendFault = true;
        }
        if (sendFault && (requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx()) != null) {
            this.targetErrorHandler.handleError(requestMsgCtx, 101505, "Error in Sender", null, state);
        }
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn);
    }

    public void exception(NHttpClientConnection conn, Exception e) {
        if (e instanceof HttpException) {
            this.exception(conn, (HttpException)((Object)e));
        } else if (e instanceof IOException) {
            this.exception(conn, (IOException)e);
        } else {
            log.error((Object)"Unexpected exception encountered in TargetHandler", (Throwable)e);
            ProtocolState state = TargetContext.getState((NHttpConnection)conn);
            MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
            if (requestMsgCtx != null) {
                this.targetErrorHandler.handleError(requestMsgCtx, 101500, "Error in Sender", e, state);
            }
            TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSING);
            this.targetConfiguration.getConnections().shutdownConnection(conn);
        }
    }

    public TargetConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    private boolean isResponseHaveBodyExpected(String method, HttpResponse response) {
        if ("HEAD".equalsIgnoreCase(method)) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }

    private String getErrorMessage(String message, NHttpClientConnection conn) {
        DefaultNHttpClientConnection c;
        if (conn != null && conn instanceof DefaultNHttpClientConnection && (c = (DefaultNHttpClientConnection)conn).getRemoteAddress() != null) {
            return message + " For : " + c.getRemoteAddress().getHostAddress() + ":" + c.getRemotePort();
        }
        return message;
    }

    private void handleInvalidState(NHttpClientConnection conn, String action) {
        ProtocolState state = TargetContext.getState((NHttpConnection)conn);
        log.warn((Object)(action + " while the handler is in an inconsistent state " + (Object)((Object)TargetContext.getState((NHttpConnection)conn))));
        MessageContext requestMsgCtx = TargetContext.get((NHttpConnection)conn).getRequestMsgCtx();
        TargetContext.updateState((NHttpConnection)conn, ProtocolState.CLOSED);
        this.targetConfiguration.getConnections().shutdownConnection(conn);
        if (requestMsgCtx != null) {
            this.targetErrorHandler.handleError(requestMsgCtx, 102510, "Error in Sender", null, state);
        }
    }

    private void informReaderError(NHttpClientConnection conn) {
        Pipe reader = TargetContext.get((NHttpConnection)conn).getReader();
        this.metrics.incrementFaultsReceiving();
        if (reader != null) {
            reader.producerError();
        }
    }

    private void informWriterError(NHttpClientConnection conn) {
        Pipe writer = TargetContext.get((NHttpConnection)conn).getWriter();
        this.metrics.incrementFaultsReceiving();
        if (writer != null) {
            writer.consumerError();
        }
    }
}

