/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcMessagingHandler
implements RpcCallback {
    private static Log log = LogFactory.getLog(RpcMessagingHandler.class);
    private ConfigurationContext configurationContext;

    public RpcMessagingHandler(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public Serializable replyRequest(Serializable msg, Member invoker) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RPC request received by RpcMessagingHandler");
        }
        if (msg instanceof ClusteringMessage) {
            ClusteringMessage clusteringMsg = (ClusteringMessage)msg;
            try {
                clusteringMsg.execute(this.configurationContext);
            }
            catch (ClusteringFault e) {
                String errMsg = "Cannot handle RPC message";
                log.error((Object)errMsg, (Throwable)e);
                throw new RemoteProcessException(errMsg, (Throwable)e);
            }
            return clusteringMsg.getResponse();
        }
        throw new IllegalArgumentException("Invalid RPC message of type " + msg.getClass() + " received");
    }

    public void leftOver(Serializable msg, Member member) {
    }
}

