/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.startup.quartz;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.commons.util.PropertyHelper;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.AbstractStartup;
import org.apache.synapse.startup.quartz.SimpleQuartzFactory;
import org.apache.synapse.startup.quartz.SimpleQuartzJob;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;

public class SimpleQuartz
extends AbstractStartup {
    private static final Log log = LogFactory.getLog(SimpleQuartz.class);
    private TaskDescription taskDescription;
    private SynapseTaskManager taskManager;
    private Task task = null;

    @Override
    public QName getTagQName() {
        return SimpleQuartzFactory.TASK;
    }

    @Override
    public void destroy() {
        if (this.taskDescription == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"There is no Task to be deleted");
            }
            return;
        }
        if (this.task instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.task).destroy();
        }
        if (this.taskManager.isInitialized()) {
            TaskDescriptionRepository repository;
            TaskScheduler taskScheduler = this.taskManager.getTaskScheduler();
            if (taskScheduler != null && taskScheduler.isInitialized()) {
                taskScheduler.deleteTask(this.taskDescription.getName(), this.taskDescription.getGroup());
            }
            if ((repository = this.taskManager.getTaskDescriptionRepository()) != null) {
                repository.removeTaskDescription(this.taskDescription.getName());
            }
        }
    }

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        TaskDescriptionRepository repository;
        if (this.taskDescription == null) {
            SimpleQuartz.handleException("Error while initializing the startup. TaskDescription is null.");
        }
        this.taskManager = synapseEnvironment.getTaskManager();
        if (!this.taskManager.isInitialized()) {
            log.warn((Object)"SynapseTaskManager is not properly initialized. Initializing now with default parameters.");
            this.taskManager.init(null, null);
        }
        if ((repository = this.taskManager.getTaskDescriptionRepository()) == null) {
            SimpleQuartz.handleException("Task Description Repository cannot be found");
            return;
        }
        repository.addTaskDescription(this.taskDescription);
        String thisServerName = synapseEnvironment.getServerContextInformation().getServerConfigurationInformation().getServerName();
        if (thisServerName == null || thisServerName.equals("")) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                thisServerName = address.getHostName();
            }
            catch (UnknownHostException e) {
                log.warn((Object)"Could not get the host name", (Throwable)e);
            }
            if (thisServerName == null || thisServerName.equals("")) {
                thisServerName = "localhost";
            }
        }
        log.debug((Object)("Synapse server name : " + thisServerName));
        List pinnedServers = this.taskDescription.getPinnedServers();
        if (pinnedServers != null && !pinnedServers.isEmpty() && !pinnedServers.contains(thisServerName)) {
            log.info((Object)("Server name not in pinned servers list. Not starting Task : " + this.getName()));
            return;
        }
        try {
            this.task = (Task)this.getClass().getClassLoader().loadClass(this.taskDescription.getTaskClass()).newInstance();
        }
        catch (Exception e) {
            SimpleQuartz.handleException("Cannot instantiate task : " + this.taskDescription.getTaskClass(), e);
        }
        Set properties = this.taskDescription.getProperties();
        for (Object property : properties) {
            OMElement prop = (OMElement)property;
            log.debug((Object)("Found Property : " + prop.toString()));
            PropertyHelper.setStaticProperty((OMElement)prop, (Object)this.task);
        }
        if (this.task instanceof ManagedLifecycle) {
            ((ManagedLifecycle)this.task).init(synapseEnvironment);
        }
        HashMap<String, SynapseEnvironment> map = new HashMap<String, SynapseEnvironment>();
        map.put("SynapseEnvironment", synapseEnvironment);
        try {
            TaskScheduler taskScheduler = this.taskManager.getTaskScheduler();
            if (taskScheduler != null) {
                if (!taskScheduler.isInitialized()) {
                    taskScheduler.init(synapseEnvironment.getSynapseConfiguration().getProperties());
                }
                taskScheduler.scheduleTask(this.taskDescription, map, SimpleQuartzJob.class, this.task);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("TaskScheduler cannot be found for :task_scheduler , therefore ignore scheduling of Task  " + this.taskDescription));
            }
        }
        catch (Exception e) {
            String msg = "Error starting up Scheduler : " + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new SynapseException(msg, e);
        }
    }

    public TaskDescription getTaskDescription() {
        return this.taskDescription;
    }

    public void setTaskDescription(TaskDescription taskDescription) {
        this.taskDescription = taskDescription;
    }

    private static void handleException(String message) {
        log.error((Object)message);
        throw new SynapseException(message);
    }

    private static void handleException(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        throw new SynapseException(message, e);
    }
}

