/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.mail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.util.CommonUtils;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.format.MessageFormatterEx;
import org.apache.axis2.format.MessageFormatterExAdapter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.SynchronousCallback;
import org.apache.axis2.transport.mail.MailOutTransportInfo;
import org.apache.axis2.transport.mail.MailUtils;
import org.apache.axis2.transport.mail.WSMimeMessage;
import org.apache.commons.logging.LogFactory;

public class MailTransportSender
extends AbstractTransportSender
implements ManagementSupport {
    private String smtpUsername = null;
    private String smtpPassword = null;
    private InternetAddress smtpFromAddress = null;
    private InternetAddress[] smtpBccAddresses = null;
    private String defaultMailFormat = "Text";
    private Session session = null;

    public MailTransportSender() {
        this.log = LogFactory.getLog(MailTransportSender.class);
    }

    public void init(ConfigurationContext cfgCtx, TransportOutDescription transportOut) throws AxisFault {
        super.init(cfgCtx, transportOut);
        Properties props = new Properties();
        ArrayList params = transportOut.getParameters();
        for (Parameter p : params) {
            props.put(p.getName(), p.getValue());
        }
        if (props.containsKey("mail.smtp.from")) {
            try {
                this.smtpFromAddress = new InternetAddress((String)props.get("mail.smtp.from"));
            }
            catch (AddressException e) {
                this.handleException("Invalid default 'From' address : " + props.get("mail.smtp.from"), (Exception)((Object)e));
            }
        }
        if (props.containsKey("transport.mail.SMTPBccAddresses")) {
            try {
                this.smtpBccAddresses = InternetAddress.parse((String)((String)props.get("transport.mail.SMTPBccAddresses")));
            }
            catch (AddressException e) {
                this.handleException("Invalid default 'Bcc' address : " + props.get("transport.mail.SMTPBccAddresses"), (Exception)((Object)e));
            }
        }
        if (props.containsKey("transport.mail.Format")) {
            this.defaultMailFormat = (String)props.get("transport.mail.Format");
        }
        this.smtpUsername = (String)props.get("mail.smtp.user");
        this.smtpPassword = (String)props.get("mail.smtp.password");
        this.session = this.smtpUsername != null && this.smtpPassword != null ? Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailTransportSender.this.smtpUsername, MailTransportSender.this.smtpPassword);
            }
        }) : Session.getInstance((Properties)props, null);
        MailUtils.setupLogging(this.session, this.log, (ParameterInclude)transportOut);
        if (cfgCtx.getProperty("callbackTable") == null) {
            cfgCtx.setProperty("callbackTable", new ConcurrentHashMap());
        }
    }

    public void sendMessage(MessageContext msgCtx, String targetAddress, OutTransportInfo outTransportInfo) throws AxisFault {
        MailOutTransportInfo mailOutInfo = null;
        if (targetAddress != null) {
            if (targetAddress.startsWith("mailto")) {
                targetAddress = targetAddress.substring("mailto".length() + 1);
            }
            if (msgCtx.getReplyTo() != null && !"http://www.w3.org/2005/08/addressing/none".equals(msgCtx.getReplyTo().getAddress()) && !"http://www.w3.org/2005/08/addressing/anonymous".equals(msgCtx.getReplyTo().getAddress())) {
                String replyTo = msgCtx.getReplyTo().getAddress();
                if (replyTo.startsWith("mailto")) {
                    replyTo = replyTo.substring("mailto".length() + 1);
                }
                try {
                    mailOutInfo = new MailOutTransportInfo(new InternetAddress(replyTo));
                }
                catch (AddressException e) {
                    this.handleException("Invalid reply address/es : " + replyTo, (Exception)((Object)e));
                }
            } else {
                mailOutInfo = new MailOutTransportInfo(this.smtpFromAddress);
            }
            try {
                mailOutInfo.setTargetAddresses(InternetAddress.parse((String)targetAddress));
            }
            catch (AddressException e) {
                this.handleException("Invalid target address/es : " + targetAddress, (Exception)((Object)e));
            }
        } else if (outTransportInfo != null && outTransportInfo instanceof MailOutTransportInfo) {
            mailOutInfo = (MailOutTransportInfo)outTransportInfo;
        }
        if (mailOutInfo != null) {
            try {
                String messageID = this.sendMail(mailOutInfo, msgCtx);
                if (!msgCtx.getOptions().isUseSeparateListener() && !msgCtx.isServerSide()) {
                    this.waitForReply(msgCtx, messageID);
                }
            }
            catch (MessagingException e) {
                this.handleException("Error generating mail message", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.handleException("Error generating mail message", e);
            }
        } else {
            this.handleException("Unable to determine out transport information to send message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForReply(MessageContext msgContext, String mailMessageID) throws AxisFault {
        if (!(msgContext.getAxisOperation() instanceof OutInAxisOperation) && msgContext.getProperty("piggybackMessage") == null) {
            return;
        }
        ConfigurationContext configContext = msgContext.getConfigurationContext();
        if (!configContext.getListenerManager().isListenerRunning("mailto")) {
            TransportInDescription mailTo = configContext.getAxisConfiguration().getTransportIn("mailto");
            if (mailTo == null) {
                this.handleException("Could not find the transport receiver for mailto");
            }
            configContext.getListenerManager().addListener(mailTo, false);
        }
        SynchronousCallback synchronousCallback = new SynchronousCallback(msgContext);
        Map callBackMap = (Map)msgContext.getConfigurationContext().getProperty("callbackTable");
        callBackMap.put(mailMessageID, synchronousCallback);
        SynchronousCallback synchronousCallback2 = synchronousCallback;
        synchronized (synchronousCallback2) {
            try {
                synchronousCallback.wait(msgContext.getOptions().getTimeOutInMilliSeconds());
            }
            catch (InterruptedException e) {
                this.handleException("Error occured while waiting ..", e);
            }
        }
        if (!synchronousCallback.isComplete()) {
            callBackMap.remove(mailMessageID);
            this.handleException("Timeout while waiting for a response");
        }
    }

    private String sendMail(MailOutTransportInfo outInfo, MessageContext msgContext) throws AxisFault, MessagingException, IOException {
        WSMimeMessage mainPart;
        MimeBodyPart mimeBodyPart2;
        MimeBodyPart mimeBodyPart1;
        OMOutputFormat format = BaseUtils.getOMOutputFormat((MessageContext)msgContext);
        format.setProperty("org.apache.axiom.om.OMFormat.use.cteBase64.forNonTextualAttachments", (Object)true);
        MessageFormatter messageFormatter = BaseUtils.getMessageFormatter((MessageContext)msgContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating MIME message using message formatter " + messageFormatter.getClass().getSimpleName()));
        }
        WSMimeMessage message = null;
        message = outInfo.getFromAddress() != null ? new WSMimeMessage(this.session, outInfo.getFromAddress().getAddress()) : new WSMimeMessage(this.session, "");
        Map trpHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (this.log.isDebugEnabled() && trpHeaders != null) {
            this.log.debug((Object)("Using transport headers: " + trpHeaders));
        }
        if (outInfo.getTargetAddresses() != null && outInfo.getFromAddress() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting From header to " + outInfo.getFromAddress().getAddress() + " from OutTransportInfo"));
            }
            message.setFrom((Address)outInfo.getFromAddress());
            message.setReplyTo(new Address[]{outInfo.getFromAddress()});
        } else if (trpHeaders != null && trpHeaders.containsKey("From")) {
            InternetAddress from = new InternetAddress((String)trpHeaders.get("From"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting From header to " + from.getAddress() + " from transport headers"));
            }
            message.setFrom((Address)from);
            message.setReplyTo(new Address[]{from});
        } else if (this.smtpFromAddress != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting From header to " + this.smtpFromAddress.getAddress() + " from transport configuration"));
            }
            message.setFrom((Address)this.smtpFromAddress);
            message.setReplyTo(new Address[]{this.smtpFromAddress});
        } else {
            this.handleException("From address for outgoing message cannot be determined");
        }
        if (trpHeaders != null && trpHeaders.containsKey("To")) {
            InternetAddress[] to = InternetAddress.parse((String)((String)trpHeaders.get("To")));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting To header to " + InternetAddress.toString((Address[])to) + " from transport headers"));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
        } else if (outInfo.getTargetAddresses() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting To header to " + InternetAddress.toString((Address[])outInfo.getTargetAddresses()) + " from OutTransportInfo"));
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])outInfo.getTargetAddresses());
        } else {
            this.handleException("To address for outgoing message cannot be determined");
        }
        if (trpHeaders != null && trpHeaders.containsKey("Cc")) {
            InternetAddress[] cc = InternetAddress.parse((String)((String)trpHeaders.get("Cc")));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting Cc header to " + InternetAddress.toString((Address[])cc) + " from transport headers"));
            }
            message.setRecipients(Message.RecipientType.CC, (Address[])cc);
        } else if (outInfo.getCcAddresses() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting Cc header to " + InternetAddress.toString((Address[])outInfo.getCcAddresses()) + " from OutTransportInfo"));
            }
            message.setRecipients(Message.RecipientType.CC, (Address[])outInfo.getCcAddresses());
        }
        if (trpHeaders != null && trpHeaders.containsKey("Bcc")) {
            InternetAddress[] bcc = InternetAddress.parse((String)((String)trpHeaders.get("Bcc")));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Bcc header values " + InternetAddress.toString((Address[])bcc) + " from transport headers"));
            }
            message.addRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        if (this.smtpBccAddresses != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Bcc header values " + InternetAddress.toString((Address[])this.smtpBccAddresses) + " from transport configuration"));
            }
            message.addRecipients(Message.RecipientType.BCC, (Address[])this.smtpBccAddresses);
        }
        if (trpHeaders != null && trpHeaders.containsKey("Subject")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting Subject header to '" + trpHeaders.get("Subject") + "' from transport headers"));
            }
            message.setSubject((String)trpHeaders.get("Subject"));
        } else if (outInfo.getSubject() != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Setting Subject header to '" + outInfo.getSubject() + "' from transport headers"));
            }
            message.setSubject(outInfo.getSubject());
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Generating default Subject header from SOAP action");
            }
            message.setSubject("SOAPAction: " + msgContext.getSoapAction());
        }
        if (outInfo.getRequestMessageID() != null) {
            message.setHeader("In-Reply-To", outInfo.getRequestMessageID());
            message.setHeader("References", outInfo.getRequestMessageID());
        } else {
            if (trpHeaders != null && trpHeaders.containsKey("In-Reply-To")) {
                message.setHeader("In-Reply-To", (String)trpHeaders.get("In-Reply-To"));
            }
            if (trpHeaders != null && trpHeaders.containsKey("References")) {
                message.setHeader("References", (String)trpHeaders.get("References"));
            }
        }
        message.setSentDate(new Date());
        message.setHeader("SOAPAction", msgContext.getSoapAction());
        Object messageFormatterEx = messageFormatter instanceof MessageFormatterEx ? (MessageFormatterEx)messageFormatter : new MessageFormatterExAdapter(messageFormatter);
        DataHandler dataHandler = new DataHandler(messageFormatterEx.getDataSource(msgContext, format, msgContext.getSoapAction()));
        MimeMultipart mimeMultiPart = null;
        String mFormat = (String)msgContext.getProperty("transport.mail.Format");
        if (mFormat == null) {
            mFormat = this.defaultMailFormat;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using mail format '" + mFormat + "'"));
        }
        if ("Multipart".equals(mFormat)) {
            mimeMultiPart = new MimeMultipart();
            mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)"Web Service Message Attached", "text/plain");
            mimeBodyPart2 = new MimeBodyPart();
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart1);
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart2);
            message.setContent((Multipart)mimeMultiPart);
            mainPart = mimeBodyPart2;
        } else if ("Attachment".equals(mFormat)) {
            mimeMultiPart = new MimeMultipart();
            mimeBodyPart1 = new MimeBodyPart();
            mimeBodyPart1.setContent((Object)"Web Service Message Attached", "text/plain");
            mimeBodyPart2 = new MimeBodyPart();
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart1);
            mimeMultiPart.addBodyPart((BodyPart)mimeBodyPart2);
            message.setContent((Multipart)mimeMultiPart);
            String fileName = (String)msgContext.getProperty("AttachmentFile");
            if (fileName != null) {
                mimeBodyPart2.setFileName(fileName);
            } else {
                mimeBodyPart2.setFileName("attachment");
            }
            mainPart = mimeBodyPart2;
        } else {
            mainPart = message;
        }
        try {
            mainPart.setHeader("SOAPAction", msgContext.getSoapAction());
            mainPart.setDataHandler(dataHandler);
            if (msgContext.getOptions().getProperty("Content-Transfer-Encoding") != null) {
                mainPart.setHeader("Content-Transfer-Encoding", (String)msgContext.getOptions().getProperty("Content-Transfer-Encoding"));
            } else {
                String contentType = dataHandler.getContentType().toLowerCase();
                if (!contentType.startsWith("multipart/") && CommonUtils.isTextualPart((String)contentType)) {
                    mainPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
                }
            }
            if (msgContext.getOptions().getProperty("transport.mail.custom.headers") != null) {
                Map customTransportHeaders = (Map)msgContext.getOptions().getProperty("transport.mail.custom.headers");
                for (Object header : customTransportHeaders.keySet()) {
                    mainPart.setHeader((String)header, (String)customTransportHeaders.get(header));
                }
            }
            this.log.debug((Object)"Sending message");
            Transport.send((Message)message);
            this.metrics.incrementMessagesSent(msgContext);
            long bytesSent = message.getBytesSent();
            if (bytesSent != -1L) {
                this.metrics.incrementBytesSent(msgContext, bytesSent);
            }
        }
        catch (MessagingException e) {
            this.metrics.incrementFaultsSending();
            this.handleException("Error creating mail message or sending it to the configured server", (Exception)((Object)e));
        }
        return message.getMessageID();
    }

    public void stop() {
        super.stop();
        this.metrics.reset();
        this.smtpUsername = null;
        this.smtpPassword = null;
        this.smtpBccAddresses = null;
        this.smtpFromAddress = null;
        this.session = null;
    }
}

