/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.CSVReblockInstruction;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.CSVReblockMR;
import org.apache.sysml.runtime.matrix.mapred.MRConfigurationNames;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class CSVAssignRowIDMapper
extends MapReduceBase
implements Mapper<LongWritable, Text, ByteWritable, CSVReblockMR.OffsetCount> {
    private ByteWritable outKey = new ByteWritable();
    private long fileOffset = 0L;
    private long num = 0L;
    private boolean first = true;
    private OutputCollector<ByteWritable, CSVReblockMR.OffsetCount> outCache = null;
    private String delim = " ";
    private boolean ignoreFirstLine = false;
    private boolean realFirstLine = false;
    private String filename = "";
    private boolean headerFile = false;

    public void map(LongWritable key, Text value, OutputCollector<ByteWritable, CSVReblockMR.OffsetCount> out, Reporter report) throws IOException {
        if (this.first) {
            this.first = false;
            this.fileOffset = key.get();
            this.outCache = out;
        }
        if (key.get() == 0L && this.headerFile) {
            if (!this.ignoreFirstLine) {
                report.incrCounter("num.cols.in.matrix.", this.outKey.toString(), (long)value.toString().split(this.delim, -1).length);
                ++this.num;
            } else {
                this.realFirstLine = true;
            }
        } else {
            if (this.realFirstLine) {
                report.incrCounter("num.cols.in.matrix.", this.outKey.toString(), (long)value.toString().split(this.delim, -1).length);
                this.realFirstLine = false;
            }
            ++this.num;
        }
    }

    public void configure(JobConf job) {
        try {
            CSVReblockInstruction[] reblockInstructions;
            byte thisIndex = MRJobConfiguration.getInputMatrixIndexesInMapper(job).get(0);
            this.outKey.set(thisIndex);
            Path thisPath = new Path(job.get(MRConfigurationNames.MR_MAP_INPUT_FILE));
            FileSystem fs = IOUtilFunctions.getFileSystem(thisPath, (Configuration)job);
            thisPath = thisPath.makeQualified(fs);
            this.filename = thisPath.toString();
            String[] strs = job.getStrings("smallest.file.name.per.input");
            Path headerPath = new Path(strs[thisIndex]).makeQualified(fs);
            this.headerFile = headerPath.toString().equals(this.filename);
            for (CSVReblockInstruction ins : reblockInstructions = MRJobConfiguration.getCSVReblockInstructions(job)) {
                if (ins.input != thisIndex) continue;
                this.delim = Pattern.quote(ins.delim);
                this.ignoreFirstLine = ins.hasHeader;
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        if (this.outCache != null) {
            this.outCache.collect((Object)this.outKey, (Object)new CSVReblockMR.OffsetCount(this.filename, this.fileOffset, this.num));
        }
    }
}

