/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.MultipleOutputs;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.Pair;

public class CollectMultipleConvertedOutputs {
    protected Converter[] outputConverters;
    protected MultipleOutputs multipleOutputs;
    protected MatrixCharacteristics[] matrixStats;

    public CollectMultipleConvertedOutputs(Converter[] convts, MatrixCharacteristics[] stats, MultipleOutputs outputs) {
        this.outputConverters = convts;
        this.multipleOutputs = outputs;
        this.matrixStats = stats;
    }

    public void collectOutput(Writable key, Writable value, int output, Reporter reporter) throws IOException {
        Converter conv = this.outputConverters[output];
        conv.setBlockSize(this.matrixStats[output].getRowsPerBlock(), this.matrixStats[output].getColsPerBlock());
        conv.convert(key, value);
        while (conv.hasNext()) {
            Pair outpair = conv.next();
            this.multipleOutputs.getCollector(Integer.toString(output), reporter).collect(outpair.getKey(), outpair.getValue());
        }
    }

    public void directOutput(Writable key, Writable value, int output, Reporter reporter) throws IOException {
        this.multipleOutputs.getCollector(Integer.toString(output), reporter).collect((Object)key, (Object)value);
    }

    public void close() throws IOException {
        this.multipleOutputs.close();
    }
}

