/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;
import org.apache.sysml.scripts.nn.layers.lstm_staging.Backward_output;
import org.apache.sysml.scripts.nn.layers.lstm_staging.Forward_output;
import org.apache.sysml.scripts.nn.layers.lstm_staging.Init_output;

public class Lstm_staging
extends Script {
    public Lstm_staging() {
        String string = "scripts/nn/layers/lstm_staging.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Init_output init(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/lstm_staging.dml') as mlcontextns;[W, b, out0, c0] = mlcontextns::init(N, D, M);";
        Script script = new Script(string);
        script.in("N", object).in("D", object2).in("M", object3).out("W").out("b").out("out0").out("c0");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("W");
        Matrix matrix2 = mLResults.getMatrix("b");
        Matrix matrix3 = mLResults.getMatrix("out0");
        Matrix matrix4 = mLResults.getMatrix("c0");
        Init_output init_output = new Init_output(matrix, matrix2, matrix3, matrix4);
        return init_output;
    }

    public String init__docs() {
        String string = "init = function(int N, int D, int M)\n    return (matrix[double] W, matrix[double] b, matrix[double] out0, matrix[double] c0) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the Glorot uniform heuristic which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * uniform weights by a factor of sqrt(6/(fan_in + fan_out)).\n   *  - http://jmlr.org/proceedings/papers/v9/glorot10a/glorot10a.pdf\n   *\n   * Inputs:\n   *  - N: Number of examples in batch.\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - out0: Empty previous timestep output matrix, of shape (N, M).\n   *  - c0: Empty initial cell state matrix, of shape (N, M).\n   */\n";
        return string;
    }

    public String init__source() {
        String string = "init = function(int N, int D, int M)\n    return (matrix[double] W, matrix[double] b, matrix[double] out0, matrix[double] c0) {\n  /*\n   * Initialize the parameters of this layer.\n   *\n   * Note: This is just a convenience function, and parameters\n   * may be initialized manually if needed.\n   *\n   * We use the Glorot uniform heuristic which limits the magnification\n   * of inputs/gradients during forward/backward passes by scaling\n   * uniform weights by a factor of sqrt(6/(fan_in + fan_out)).\n   *  - http://jmlr.org/proceedings/papers/v9/glorot10a/glorot10a.pdf\n   *\n   * Inputs:\n   *  - N: Number of examples in batch.\n   *  - D: Dimensionality of the input features (number of features).\n   *  - M: Number of neurons in this layer.\n   *\n   * Outputs:\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - out0: Empty previous timestep output matrix, of shape (N, M).\n   *  - c0: Empty initial cell state matrix, of shape (N, M).\n   */\n  fan_in = D+M\n  fan_out = 4*M\n  scale = sqrt(6/(fan_in+fan_out))\n  W = rand(rows=D+M, cols=4*M, min=-scale, max=scale, pdf=\"uniform\")\n  b = matrix(0, rows=1, cols=4*M)\n  out0 = matrix(0, rows=N, cols=M)\n  c0 = matrix(0, rows=N, cols=M)\n}\n";
        return string;
    }

    public Forward_output forward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        String string = "source('scripts/nn/layers/lstm_staging.dml') as mlcontextns;[out, c] = mlcontextns::forward(X, W, b, return_sequences, out0, c0);";
        Script script = new Script(string);
        script.in("X", object).in("W", object2).in("b", object3).in("return_sequences", object4).in("out0", object5).in("c0", object6).out("out").out("c");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("out");
        Matrix matrix2 = mLResults.getMatrix("c");
        Forward_output forward_output = new Forward_output(matrix, matrix2);
        return forward_output;
    }

    public String forward__docs() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b, \n                   boolean return_sequences, matrix[double] out0, matrix[double] c0)\n    return (matrix[double] out, matrix[double] c) {\n  /*\n   * Computes the forward pass for an LSTM layer with M neurons.\n   * The input data has N sequences of T examples, each with D features.\n   *\n   * In an LSTM, an internal cell state is maintained, additive\n   * interactions operate over the cell state at each timestep, and\n   * some amount of this cell state is exposed as output at each\n   * timestep.  Additionally, the output of the previous timestep is fed\n   * back in as an additional input at the current timestep.\n   *\n   * Reference:\n   *  - Long Short-Term Memory, Hochreiter, 1997\n   *    - http://deeplearning.cs.cmu.edu/pdfs/Hochreiter97_lstm.pdf\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - return_sequences: Whether to return `out` at all timesteps,\n   *      or just for the final timestep.\n   *  - out0: Outputs from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - c0: Initial cell state, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *\n   * Outputs:\n   *  - out: If `return_sequences` is True, outputs for all timesteps,\n   *      of shape (N, T*M).  Else, outputs for the final timestep, of\n   *      shape (N, M).\n   *  - c: Cell state for final timestep, of shape (N, M). \n   */\n";
        return string;
    }

    public String forward__source() {
        String string = "forward = function(matrix[double] X, matrix[double] W, matrix[double] b, \n                   boolean return_sequences, matrix[double] out0, matrix[double] c0)\n    return (matrix[double] out, matrix[double] c) {\n  /*\n   * Computes the forward pass for an LSTM layer with M neurons.\n   * The input data has N sequences of T examples, each with D features.\n   *\n   * In an LSTM, an internal cell state is maintained, additive\n   * interactions operate over the cell state at each timestep, and\n   * some amount of this cell state is exposed as output at each\n   * timestep.  Additionally, the output of the previous timestep is fed\n   * back in as an additional input at the current timestep.\n   *\n   * Reference:\n   *  - Long Short-Term Memory, Hochreiter, 1997\n   *    - http://deeplearning.cs.cmu.edu/pdfs/Hochreiter97_lstm.pdf\n   *\n   * Inputs:\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - return_sequences: Whether to return `out` at all timesteps,\n   *      or just for the final timestep.\n   *  - out0: Outputs from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - c0: Initial cell state, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *\n   * Outputs:\n   *  - out: If `return_sequences` is True, outputs for all timesteps,\n   *      of shape (N, T*M).  Else, outputs for the final timestep, of\n   *      shape (N, M).\n   *  - c: Cell state for final timestep, of shape (N, M). \n   */\n  out = 0; c = c0;\n  [out, c] = lstm(X, W, b, out0, c0, return_sequences)\n}\n";
        return string;
    }

    public Backward_output backward(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        String string = "source('scripts/nn/layers/lstm_staging.dml') as mlcontextns;[dX, dW, db, dout0, dc0] = mlcontextns::backward(dout, dc, X, W, b, given_sequences, out0, c0);";
        Script script = new Script(string);
        script.in("dout", object).in("dc", object2).in("X", object3).in("W", object4).in("b", object5).in("given_sequences", object6).in("out0", object7).in("c0", object8).out("dX").out("dW").out("db").out("dout0").out("dc0");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dX");
        Matrix matrix2 = mLResults.getMatrix("dW");
        Matrix matrix3 = mLResults.getMatrix("db");
        Matrix matrix4 = mLResults.getMatrix("dout0");
        Matrix matrix5 = mLResults.getMatrix("dc0");
        Backward_output backward_output = new Backward_output(matrix, matrix2, matrix3, matrix4, matrix5);
        return backward_output;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dout, matrix[double] dc,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    boolean given_sequences, matrix[double] out0, matrix[double] c0)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db,\n            matrix[double] dout0, matrix[double] dc0) {\n  /*\n   * Computes the backward pass for an LSTM layer with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out`.  If `given_sequences` is `True`,\n   *      contains gradients on outputs for all timesteps, of\n   *      shape (N, T*M). Else, contains the gradient on the output\n   *      for the final timestep, of shape (N, M).\n   *  - dc: Gradient wrt `c` (from later in time), of shape (N, M).\n   *      This would come from later in time if the cell state was used\n   *      downstream as the initial cell state for another LSTM layer.\n   *      Typically, this would be used when a sequence was cut at\n   *      timestep `T` and then continued in the next batch.  If `c`\n   *      was not used downstream, then `dc` would be an empty matrix.\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - given_sequences: Whether `dout` is for all timesteps,\n   *      or just for the final timestep.  This is based on whether\n   *      `return_sequences` was true in the forward pass.\n   *  - out0: Outputs from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - c0: Initial cell state, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *  - cache_c: Cache of cell state, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *  - cache_ifog: Cache of intermediate values, of shape (T, N*4*M).\n   *      Note: This is used for performance during training.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, T*D).\n   *  - dW: Gradient wrt `W`, of shape (D+M, 4M).\n   *  - db: Gradient wrt `b`, of shape (1, 4M).\n   *  - dout0: Gradient wrt `out0`, of shape (N, M).\n   *  - dc0: Gradient wrt `c0`, of shape (N, M).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dout, matrix[double] dc,\n                    matrix[double] X, matrix[double] W, matrix[double] b,\n                    boolean given_sequences, matrix[double] out0, matrix[double] c0)\n    return (matrix[double] dX, matrix[double] dW, matrix[double] db,\n            matrix[double] dout0, matrix[double] dc0) {\n  /*\n   * Computes the backward pass for an LSTM layer with M neurons.\n   *\n   * Inputs:\n   *  - dout: Gradient wrt `out`.  If `given_sequences` is `True`,\n   *      contains gradients on outputs for all timesteps, of\n   *      shape (N, T*M). Else, contains the gradient on the output\n   *      for the final timestep, of shape (N, M).\n   *  - dc: Gradient wrt `c` (from later in time), of shape (N, M).\n   *      This would come from later in time if the cell state was used\n   *      downstream as the initial cell state for another LSTM layer.\n   *      Typically, this would be used when a sequence was cut at\n   *      timestep `T` and then continued in the next batch.  If `c`\n   *      was not used downstream, then `dc` would be an empty matrix.\n   *  - X: Inputs, of shape (N, T*D).\n   *  - W: Weights, of shape (D+M, 4M).\n   *  - b: Biases, of shape (1, 4M).\n   *  - given_sequences: Whether `dout` is for all timesteps,\n   *      or just for the final timestep.  This is based on whether\n   *      `return_sequences` was true in the forward pass.\n   *  - out0: Outputs from previous timestep, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - c0: Initial cell state, of shape (N, M).\n   *      Note: This is *optional* and could just be an empty matrix.\n   *  - cache_out: Cache of outputs, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *  - cache_c: Cache of cell state, of shape (T, N*M).\n   *      Note: This is used for performance during training.\n   *  - cache_ifog: Cache of intermediate values, of shape (T, N*4*M).\n   *      Note: This is used for performance during training.\n   *\n   * Outputs:\n   *  - dX: Gradient wrt `X`, of shape (N, T*D).\n   *  - dW: Gradient wrt `W`, of shape (D+M, 4M).\n   *  - db: Gradient wrt `b`, of shape (1, 4M).\n   *  - dout0: Gradient wrt `out0`, of shape (N, M).\n   *  - dc0: Gradient wrt `c0`, of shape (N, M).\n   */\n  dX = X; dW = W; db = b; dout0 = out0; dc0 = c0\n  [dX, dW, db, dout0, dc0] = lstm_backward(X, W, b, out0, c0, given_sequences, dout, dc)\n}\n";
        return string;
    }
}

