/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.DataGenOp;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.IntObject;
import org.apache.sysds.runtime.instructions.cp.UnaryCPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.LibMatrixDatagen;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.util.DataConverter;
import org.apache.sysds.runtime.util.UtilFunctions;

public class DataGenCPInstruction
extends UnaryCPInstruction {
    private static final Log LOG = LogFactory.getLog((String)DataGenCPInstruction.class.getName());
    private Types.OpOpDG method;
    private final CPOperand rows;
    private final CPOperand cols;
    private final CPOperand dims;
    private final int blocksize;
    private boolean minMaxAreDoubles;
    private final String minValueStr;
    private final String maxValueStr;
    private final double minValue;
    private final double maxValue;
    private final double sparsity;
    private final String pdf;
    private final String pdfParams;
    private final long seed;
    private Long runtimeSeed;
    private final CPOperand seq_from;
    private final CPOperand seq_to;
    private final CPOperand seq_incr;
    private final boolean replace;
    private final int numThreads;
    private static final int SEED_POSITION_RAND = 8;
    private static final int SEED_POSITION_SAMPLE = 4;

    private DataGenCPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String minValue, String maxValue, double sparsity, long seed, String probabilityDensityFunction, String pdfParams, int k, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, boolean replace, String opcode, String istr) {
        super(CPInstruction.CPType.Rand, op, in, out, opcode, istr);
        double maxDouble;
        double minDouble;
        this.method = mthd;
        this.rows = rows;
        this.cols = cols;
        this.dims = dims;
        this.blocksize = blen;
        this.minValueStr = minValue;
        this.maxValueStr = maxValue;
        try {
            minDouble = !minValue.contains("\u00b6") ? Double.valueOf(minValue) : -1.0;
            maxDouble = !maxValue.contains("\u00b6") ? Double.valueOf(maxValue) : -1.0;
            this.minMaxAreDoubles = true;
        }
        catch (NumberFormatException e) {
            if (!this.minValueStr.equals(this.maxValueStr)) {
                throw new DMLRuntimeException("Rand instruction does not support non numeric Datatypes for range initializations.");
            }
            minDouble = -1.0;
            maxDouble = -1.0;
            this.minMaxAreDoubles = false;
        }
        this.minValue = minDouble;
        this.maxValue = maxDouble;
        this.sparsity = sparsity;
        this.seed = seed;
        this.pdf = probabilityDensityFunction;
        this.pdfParams = pdfParams;
        this.numThreads = k;
        this.seq_from = seqFrom;
        this.seq_to = seqTo;
        this.seq_incr = seqIncr;
        this.replace = replace;
    }

    private DataGenCPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String minValue, String maxValue, double sparsity, long seed, String probabilityDensityFunction, String pdfParams, int k, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, minValue, maxValue, sparsity, seed, probabilityDensityFunction, pdfParams, k, null, null, null, false, opcode, istr);
    }

    private DataGenCPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, String maxValue, boolean replace, long seed, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, "0", maxValue, 1.0, seed, null, null, 1, null, null, null, replace, opcode, istr);
    }

    private DataGenCPInstruction(Operator op, Types.OpOpDG mthd, CPOperand in, CPOperand out, CPOperand rows, CPOperand cols, CPOperand dims, int blen, CPOperand seqFrom, CPOperand seqTo, CPOperand seqIncr, String opcode, String istr) {
        this(op, mthd, in, out, rows, cols, dims, blen, "0", "1", 1.0, -1L, null, null, 1, seqFrom, seqTo, seqIncr, false, opcode, istr);
    }

    private DataGenCPInstruction(Operator op, Types.OpOpDG mthd, CPOperand out, String opcode, String istr) {
        this(op, mthd, null, out, null, null, null, 0, "0", "0", 0.0, 0L, null, null, 1, null, null, null, false, opcode, istr);
    }

    public long getRows() {
        return this.rows.isLiteral() ? UtilFunctions.parseToLong(this.rows.getName()) : -1L;
    }

    public long getCols() {
        return this.cols.isLiteral() ? UtilFunctions.parseToLong(this.cols.getName()) : -1L;
    }

    public String getDims() {
        return this.dims.getName();
    }

    public int getBlocksize() {
        return this.blocksize;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getSparsity() {
        return this.sparsity;
    }

    public String getPdf() {
        return this.pdf;
    }

    public String getPdfParams() {
        return this.pdfParams;
    }

    public long getSeed() {
        return this.seed;
    }

    public boolean isOnesCol() {
        return this.minValue == this.maxValue && this.minValue == 1.0 && this.sparsity == 1.0 && this.getCols() == 1L;
    }

    public boolean isMatrixCall() {
        return this.minValue == this.maxValue && this.sparsity == 1.0;
    }

    public long getFrom() {
        return this.seq_from.isLiteral() ? UtilFunctions.parseToLong(this.seq_from.getName()) : -1L;
    }

    public long getTo() {
        return this.seq_to.isLiteral() ? UtilFunctions.parseToLong(this.seq_to.getName()) : -1L;
    }

    public long getIncr() {
        return this.seq_incr.isLiteral() ? UtilFunctions.parseToLong(this.seq_incr.getName()) : -1L;
    }

    public static DataGenCPInstruction parseInstruction(String str) {
        Types.OpOpDG method = null;
        String[] s = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = s[0];
        if (opcode.equalsIgnoreCase("rand")) {
            method = Types.OpOpDG.RAND;
            InstructionUtils.checkNumFields(s, 10, 11);
        } else if (opcode.equalsIgnoreCase("seq")) {
            method = Types.OpOpDG.SEQ;
            InstructionUtils.checkNumFields(s, 7);
        } else if (opcode.equalsIgnoreCase("sample")) {
            method = Types.OpOpDG.SAMPLE;
            InstructionUtils.checkNumFields(s, 6);
        } else if (opcode.equalsIgnoreCase("time")) {
            method = Types.OpOpDG.TIME;
            InstructionUtils.checkNumFields(s, 1);
        }
        CPOperand out = new CPOperand(s[s.length - 1]);
        Operator op = null;
        if (method == Types.OpOpDG.RAND) {
            int missing;
            CPOperand rows = null;
            CPOperand cols = null;
            CPOperand dims = null;
            if (s.length == 12) {
                missing = 1;
                rows = new CPOperand(s[1]);
                cols = new CPOperand(s[2]);
            } else {
                missing = 2;
                dims = new CPOperand(s[1]);
            }
            int blen = Integer.parseInt(s[4 - missing]);
            double sparsity = !s[7 - missing].contains("\u00b6") ? Double.parseDouble(s[7 - missing]) : -1.0;
            long seed = !s[8 - missing].contains("\u00b6") ? Long.parseLong(s[8 - missing]) : -1L;
            String pdf = s[9 - missing];
            String pdfParams = !s[10 - missing].contains("\u00b6") ? s[10 - missing] : null;
            int k = Integer.parseInt(s[11 - missing]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, dims, blen, s[5 - missing], s[6 - missing], sparsity, seed, pdf, pdfParams, k, opcode, str);
        }
        if (method == Types.OpOpDG.SEQ) {
            int blen = Integer.parseInt(s[3]);
            CPOperand from = new CPOperand(s[4]);
            CPOperand to = new CPOperand(s[5]);
            CPOperand incr = new CPOperand(s[6]);
            return new DataGenCPInstruction(op, method, null, out, null, null, null, blen, from, to, incr, opcode, str);
        }
        if (method == Types.OpOpDG.SAMPLE) {
            CPOperand rows = new CPOperand(s[2]);
            CPOperand cols = new CPOperand("1", Types.ValueType.INT64, Types.DataType.SCALAR);
            boolean replace = !s[3].contains("\u00b6") && Boolean.valueOf(s[3]) != false;
            long seed = Long.parseLong(s[4]);
            int blen = Integer.parseInt(s[5]);
            return new DataGenCPInstruction(op, method, null, out, rows, cols, null, blen, s[1], replace, seed, opcode, str);
        }
        if (method == Types.OpOpDG.TIME) {
            return new DataGenCPInstruction(op, method, out, opcode, str);
        }
        throw new DMLRuntimeException("Unrecognized data generation method: " + (Object)((Object)method));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock soresBlock = null;
        TensorBlock tensorBlock = null;
        IntObject soresScalar = null;
        if (this.method == Types.OpOpDG.RAND) {
            long lSeed;
            long lrows = -1L;
            long lcols = -1L;
            if (this.dims == null) {
                lrows = ec.getScalarInput(this.rows).getLongValue();
                lcols = ec.getScalarInput(this.cols).getLongValue();
                DataGenCPInstruction.checkValidDimensions(lrows, lcols);
            }
            if ((lSeed = this.seed) == -1L) {
                if (this.runtimeSeed == null) {
                    this.runtimeSeed = DataGenOp.generateRandomSeed();
                }
                lSeed = this.runtimeSeed;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction rand with seed = " + lSeed + "."));
            }
            if (this.output.isTensor()) {
                int[] tDims = DataConverter.getTensorDimensions(ec, this.dims);
                tensorBlock = new TensorBlock(this.output.getValueType(), tDims).allocateBlock();
                if (this.minValueStr.equals(this.maxValueStr)) {
                    if (this.minMaxAreDoubles) {
                        tensorBlock.set(this.minValue);
                    } else {
                        if (this.output.getValueType() != Types.ValueType.STRING && this.output.getValueType() != Types.ValueType.BOOLEAN) throw new DMLRuntimeException("Rand instruction cannot fill numeric tensor with non numeric elements.");
                        tensorBlock.set(this.minValueStr);
                    }
                } else {
                    lrows = tensorBlock.getDim(0);
                    lcols = 1L;
                    for (int d = 1; d < tensorBlock.getNumDims(); ++d) {
                        lcols *= (long)tensorBlock.getDim(d);
                    }
                    RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)lrows, (int)lcols, this.blocksize, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
                    soresBlock = MatrixBlock.randOperations(rgen, lSeed, this.numThreads);
                    tensorBlock.set(soresBlock);
                }
            } else {
                RandomMatrixGenerator rgen = LibMatrixDatagen.createRandomMatrixGenerator(this.pdf, (int)lrows, (int)lcols, this.blocksize, this.sparsity, this.minValue, this.maxValue, this.pdfParams);
                soresBlock = MatrixBlock.randOperations(rgen, lSeed, this.numThreads);
            }
            this.runtimeSeed = null;
        } else if (this.method == Types.OpOpDG.SEQ) {
            double lfrom = ec.getScalarInput(this.seq_from).getDoubleValue();
            double lto = ec.getScalarInput(this.seq_to).getDoubleValue();
            double lincr = ec.getScalarInput(this.seq_incr).getDoubleValue();
            lincr = LibMatrixDatagen.updateSeqIncr(lfrom, lto, lincr);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction seq with seqFrom=" + lfrom + ", seqTo=" + lto + ", seqIncr" + lincr));
            }
            soresBlock = MatrixBlock.seqOperations(lfrom, lto, lincr);
        } else if (this.method == Types.OpOpDG.SAMPLE) {
            long lrows = ec.getScalarInput(this.rows).getLongValue();
            long range = UtilFunctions.toLong(this.maxValue);
            DataGenCPInstruction.checkValidDimensions(lrows, 1L);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Process DataGenCPInstruction sample with range=" + range + ", size=" + lrows + ", replace" + this.replace + ", seed=" + this.seed));
            }
            if (range < lrows && !this.replace) {
                throw new DMLRuntimeException("Sample (size=" + lrows + ") larger than population (size=" + range + ") can only be generated with replacement.");
            }
            soresBlock = MatrixBlock.sampleOperations(range, (int)lrows, this.replace, this.seed);
        } else if (this.method == Types.OpOpDG.TIME) {
            soresScalar = new IntObject(System.nanoTime());
        }
        if (this.output.isMatrix()) {
            if (soresBlock.getInMemorySize() < 0x800000L) {
                soresBlock.examSparsity();
            }
            ec.setMatrixOutput(this.output.getName(), soresBlock);
            return;
        } else if (this.output.isTensor()) {
            ec.setTensorOutput(this.output.getName(), tensorBlock);
            return;
        } else {
            if (!this.output.isScalar()) return;
            ec.setScalarOutput(this.output.getName(), soresScalar);
        }
    }

    private static void checkValidDimensions(long rows, long cols) {
        if (rows > Integer.MAX_VALUE || cols > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("DataGenCPInstruction does not support dimensions larger than integer: rows=" + rows + ", cols=" + cols + ".");
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String tmpInstStr = this.instString;
        switch (this.method) {
            case RAND: 
            case SAMPLE: {
                if (this.getSeed() == -1L) {
                    if (this.runtimeSeed == null) {
                        this.runtimeSeed = this.minValue == this.maxValue && this.sparsity == 1.0 ? -1L : DataGenOp.generateRandomSeed();
                    }
                    int position = this.method == Types.OpOpDG.RAND ? 8 : (this.method == Types.OpOpDG.SAMPLE ? 4 : 0);
                    tmpInstStr = position != 0 ? InstructionUtils.replaceOperand(tmpInstStr, position, String.valueOf(this.runtimeSeed)) : tmpInstStr;
                }
                tmpInstStr = InstructionUtils.replaceOperandName(tmpInstStr);
                tmpInstStr = DataGenCPInstruction.replaceNonLiteral(tmpInstStr, this.rows, 2, ec);
                tmpInstStr = DataGenCPInstruction.replaceNonLiteral(tmpInstStr, this.cols, 3, ec);
                break;
            }
            case SEQ: {
                tmpInstStr = InstructionUtils.replaceOperandName(tmpInstStr);
                tmpInstStr = DataGenCPInstruction.replaceNonLiteral(tmpInstStr, this.seq_from, 5, ec);
                tmpInstStr = DataGenCPInstruction.replaceNonLiteral(tmpInstStr, this.seq_to, 6, ec);
                tmpInstStr = DataGenCPInstruction.replaceNonLiteral(tmpInstStr, this.seq_incr, 7, ec);
                break;
            }
            case TIME: {
                break;
            }
            default: {
                throw new DMLRuntimeException("Unsupported datagen op: " + (Object)((Object)this.method));
            }
        }
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(tmpInstStr, this.getOpcode()));
    }

    private static String replaceNonLiteral(String inst, CPOperand op, int pos, ExecutionContext ec) {
        if (!op.isLiteral()) {
            inst = InstructionUtils.replaceOperand(inst, pos, new CPOperand(ec.getScalarInput(op)).getLineageLiteral());
        }
        return inst;
    }
}

