/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimator;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorExact;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorSample;
import org.apache.sysds.runtime.compress.estim.CompressedSizeEstimatorUltraSparse;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CompressedSizeEstimatorFactory {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimatorFactory.class.getName());

    public static CompressedSizeEstimator getSizeEstimator(MatrixBlock data, CompressionSettings cs, int k) {
        int nRows = cs.transposed ? data.getNumColumns() : data.getNumRows();
        int nCols = cs.transposed ? data.getNumRows() : data.getNumColumns();
        int nnzRows = Math.min(nRows, (int)Math.ceil(data.getNonZeros() / (long)nCols));
        double sampleRatio = cs.samplingRatio;
        int minSample = cs.minimumSampleSize;
        int maxSample = Math.min(cs.maxSampleSize, nRows);
        int sampleSize = CompressedSizeEstimatorFactory.getSampleSize(sampleRatio, nRows, nCols, nnzRows, minSample, maxSample);
        if (sampleRatio >= 1.0 || sampleSize >= nRows) {
            if (nRows > 10000 && nCols > 10 && data.isInSparseFormat() && !cs.transposed) {
                if (!cs.isInSparkInstruction) {
                    LOG.debug((Object)"Transposing for exact estimator");
                }
                data = LibMatrixReorg.transpose(data, new MatrixBlock(data.getNumColumns(), data.getNumRows(), data.isInSparseFormat()), k);
                cs.transposed = true;
            }
            if (!cs.isInSparkInstruction) {
                LOG.debug((Object)"Using Exact estimator");
            }
            return new CompressedSizeEstimatorExact(data, cs);
        }
        if (nCols > 1000 && data.getSparsity() < 1.0E-5) {
            return CompressedSizeEstimatorUltraSparse.create(data, cs, k);
        }
        if (!cs.isInSparkInstruction) {
            LOG.debug((Object)("Trying sample size: " + sampleSize));
        }
        return new CompressedSizeEstimatorSample(data, cs, sampleSize, k);
    }

    private static int getSampleSize(double sampleRatio, int nRows, int nCols, int nnzRows, int minSampleSize, int maxSampleSize) {
        int sampleSize = minSampleSize;
        sampleSize += (int)Math.ceil(Math.pow(nRows, 0.65));
        sampleSize = (int)Math.min((double)sampleSize * ((double)nRows / (double)nnzRows), (double)maxSampleSize);
        return sampleSize;
    }
}

