/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CLALibDecompress {
    private static final Log LOG = LogFactory.getLog((String)CLALibDecompress.class.getName());

    public static MatrixBlock decompress(CompressedMatrixBlock cmb, int k) {
        ArrayList<AColGroup> filteredGroups;
        int block;
        ArrayList<AColGroup> groups = new ArrayList<AColGroup>(cmb.getColGroups());
        int nRows = cmb.getNumRows();
        int nCols = cmb.getNumColumns();
        boolean overlapping = cmb.isOverlapping();
        long nonZeros = cmb.getNonZeros();
        MatrixBlock ret = CLALibDecompress.getUncompressedColGroupAndRemoveFromListOfColGroups(groups, overlapping, nRows, nCols);
        if (ret != null && groups.size() == 0) {
            ret.setNonZeros(ret.recomputeNonZeros());
            return ret;
        }
        if (ret == null) {
            ret = new MatrixBlock(nRows, nCols, false, -1L);
            ret.allocateDenseBlock();
        }
        int blklen = (block = (int)Math.ceil(65535.0 / (double)nCols)) > 1000 ? block + 1000 - block % 1000 : Math.max(64, block);
        boolean containsSDC = CLALibUtils.containsSDCOrConst(groups);
        double[] constV = containsSDC ? new double[ret.getNumColumns()] : null;
        List<AColGroup> list = filteredGroups = containsSDC ? CLALibUtils.filterGroups(groups, constV) : groups;
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)("Decompressing with block size: " + blklen));
        }
        CLALibDecompress.sortGroups(filteredGroups, overlapping);
        if (groups == filteredGroups) {
            constV = null;
        }
        double eps = CLALibDecompress.getEps(constV);
        if (k == 1) {
            CLALibDecompress.decompressSingleThread(ret, filteredGroups, nRows, blklen, constV, eps, nonZeros, overlapping);
        } else {
            CLALibDecompress.decompressMultiThread(ret, filteredGroups, nRows, blklen, constV, eps, overlapping, k);
        }
        if (overlapping) {
            ret.recomputeNonZeros();
        }
        ret.examSparsity();
        return ret;
    }

    private static MatrixBlock getUncompressedColGroupAndRemoveFromListOfColGroups(List<AColGroup> colGroups, boolean overlapping, int nRows, int nCols) {
        MatrixBlock ret = null;
        if (overlapping || colGroups.size() == 1) {
            for (int i = 0; i < colGroups.size(); ++i) {
                ColGroupUncompressed guc;
                MatrixBlock gMB;
                AColGroup g = colGroups.get(i);
                if (!(g instanceof ColGroupUncompressed) || (gMB = (guc = (ColGroupUncompressed)g).getData()).getNumColumns() != nCols || gMB.getNumRows() != nRows || gMB.isInSparseFormat() && colGroups.size() != 1) continue;
                colGroups.remove(i);
                LOG.debug((Object)"Using one of the uncompressed ColGroups as base for decompression");
                return gMB;
            }
        }
        return ret;
    }

    private static void decompressSingleThread(MatrixBlock ret, List<AColGroup> filteredGroups, int rlen, int blklen, double[] constV, double eps, long nonZeros, boolean overlapping) {
        for (int i = 0; i < rlen; i += blklen) {
            int rl = i;
            int ru = Math.min(i + blklen, rlen);
            for (AColGroup grp : filteredGroups) {
                grp.decompressToBlock(ret, rl, ru);
            }
            if (constV == null || ret.isInSparseFormat()) continue;
            CLALibDecompress.addVector(ret, constV, eps, rl, ru);
        }
        ret.setNonZeros(nonZeros == -1L || overlapping ? ret.recomputeNonZeros() : nonZeros);
    }

    private static void decompressMultiThread(MatrixBlock ret, List<AColGroup> filteredGroups, int rlen, int blklen, double[] constV, double eps, boolean overlapping, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            ArrayList<DecompressTask> tasks = new ArrayList<DecompressTask>();
            int i = 0;
            while (i * blklen < rlen) {
                tasks.add(new DecompressTask(filteredGroups, ret, eps, i * blklen, Math.min((i + 1) * blklen, rlen), overlapping, constV));
                ++i;
            }
            List rtasks = pool.invokeAll(tasks);
            pool.shutdown();
            long nnz = 0L;
            for (Future rt : rtasks) {
                nnz += ((Long)rt.get()).longValue();
            }
            ret.setNonZeros(nnz);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new DMLCompressionException("Parallel decompression failed", ex);
        }
    }

    private static void sortGroups(List<AColGroup> groups, boolean overlapping) {
        if (overlapping) {
            Comparator<AColGroup> comp = Comparator.comparing(x -> CLALibDecompress.effect(x));
            groups.sort(comp);
        }
    }

    private static double effect(AColGroup x) {
        return x instanceof ColGroupUncompressed ? -1.7976931348623157E308 : -Math.max(x.getMax(), Math.abs(x.getMin()));
    }

    private static double getEps(double[] constV) {
        if (constV == null) {
            return 0.0;
        }
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        for (double v : constV) {
            if (v > max) {
                max = v;
            }
            if (!(v < min)) continue;
            min = v;
        }
        double eps = (max + 1.0E-4 - min) * 1.0E-10;
        return eps;
    }

    private static void addVector(MatrixBlock ret, double[] rowV, double eps, int rl, int ru) {
        int nCols = ret.getNumColumns();
        DenseBlock db = ret.getDenseBlock();
        if (eps == 0.0) {
            for (int row = rl; row < ru; ++row) {
                double[] _retV = db.values(row);
                int off = db.pos(row);
                for (int col = 0; col < nCols; ++col) {
                    int n = off + col;
                    _retV[n] = _retV[n] + rowV[col];
                }
            }
        } else {
            for (int row = rl; row < ru; ++row) {
                double[] _retV = db.values(row);
                int off = db.pos(row);
                for (int col = 0; col < nCols; ++col) {
                    int out;
                    int n = out = off + col;
                    _retV[n] = _retV[n] + rowV[col];
                    if (!(Math.abs(_retV[out]) <= eps)) continue;
                    _retV[out] = 0.0;
                }
            }
        }
    }

    private static class DecompressTask
    implements Callable<Long> {
        private final List<AColGroup> _colGroups;
        private final MatrixBlock _ret;
        private final double _eps;
        private final int _rl;
        private final int _ru;
        private final double[] _constV;
        private final boolean _overlapping;

        protected DecompressTask(List<AColGroup> colGroups, MatrixBlock ret, double eps, int rl, int ru, boolean overlapping, double[] constV) {
            this._colGroups = colGroups;
            this._ret = ret;
            this._eps = eps;
            this._rl = rl;
            this._ru = ru;
            this._overlapping = overlapping;
            this._constV = constV;
        }

        @Override
        public Long call() {
            for (AColGroup grp : this._colGroups) {
                grp.decompressToBlock(this._ret, this._rl, this._ru);
            }
            if (this._constV != null) {
                CLALibDecompress.addVector(this._ret, this._constV, this._eps, this._rl, this._ru);
            }
            return this._overlapping ? 0L : this._ret.recomputeNonZeros(this._rl, this._ru - 1);
        }
    }
}

