/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.ipc.stats;

import java.io.IOException;
import java.net.URL;
import org.apache.avro.AvroRemoteException;
import org.apache.avro.Protocol;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.RPCPlugin;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.generic.GenericRequestor;
import org.apache.avro.ipc.generic.GenericResponder;
import org.apache.avro.ipc.stats.StatsPlugin;

public class StatsPluginOverhead {
    private static final int COUNT = 100000;
    private static final Protocol NULL_PROTOCOL = Protocol.parse((String)"{\"protocol\": \"null\", \"messages\": { \"null\": {   \"request\": [],    \"response\": \"null\"} } }");

    public static void main(String[] args) throws Exception {
        double with = (double)StatsPluginOverhead.sendRpcs(true) / 1.0E9;
        double without = (double)StatsPluginOverhead.sendRpcs(false) / 1.0E9;
        System.out.println(String.format("Overhead: %f%%.  RPC/s: %f (with) vs %f (without).  RPC time (ms): %f vs %f", 100.0 * (with - without) / without, 100000.0 / with, 100000.0 / without, 1000.0 * with / 100000.0, 1000.0 * without / 100000.0));
    }

    private static long sendRpcs(boolean withPlugin) throws IOException {
        HttpServer server = StatsPluginOverhead.createServer(withPlugin);
        HttpTransceiver t = new HttpTransceiver(new URL("http://127.0.0.1:" + server.getPort() + "/"));
        GenericRequestor requestor = new GenericRequestor(NULL_PROTOCOL, (Transceiver)t);
        long now = System.nanoTime();
        for (int i = 0; i < 100000; ++i) {
            requestor.request("null", null);
        }
        long elapsed = System.nanoTime() - now;
        t.close();
        server.close();
        return elapsed;
    }

    private static HttpServer createServer(boolean withPlugin) throws IOException {
        IdentityResponder r = new IdentityResponder(NULL_PROTOCOL);
        if (withPlugin) {
            r.addRPCPlugin((RPCPlugin)new StatsPlugin());
        }
        HttpServer server = new HttpServer((Responder)r, 0);
        server.start();
        return server;
    }

    private static class IdentityResponder
    extends GenericResponder {
        public IdentityResponder(Protocol local) {
            super(local);
        }

        public Object respond(Protocol.Message message, Object request) throws AvroRemoteException {
            return request;
        }
    }
}

