/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public class ColGroupSDCSingleZeros
extends ColGroupValue {
    private static final long serialVersionUID = 8033235615964315078L;
    protected transient AOffset _indexes;

    protected ColGroupSDCSingleZeros(int numRows) {
        super(numRows);
    }

    protected ColGroupSDCSingleZeros(int[] colIndices, int numRows, ADictionary dict, AOffset offsets) {
        super(colIndices, numRows, dict, null);
        this._indexes = offsets;
        this._zeros = true;
    }

    protected ColGroupSDCSingleZeros(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._zeros = true;
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCSingleZeros;
    }

    @Override
    protected void decompressToBlockDenseDictionary(MatrixBlock target, int rl, int ru, int offT, double[] values) {
        int nCol = this._colIndexes.length;
        int offTCorr = offT - rl;
        DenseBlock db = target.getDenseBlock();
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int idx = offTCorr + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx);
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j];
                c[n] = c[n] + values[j];
            }
            it.next();
        }
        this._indexes.cacheIterator(it, ru);
    }

    @Override
    protected void decompressToBlockSparseDictionary(MatrixBlock target, int rl, int ru, int offT, SparseBlock values) {
        int offTCorr = offT - rl;
        DenseBlock db = target.getDenseBlock();
        int apos = values.pos(0);
        int alen = values.size(0) + apos;
        int[] aix = values.indexes(0);
        double[] avals = values.values(0);
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int idx = offTCorr + it.value();
            double[] c = db.values(idx);
            int off = db.pos(idx);
            for (int j = apos; j < alen; ++j) {
                int n = off + this._colIndexes[aix[j]];
                c[n] = c[n] + avals[j];
            }
            it.next();
        }
        this._indexes.cacheIterator(it, ru);
    }

    @Override
    public double get(int r, int c) {
        int ix = Arrays.binarySearch(this._colIndexes, c);
        if (ix < 0) {
            throw new RuntimeException("Column index " + c + " not in group.");
        }
        AIterator it = this._indexes.getIterator(r);
        if (it.value() == r) {
            return this._dict.getValue(ix);
        }
        return 0.0;
    }

    @Override
    public void countNonZerosPerRow(int[] rnnz, int rl, int ru) {
        int nCol = this._colIndexes.length;
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int n = it.value() - rl;
            rnnz[n] = rnnz[n] + nCol;
            it.next();
        }
    }

    @Override
    protected void computeRowSums(double[] c, boolean square, int rl, int ru) {
        double vals = this._dict.sumAllRowsToDouble(square, this._colIndexes.length)[0];
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            int n = it.value();
            c[n] = c[n] + vals;
            it.next();
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru) {
        int rix;
        double vals = this._dict.aggregateTuples(builtin, this._colIndexes.length)[0];
        AIterator it = this._indexes.getIterator(rl);
        for (rix = rl; rix < ru && it.hasNext(); ++rix) {
            if (it.value() != rix) {
                c[rix] = builtin.execute(c[rix], 0.0);
                continue;
            }
            c[rix] = builtin.execute(c[rix], vals);
            it.next();
        }
        while (rix < ru) {
            c[rix] = builtin.execute(c[rix], 0.0);
            ++rix;
        }
    }

    @Override
    public int[] getCounts(int[] counts) {
        counts[0] = this._indexes.getSize();
        counts[1] = this._numRows - counts[0];
        return counts;
    }

    @Override
    public int[] getCounts(int rl, int ru, int[] counts) {
        AIterator it = this._indexes.getIterator(rl);
        while (it.hasNext() && it.value() < ru) {
            it.next();
            counts[0] = counts[0] + 1;
        }
        counts[1] = ru - rl - counts[0];
        return counts;
    }

    @Override
    public void preAggregate(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        if (m.isInSparseFormat()) {
            this.preAggregateSparse(m.getSparseBlock(), preAgg, rl, ru);
        } else {
            this.preAggregateDense(m, preAgg, rl, ru);
        }
    }

    @Override
    public void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru, int cl, int cu) {
        double[] mV = m.getDenseBlockValues();
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int blockSize = 2000;
        for (int block = cl; block < cu; block += 2000) {
            int blockEnd = Math.min(block + 2000, cu);
            AIterator itStart = this._indexes.getIterator(block);
            int rowLeft = rl;
            int offOut = 0;
            while (rowLeft < ru) {
                int offLeft = rowLeft * this._numRows;
                AIterator it = itStart.clone();
                while (it.value() < blockEnd && it.hasNext()) {
                    int i = it.value();
                    int n = offOut;
                    preAV[n] = preAV[n] + mV[offLeft + i];
                    it.next();
                }
                ++rowLeft;
                offOut += numVals;
            }
        }
    }

    private void preAggregateDense(MatrixBlock m, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        double[] mV = m.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            AIterator it = this._indexes.getIterator();
            int offLeft = rowLeft * this._numRows;
            while (it.hasNext()) {
                int i = it.value();
                int n = offOut;
                preAV[n] = preAV[n] + mV[offLeft + i];
                it.next();
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    private void preAggregateSparse(SparseBlock sb, MatrixBlock preAgg, int rl, int ru) {
        double[] preAV = preAgg.getDenseBlockValues();
        int numVals = this.getNumValues();
        int rowLeft = rl;
        int offOut = 0;
        while (rowLeft < ru) {
            if (!sb.isEmpty(rowLeft)) {
                AIterator it = this._indexes.getIterator();
                int apos = sb.pos(rowLeft);
                int alen = sb.size(rowLeft) + apos;
                int[] aix = sb.indexes(rowLeft);
                double[] avals = sb.values(rowLeft);
                int j = apos;
                while (it.hasNext() && j < alen) {
                    int index = aix[j];
                    int v = it.value();
                    if (index < v) {
                        ++j;
                        continue;
                    }
                    if (index == v) {
                        int n = offOut;
                        preAV[n] = preAV[n] + avals[j++];
                        it.next();
                        continue;
                    }
                    it.next();
                }
            }
            ++rowLeft;
            offOut += numVals;
        }
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._indexes.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        boolean isSparseSafeOp;
        double val0 = op.executeScalar(0.0);
        boolean bl = isSparseSafeOp = op.sparseSafe || val0 == 0.0;
        if (isSparseSafeOp) {
            return new ColGroupSDCSingleZeros(this._colIndexes, this._numRows, this.applyScalarOp(op), this._indexes, this.getCachedCounts());
        }
        ADictionary aDictionary = this.applyScalarOp(op, val0, this.getNumCols());
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, aDictionary, this._indexes, null);
    }

    @Override
    public AColGroup binaryRowOp(BinaryOperator op, double[] v, boolean sparseSafe, boolean left) {
        if (sparseSafe) {
            return new ColGroupSDCSingleZeros(this._colIndexes, this._numRows, this.applyBinaryRowOp(op, v, sparseSafe, left), this._indexes, this.getCachedCounts());
        }
        ADictionary aDictionary = this.applyBinaryRowOp(op, v, sparseSafe, left);
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, aDictionary, this._indexes, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._indexes.getExactSizeOnDisk();
    }

    @Override
    public boolean sameIndexStructure(ColGroupCompressed that) {
        return that instanceof ColGroupSDCSingleZeros && ((ColGroupSDCSingleZeros)that)._indexes == this._indexes;
    }

    @Override
    public int getIndexStructureHash() {
        return this._indexes.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s ", "Indexes: "));
        sb.append(this._indexes.toString());
        return sb.toString();
    }

    @Override
    public Dictionary preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThis.hasNext()) {
            int fr = that._data.getIndex(itThis.value());
            that._dict.addToEntry(ret, fr, 0, nCol);
            itThis.next();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCStructure(ColGroupSDC that, Dictionary ret, boolean preModified) {
        throw new NotImplementedException();
    }

    @Override
    public Dictionary preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext() && itThis.hasNext()) {
            int v = itThat.value();
            if (v == itThis.skipTo(v)) {
                that._dict.addToEntry(ret, that.getIndex(itThat.getDataIndex()), 0, nCol);
            }
            itThat.next();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        while (itThat.hasNext()) {
            int v = itThat.value();
            if (v == itThis.skipTo(v)) {
                that._dict.addToEntry(ret, 0, 0, nCol);
            }
            itThat.next();
        }
        return ret;
    }

    @Override
    public Dictionary preAggregateThatSDCSingleStructure(ColGroupSDCSingle that, Dictionary ret, boolean preModified) {
        AIterator itThat = that._indexes.getIterator();
        AIterator itThis = this._indexes.getIterator();
        int nCol = that._colIndexes.length;
        if (preModified) {
            while (itThat.hasNext()) {
                int thatV = itThat.value();
                if (thatV == itThis.skipTo(thatV)) {
                    that._dict.addToEntry(ret, 0, 0, nCol);
                }
                itThat.next();
            }
            return ret;
        }
        throw new NotImplementedException();
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        if (pattern == 0.0) {
            return this.replaceZero(replace);
        }
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length);
        return this.copyAndSet(replaced);
    }

    private AColGroup replaceZero(double replace) {
        ADictionary replaced = this._dict.replaceZeroAndExtend(replace, this._colIndexes.length);
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, replaced, this._indexes, this.getCachedCounts());
    }
}

