/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LineageGPUCacheEviction {
    private static long _currentCacheSize = 0L;
    private static long GPU_CACHE_LIMIT;
    private static long _startTimestamp;
    public static ExecutorService gpuEvictionThread;
    private static TreeSet<LineageCacheEntry> weightedQueue;

    protected static void resetEviction() {
        while (!weightedQueue.isEmpty()) {
            LineageCacheEntry e = weightedQueue.pollFirst();
            e._gpuObject.setIsLinCached(false);
            e._gpuObject.clearData(null, true);
        }
        _currentCacheSize = 0L;
        gpuEvictionThread = null;
        weightedQueue.clear();
    }

    public static void setGPULineageCacheLimit() {
        long available = GPUContextPool.initialGPUMemBudget();
        GPU_CACHE_LIMIT = (long)((double)available * 0.3);
    }

    protected static void setStartTimestamp() {
        _startTimestamp = System.currentTimeMillis();
    }

    protected static long getStartTimestamp() {
        return _startTimestamp;
    }

    private static void adjustD2HTransferSpeed(double sizeByte, double copyTime) {
        double sizeMB = sizeByte / 1048576.0;
        double newTSpeed = sizeMB / copyTime;
        if (newTSpeed > LineageCacheConfig.D2HMAXBANDWIDTH) {
            return;
        }
        double smFactor = 0.5;
        LineageCacheConfig.D2HCOPY = smFactor * newTSpeed + (1.0 - smFactor) * LineageCacheConfig.D2HCOPY;
    }

    protected static void addEntry(LineageCacheEntry entry) {
        if (entry.isNullVal()) {
            return;
        }
        if (entry.isScalarValue()) {
            throw new DMLRuntimeException("Scalars are never stored in GPU. Lineage: " + entry._key);
        }
        entry.computeScore(LineageCacheEviction._removelist);
        weightedQueue.add(entry);
    }

    public static boolean isGPUCacheEmpty() {
        return weightedQueue.isEmpty();
    }

    public static LineageCacheEntry pollFirstEntry() {
        return weightedQueue.pollFirst();
    }

    public static LineageCacheEntry peekFirstEntry() {
        return weightedQueue.first();
    }

    public static void removeEntry(LineageCacheEntry e) {
        weightedQueue.remove(e);
    }

    public static void addEntryList(List<LineageCacheEntry> entryList) {
        weightedQueue.addAll(entryList);
    }

    protected static void updateSize(long space, boolean addspace) {
        _currentCacheSize = addspace ? (_currentCacheSize += space) : (_currentCacheSize -= space);
    }

    protected static boolean isBelowMaxThreshold(long spaceNeeded) {
        return spaceNeeded + _currentCacheSize <= GPU_CACHE_LIMIT;
    }

    protected static long getGPUCacheLimit() {
        return GPU_CACHE_LIMIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToHostCache(LineageCacheEntry entry, String instName, boolean alreadyCopied) {
        long t0 = System.nanoTime();
        MatrixBlock mb = alreadyCopied ? (MatrixBlock)entry._gpuObject.getMatrixObject().acquireReadAndRelease() : entry._gpuObject.evictFromDeviceToHostMB(instName, false);
        long t1 = System.nanoTime();
        LineageGPUCacheEviction.adjustD2HTransferSpeed(entry._gpuObject.getSizeOnDevice(), (double)(t1 - t0) / 1.0E9);
        long size = mb.getInMemorySize();
        if (!LineageCacheEviction.isBelowThreshold(size)) {
            Map<LineageItem, LineageCacheEntry> map = LineageCache.getLineageCache();
            synchronized (map) {
                LineageCacheEviction.makeSpace(LineageCache.getLineageCache(), size);
            }
        }
        LineageCacheEviction.updateSize(size, true);
        entry.setValue(mb);
        LineageCacheEviction.addEntry(entry);
        LineageGPUCacheEviction.updateSize(size, false);
    }

    static {
        _startTimestamp = 0L;
        gpuEvictionThread = null;
        weightedQueue = new TreeSet<LineageCacheEntry>(LineageCacheConfig.LineageCacheComparator);
    }
}

