/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupConst;
import org.apache.sysds.runtime.compress.lib.CLALibUtils;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class CLALibSlice {
    protected static final Log LOG = LogFactory.getLog((String)CLALibSlice.class.getName());

    public static MatrixBlock slice(CompressedMatrixBlock cmb, int rl, int ru, int cl, int cu, boolean deep) {
        if (rl == ru && cl == cu) {
            return CLALibSlice.sliceSingle(cmb, rl, cl);
        }
        if (rl == 0 && ru == cmb.getNumRows() - 1) {
            return CLALibSlice.sliceColumns(cmb, cl, cu);
        }
        if (cl == 0 && cu == cmb.getNumColumns() - 1) {
            return CLALibSlice.sliceRows(cmb, rl, ru);
        }
        return CLALibSlice.sliceInternal(cmb, rl, ru, cl, cu);
    }

    private static MatrixBlock sliceInternal(CompressedMatrixBlock cmb, int rl, int ru, int cl, int cu) {
        return CLALibSlice.sliceRows(CLALibSlice.sliceColumns(cmb, cl, cu), rl, ru);
    }

    private static MatrixBlock sliceRows(CompressedMatrixBlock cmb, int rl, int ru) {
        int nCol = cmb.getNumColumns();
        int rue = ru + 1;
        MatrixBlock tmp = new MatrixBlock(rue - rl, nCol, false).allocateDenseBlock();
        DenseBlock db = tmp.getDenseBlock();
        List<AColGroup> groups = cmb.getColGroups();
        boolean shouldFilter = CLALibUtils.shouldPreFilter(groups);
        if (shouldFilter) {
            double[] constV = new double[nCol];
            List<AColGroup> filteredGroups = CLALibUtils.filterGroups(groups, constV);
            for (AColGroup g : filteredGroups) {
                g.decompressToDenseBlock(db, rl, rue, -rl, 0);
            }
            AColGroup cRet = ColGroupConst.create(constV);
            cRet.decompressToDenseBlock(db, rl, rue, -rl, 0);
        } else {
            for (AColGroup g : groups) {
                g.decompressToDenseBlock(db, rl, rue, -rl, 0);
            }
        }
        tmp.recomputeNonZeros();
        tmp.examSparsity();
        return tmp;
    }

    private static MatrixBlock sliceSingle(CompressedMatrixBlock cmb, int row, int col) {
        MatrixBlock tmp = new MatrixBlock(1, 1, 0L);
        tmp.setValue(0, 0, cmb.getValue(row, col));
        return tmp;
    }

    private static CompressedMatrixBlock sliceColumns(CompressedMatrixBlock cmb, int cl, int cu) {
        int cue = cu + 1;
        CompressedMatrixBlock ret = new CompressedMatrixBlock(cmb.getNumRows(), cue - cl);
        ArrayList<AColGroup> newColGroups = new ArrayList<AColGroup>();
        for (AColGroup grp : cmb.getColGroups()) {
            AColGroup slice = grp.sliceColumns(cl, cue);
            if (slice == null) continue;
            newColGroups.add(slice);
        }
        ret.allocateColGroupList(newColGroups);
        ret.recomputeNonZeros();
        ret.setOverlapping(cmb.isOverlapping());
        return ret;
    }
}

