/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;

public class OffsetSingle
extends AOffset {
    private static final long serialVersionUID = -614636669776415032L;
    private final int off;

    public OffsetSingle(int off) {
        this.off = off;
    }

    @Override
    public AIterator getIterator() {
        return new IterateSingle();
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        return new IterateOffsetSingle();
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5L;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public int getOffsetToFirst() {
        return this.off;
    }

    @Override
    public int getOffsetToLast() {
        return this.off;
    }

    @Override
    public int getOffsetsLength() {
        return 0;
    }

    @Override
    public long getInMemorySize() {
        return OffsetSingle.estimateInMemorySize();
    }

    public static long estimateInMemorySize() {
        return 20L;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE.SINGLE_OFFSET.ordinal());
        out.writeInt(this.off);
    }

    public static OffsetSingle readFields(DataInput in) throws IOException {
        return new OffsetSingle(in.readInt());
    }

    private class IterateOffsetSingle
    extends AOffsetIterator {
        private IterateOffsetSingle() {
            super(OffsetSingle.this.off);
        }

        @Override
        public int next() {
            return OffsetSingle.this.off;
        }
    }

    private class IterateSingle
    extends AIterator {
        private IterateSingle() {
            super(OffsetSingle.this.off);
        }

        @Override
        public int next() {
            return OffsetSingle.this.off;
        }

        @Override
        public int skipTo(int idx) {
            return OffsetSingle.this.off;
        }

        @Override
        public IterateSingle clone() {
            return this;
        }

        @Override
        public int getDataIndex() {
            return 0;
        }

        @Override
        public int getOffsetsIndex() {
            return 0;
        }
    }
}

