/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.instructions.spark.data.CorrMatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.sketch.countdistinctapprox.KMVSketch;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperator;
import org.apache.sysds.runtime.matrix.operators.CountDistinctOperatorTypes;
import org.apache.sysds.utils.Hash;

public interface LibMatrixCountDistinct {
    public static final Log LOG = LogFactory.getLog((String)LibMatrixCountDistinct.class.getName());
    public static final int minimumSize = 1024;

    public static int estimateDistinctValues(MatrixBlock in, CountDistinctOperator op) {
        int res = 0;
        if (op.getOperatorType() == CountDistinctOperatorTypes.KMV && (op.getHashType() == Hash.HashType.ExpHash || op.getHashType() == Hash.HashType.StandardJava)) {
            throw new DMLException("Invalid hashing configuration using " + op.getHashType() + " and " + op.getOperatorType());
        }
        if (op.getOperatorType() == CountDistinctOperatorTypes.HLL) {
            throw new NotImplementedException("HyperLogLog not implemented");
        }
        if (in.getLength() == 1L || in.isEmpty()) {
            return 1;
        }
        if (in.getNonZeros() < 1024L) {
            res = LibMatrixCountDistinct.countDistinctValuesNaive(in);
        } else {
            switch (op.getOperatorType()) {
                case COUNT: {
                    res = LibMatrixCountDistinct.countDistinctValuesNaive(in);
                    break;
                }
                case KMV: {
                    res = new KMVSketch(op).getScalarValue(in);
                    break;
                }
                default: {
                    throw new DMLException("Invalid or not implemented Estimator Type");
                }
            }
        }
        if (res <= 0) {
            throw new DMLRuntimeException("Impossible estimate of distinct values");
        }
        return res;
    }

    private static int countDistinctValuesNaive(MatrixBlock in) {
        HashSet<Double> distinct;
        block8: {
            block7: {
                distinct = new HashSet<Double>();
                if (in.isEmpty()) {
                    return 1;
                }
                if (in instanceof CompressedMatrixBlock) {
                    throw new NotImplementedException();
                }
                long nonZeros = in.getNonZeros();
                if (nonZeros != -1L && nonZeros < (long)(in.getNumColumns() * in.getNumRows())) {
                    distinct.add(0.0);
                }
                if (in.sparseBlock == null) break block7;
                SparseBlock sb = in.sparseBlock;
                if (in.sparseBlock.isContiguous()) {
                    double[] data = sb.values(0);
                    LibMatrixCountDistinct.countDistinctValuesNaive(data, distinct);
                } else {
                    for (int i = 0; i < in.getNumRows(); ++i) {
                        if (sb.isEmpty(i)) continue;
                        double[] data = in.sparseBlock.values(i);
                        LibMatrixCountDistinct.countDistinctValuesNaive(data, distinct);
                    }
                }
                break block8;
            }
            if (in.denseBlock == null) break block8;
            DenseBlock db = in.denseBlock;
            for (int i = 0; i <= db.numBlocks(); ++i) {
                double[] data = db.valuesAt(i);
                LibMatrixCountDistinct.countDistinctValuesNaive(data, distinct);
            }
        }
        return distinct.size();
    }

    private static Set<Double> countDistinctValuesNaive(double[] valuesPart, Set<Double> distinct) {
        for (double v : valuesPart) {
            distinct.add(v);
        }
        return distinct;
    }

    public static MatrixBlock countDistinctValuesFromSketch(CorrMatrixBlock arg0, CountDistinctOperator op) {
        if (op.getOperatorType() == CountDistinctOperatorTypes.KMV) {
            return new KMVSketch(op).getMatrixValue(arg0);
        }
        if (op.getOperatorType() == CountDistinctOperatorTypes.HLL) {
            throw new NotImplementedException("Not implemented yet");
        }
        throw new NotImplementedException("Not implemented yet");
    }

    public static CorrMatrixBlock createSketch(MatrixBlock blkIn, CountDistinctOperator op) {
        if (op.getOperatorType() == CountDistinctOperatorTypes.KMV) {
            return new KMVSketch(op).create(blkIn);
        }
        if (op.getOperatorType() == CountDistinctOperatorTypes.HLL) {
            throw new NotImplementedException("Not implemented yet");
        }
        throw new NotImplementedException("Not implemented yet");
    }

    public static CorrMatrixBlock unionSketch(CorrMatrixBlock arg0, CorrMatrixBlock arg1, CountDistinctOperator op) {
        if (op.getOperatorType() == CountDistinctOperatorTypes.KMV) {
            return new KMVSketch(op).union(arg0, arg1);
        }
        if (op.getOperatorType() == CountDistinctOperatorTypes.HLL) {
            throw new NotImplementedException("Not implemented yet");
        }
        throw new NotImplementedException("Not implemented yet");
    }
}

