# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/mice.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def mice(X: Matrix,
         cMask: Matrix,
         **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     This Builtin function implements multiple imputation using Chained Equations (MICE)
    
     Assumption missing value are represented with empty string i.e ",," in CSV file  
     variables with suffix n are storing continuos/numeric data and variables with 
     suffix c are storing categorical data
    
    
    
    :param X: Data Matrix (Recoded Matrix for categorical features)
    :param cMask: A 0/1 row vector for identifying numeric (0) and categorical features (1)
    :param iter: Number of iteration for multiple imputations
    :param threshold: confidence value [0, 1] for robust imputation, values will only be imputed
        if the predicted value has probability greater than threshold,
        only applicable for categorical data
    :param verbose: Boolean value.
    :return: imputed dataset
    """

    params_dict = {'X': X, 'cMask': cMask}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(X.sds_context, '')
    vX_1 = Matrix(X.sds_context, '')
    vX_2 = Scalar(X.sds_context, '')
    vX_3 = Frame(X.sds_context, '')
    vX_4 = List(X.sds_context, '')
    output_nodes = [vX_0, vX_1, vX_2, vX_3, vX_4, ]

    op = MultiReturn(X.sds_context, 'mice', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]
    vX_2._unnamed_input_nodes = [op]
    vX_3._unnamed_input_nodes = [op]
    vX_4._unnamed_input_nodes = [op]

    return op
