/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api.mlcontext;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.sysds.api.mlcontext.MLContextException;

public class ProjectInfo {
    SortedMap<String, String> properties = null;
    static ProjectInfo projectInfo = null;

    public static ProjectInfo getProjectInfo() {
        if (projectInfo == null) {
            projectInfo = new ProjectInfo();
        }
        return projectInfo;
    }

    private ProjectInfo() {
        String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try (JarFile systemDsJar = new JarFile(path);){
            Manifest manifest = systemDsJar.getManifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            this.properties = new TreeMap<String, String>();
            for (Object key : mainAttributes.keySet()) {
                String value = mainAttributes.getValue((Attributes.Name)key);
                this.properties.put(key.toString(), value);
            }
        }
        catch (Exception e) {
            throw new MLContextException("Error trying to read from manifest in SystemDS jar file", e);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Set<String> keySet = this.properties.keySet();
        for (String key : keySet) {
            sb.append(key + ": " + (String)this.properties.get(key) + "\n");
        }
        return sb.toString();
    }

    public String property(String key) {
        return (String)this.properties.get(key);
    }

    public String version() {
        return this.property("Version");
    }

    public String buildTime() {
        return this.property("Build-Time");
    }

    public String minimumRecommendedSparkVersion() {
        return this.property("Minimum-Recommended-Spark-Version");
    }

    public SortedMap<String, String> properties() {
        return this.properties;
    }
}

