/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.local;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.executor.ExecutorBackend;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.launcher.LauncherBackend;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.scheduler.LiveListenerBus;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.ExecutorInfo;
import org.apache.spark.scheduler.local.KillTask;
import org.apache.spark.scheduler.local.LocalEndpoint;
import org.apache.spark.scheduler.local.ReviveOffers$;
import org.apache.spark.scheduler.local.StatusUpdate;
import org.apache.spark.scheduler.local.StopExecutor$;
import org.apache.spark.storage.BlockManagerId;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u000e\u001d\u0001\u00012\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011}\u0001!\u0011!Q\u0001\n\rC\u0001B\u0012\u0001\u0003\u0006\u0004%\ta\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0011\")A\n\u0001C\u0001\u001b\"91\u000b\u0001b\u0001\n\u0013!\u0006BB/\u0001A\u0003%Q\u000bC\u0004_\u0001\u0001\u0007I\u0011B0\t\u000f\u0019\u0004\u0001\u0019!C\u0005O\"1Q\u000e\u0001Q!\n\u0001DqA\u001c\u0001C\u0002\u0013%q\u000eC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u00029\t\u0013\u0005\u001d\u0001A1A\u0005\n\u0005%\u0001\u0002CA\t\u0001\u0001\u0006I!a\u0003\t\u0013\u0005M\u0001A1A\u0005\n\u0005U\u0001\u0002CA\u0012\u0001\u0001\u0006I!a\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u0018\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003c\u0001A\u0011IA\u0017\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000e\u0001\t\u0003\nI\u0004C\u0004\u0002f\u0001!\t%a\u001a\t\u000f\u0005e\u0005\u0001\"\u0011\u0002\u001c\"9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBA\u0018\u0001\u0011%\u0011\u0011\u0017\u0002\u0016\u0019>\u001c\u0017\r\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e\u0015\tib$A\u0003m_\u000e\fGN\u0003\u0002 A\u0005I1o\u00195fIVdWM\u001d\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sON)\u0001aJ\u00172oA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0018\u000e\u0003yI!\u0001\r\u0010\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b!\u0003!)\u00070Z2vi>\u0014\u0018B\u0001\u001c4\u0005=)\u00050Z2vi>\u0014()Y2lK:$\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e!\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001f:\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001C\u0001!B\u001b\u0005\u0001\u0013B\u0001\"!\u0005%\u0019\u0006/\u0019:l\u0007>tg\r\u0005\u0002/\t&\u0011QI\b\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017A\u0003;pi\u0006d7i\u001c:fgV\t\u0001\n\u0005\u0002)\u0013&\u0011!*\u000b\u0002\u0004\u0013:$\u0018a\u0003;pi\u0006d7i\u001c:fg\u0002\na\u0001P5oSRtD\u0003\u0002(Q#J\u0003\"a\u0014\u0001\u000e\u0003qAQ!P\u0003A\u0002}BQaH\u0003A\u0002\rCQAR\u0003A\u0002!\u000bQ!\u00199q\u0013\u0012,\u0012!\u0016\t\u0003-nk\u0011a\u0016\u0006\u00031f\u000bA\u0001\\1oO*\t!,\u0001\u0003kCZ\f\u0017B\u0001/X\u0005\u0019\u0019FO]5oO\u00061\u0011\r\u001d9JI\u0002\nQ\u0002\\8dC2,e\u000e\u001a9pS:$X#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\u0004\u0013a\u0001:qG&\u0011QM\u0019\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u0003EawnY1m\u000b:$\u0007o\\5oi~#S-\u001d\u000b\u0003Q.\u0004\"\u0001K5\n\u0005)L#\u0001B+oSRDq\u0001\\\u0005\u0002\u0002\u0003\u0007\u0001-A\u0002yIE\na\u0002\\8dC2,e\u000e\u001a9pS:$\b%A\u0007vg\u0016\u00148\t\\1tgB\u000bG\u000f[\u000b\u0002aB\u0019\u0011/\u001f?\u000f\u0005I<hBA:w\u001b\u0005!(BA;?\u0003\u0019a$o\\8u}%\t!&\u0003\u0002yS\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005\r\u0019V-\u001d\u0006\u0003q&\u00022!`A\u0001\u001b\u0005q(BA@Z\u0003\rqW\r^\u0005\u0004\u0003\u0007q(aA+S\u0019\u0006qQo]3s\u00072\f7o\u001d)bi\"\u0004\u0013a\u00037jgR,g.\u001a:CkN,\"!a\u0003\u0011\u00079\ni!C\u0002\u0002\u0010y\u0011q\u0002T5wK2K7\u000f^3oKJ\u0014Uo]\u0001\rY&\u001cH/\u001a8fe\n+8\u000fI\u0001\u0010Y\u0006,hn\u00195fe\n\u000b7m[3oIV\u0011\u0011q\u0003\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u0011\u0002\u00111\fWO\\2iKJLA!!\t\u0002\u001c\tyA*Y;oG\",'OQ1dW\u0016tG-\u0001\tmCVt7\r[3s\u0005\u0006\u001c7.\u001a8eA\u0005\u0001r-\u001a;Vg\u0016\u00148\t\\1tgB\fG\u000f\u001b\u000b\u0004a\u0006%\u0002\"B\u001f\u0012\u0001\u0004y\u0014!B:uCJ$H#\u00015\u0002\tM$x\u000e]\u0001\re\u00164\u0018N^3PM\u001a,'o]\u0001\u0013I\u00164\u0017-\u001e7u!\u0006\u0014\u0018\r\u001c7fY&\u001cX\u000eF\u0001I\u0003!Y\u0017\u000e\u001c7UCN\\G#\u00035\u0002<\u0005\u0015\u0013qKA1\u0011\u001d\tiD\u0006a\u0001\u0003\u007f\ta\u0001^1tW&#\u0007c\u0001\u0015\u0002B%\u0019\u00111I\u0015\u0003\t1{gn\u001a\u0005\b\u0003\u000f2\u0002\u0019AA%\u0003))\u00070Z2vi>\u0014\u0018\n\u001a\t\u0005\u0003\u0017\n\u0019F\u0004\u0003\u0002N\u0005=\u0003CA:*\u0013\r\t\t&K\u0001\u0007!J,G-\u001a4\n\u0007q\u000b)FC\u0002\u0002R%Bq!!\u0017\u0017\u0001\u0004\tY&A\bj]R,'O];qiRC'/Z1e!\rA\u0013QL\u0005\u0004\u0003?J#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003G2\u0002\u0019AA%\u0003\u0019\u0011X-Y:p]\u0006a1\u000f^1ukN,\u0006\u000fZ1uKR9\u0001.!\u001b\u0002l\u0005%\u0005bBA\u001f/\u0001\u0007\u0011q\b\u0005\b\u0003[:\u0002\u0019AA8\u0003\u0015\u0019H/\u0019;f!\u0011\t\t(a!\u000f\t\u0005M\u0014q\u0010\b\u0005\u0003k\niH\u0004\u0003\u0002x\u0005mdbA:\u0002z%\tQ%\u0003\u0002$I%\u0011\u0011EI\u0005\u0004\u0003\u0003\u0003\u0013!\u0003+bg.\u001cF/\u0019;f\u0013\u0011\t))a\"\u0003\u0013Q\u000b7o[*uCR,'bAAAA!9\u00111R\fA\u0002\u00055\u0015AD:fe&\fG.\u001b>fI\u0012\u000bG/\u0019\t\u0005\u0003\u001f\u000b)*\u0004\u0002\u0002\u0012*\u0019\u00111S-\u0002\u00079Lw.\u0003\u0003\u0002\u0018\u0006E%A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006i\u0011\r\u001d9mS\u000e\fG/[8o\u0013\u0012$\"!!\u0013\u0002+5\f\u0007PT;n\u0007>t7-\u001e:sK:$H+Y:lgR\u0019\u0001*!)\t\u000f\u0005\r\u0016\u00041\u0001\u0002&\u0006\u0011!\u000f\u001d\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**\u0019\u00111\u0016\u0011\u0002\u0011I,7o\\;sG\u0016LA!a,\u0002*\ny!+Z:pkJ\u001cW\r\u0015:pM&dW\rF\u0002i\u0003gCq!!.\u001b\u0001\u0004\t9,\u0001\u0006gS:\fGn\u0015;bi\u0016\u0004B!!/\u0002@:!\u0011\u0011DA^\u0013\u0011\ti,a\u0007\u0002\u001dM\u0003\u0018M]6BaBD\u0015M\u001c3mK&!\u0011\u0011YAb\u0005\u0015\u0019F/\u0019;f\u0015\u0011\ti,a\u0007")
public class LocalSchedulerBackend
implements SchedulerBackend,
ExecutorBackend,
Logging {
    public final SparkConf org$apache$spark$scheduler$local$LocalSchedulerBackend$$conf;
    private final TaskSchedulerImpl scheduler;
    private final int totalCores;
    private final String appId;
    private RpcEndpointRef localEndpoint;
    private final Seq<URL> userClassPath;
    private final LiveListenerBus listenerBus;
    private final LauncherBackend launcherBackend;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private final String org$apache$spark$scheduler$SchedulerBackend$$appId;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public boolean isReady() {
        return SchedulerBackend.isReady$(this);
    }

    @Override
    public Option<String> applicationAttemptId() {
        return SchedulerBackend.applicationAttemptId$(this);
    }

    @Override
    public Option<Map<String, String>> getDriverLogUrls() {
        return SchedulerBackend.getDriverLogUrls$(this);
    }

    @Override
    public Option<Map<String, String>> getDriverAttributes() {
        return SchedulerBackend.getDriverAttributes$(this);
    }

    @Override
    public Seq<BlockManagerId> getShufflePushMergerLocations(int numPartitions, int resourceProfileId) {
        return SchedulerBackend.getShufflePushMergerLocations$(this, numPartitions, resourceProfileId);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String org$apache$spark$scheduler$SchedulerBackend$$appId() {
        return this.org$apache$spark$scheduler$SchedulerBackend$$appId;
    }

    @Override
    public final void org$apache$spark$scheduler$SchedulerBackend$_setter_$org$apache$spark$scheduler$SchedulerBackend$$appId_$eq(String x$1) {
        this.org$apache$spark$scheduler$SchedulerBackend$$appId = x$1;
    }

    public int totalCores() {
        return this.totalCores;
    }

    private String appId() {
        return this.appId;
    }

    private RpcEndpointRef localEndpoint() {
        return this.localEndpoint;
    }

    private void localEndpoint_$eq(RpcEndpointRef x$1) {
        this.localEndpoint = x$1;
    }

    private Seq<URL> userClassPath() {
        return this.userClassPath;
    }

    private LiveListenerBus listenerBus() {
        return this.listenerBus;
    }

    private LauncherBackend launcherBackend() {
        return this.launcherBackend;
    }

    public Seq<URL> getUserClasspath(SparkConf conf) {
        Option userClassPathStr = (Option)conf.get(package$.MODULE$.EXECUTOR_CLASS_PATH());
        return (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(userClassPathStr.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split(File.pathSeparator))).toSeq().flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2).toURI().toURL(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public void start() {
        RpcEnv rpcEnv = SparkEnv$.MODULE$.get().rpcEnv();
        LocalEndpoint executorEndpoint = new LocalEndpoint(rpcEnv, this.userClassPath(), this.scheduler, this, this.totalCores());
        this.localEndpoint_$eq(rpcEnv.setupEndpoint("LocalSchedulerBackendEndpoint", executorEndpoint));
        this.listenerBus().post(new SparkListenerExecutorAdded(System.currentTimeMillis(), executorEndpoint.localExecutorId(), new ExecutorInfo(executorEndpoint.localExecutorHostname(), this.totalCores(), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)Predef$.MODULE$.Map().empty())));
        this.launcherBackend().setAppId(this.appId());
        this.launcherBackend().setState(SparkAppHandle.State.RUNNING);
    }

    @Override
    public void stop() {
        this.org$apache$spark$scheduler$local$LocalSchedulerBackend$$stop(SparkAppHandle.State.FINISHED);
    }

    @Override
    public void reviveOffers() {
        this.localEndpoint().send((Object)ReviveOffers$.MODULE$);
    }

    @Override
    public int defaultParallelism() {
        return this.scheduler.conf().getInt("spark.default.parallelism", this.totalCores());
    }

    @Override
    public void killTask(long taskId, String executorId, boolean interruptThread, String reason) {
        this.localEndpoint().send(new KillTask(taskId, interruptThread, reason));
    }

    @Override
    public void statusUpdate(long taskId, Enumeration.Value state, ByteBuffer serializedData) {
        this.localEndpoint().send(new StatusUpdate(taskId, state, serializedData));
    }

    @Override
    public String applicationId() {
        return this.appId();
    }

    @Override
    public int maxNumConcurrentTasks(ResourceProfile rp) {
        int cpusPerTask = ResourceProfile$.MODULE$.getTaskCpusOrDefaultForProfile(rp, this.org$apache$spark$scheduler$local$LocalSchedulerBackend$$conf);
        return this.totalCores() / cpusPerTask;
    }

    public void org$apache$spark$scheduler$local$LocalSchedulerBackend$$stop(SparkAppHandle.State finalState) {
        this.localEndpoint().ask((Object)StopExecutor$.MODULE$, ClassTag$.MODULE$.Nothing());
        try {
            this.launcherBackend().setState(finalState);
        }
        finally {
            this.launcherBackend().close();
        }
    }

    public LocalSchedulerBackend(SparkConf conf, TaskSchedulerImpl scheduler, int totalCores) {
        this.org$apache$spark$scheduler$local$LocalSchedulerBackend$$conf = conf;
        this.scheduler = scheduler;
        this.totalCores = totalCores;
        SchedulerBackend.$init$(this);
        Logging.$init$(this);
        this.appId = new StringBuilder(6).append("local-").append(System.currentTimeMillis()).toString();
        this.localEndpoint = null;
        this.userClassPath = this.getUserClasspath(conf);
        this.listenerBus = scheduler.sc().listenerBus();
        this.launcherBackend = new LauncherBackend(this){
            private final /* synthetic */ LocalSchedulerBackend $outer;

            public SparkConf conf() {
                return this.$outer.org$apache$spark$scheduler$local$LocalSchedulerBackend$$conf;
            }

            public void onStopRequest() {
                this.$outer.org$apache$spark$scheduler$local$LocalSchedulerBackend$$stop(SparkAppHandle.State.KILLED);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.launcherBackend().connect();
    }
}

