/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;

public class FrameLibAppend {
    protected static final Log LOG = LogFactory.getLog((String)FrameLibAppend.class.getName());

    public static FrameBlock append(FrameBlock a, FrameBlock b, boolean cbind) {
        FrameBlock ret = cbind ? FrameLibAppend.appendCbind(a, b) : FrameLibAppend.appendRbind(a, b);
        return ret;
    }

    public static FrameBlock appendCbind(FrameBlock a, FrameBlock b) {
        int nRowB;
        int nRow = a.getNumRows();
        if (nRow != (nRowB = b.getNumRows())) {
            throw new DMLRuntimeException("Incompatible number of rows for cbind: " + nRowB + " expected: " + nRow);
        }
        if (a.getNumColumns() == 0) {
            return b;
        }
        if (b.getNumColumns() == 0) {
            return a;
        }
        Types.ValueType[] _schema = FrameLibAppend.addAll(a.getSchema(), b.getSchema());
        ColumnMetadata[] _colmeta = FrameLibAppend.addAll(a.getColumnMetadata(), b.getColumnMetadata());
        Array<?>[] _coldata = FrameLibAppend.addAll(a.getColumns(), b.getColumns());
        String[] _colnames = FrameLibAppend.addAll(a.getColumnNames(), b.getColumnNames());
        if (!Arrays.stream(_colnames).allMatch(new HashSet()::add)) {
            _colnames = null;
        }
        return new FrameBlock(_schema, _colnames, _colmeta, _coldata);
    }

    public static FrameBlock appendRbind(FrameBlock a, FrameBlock b) {
        int nColB;
        int nCol = a.getNumColumns();
        if (nCol != (nColB = b.getNumColumns())) {
            throw new DMLRuntimeException("Incompatible number of columns for rbind: " + nColB + " expected: " + nCol);
        }
        if (a.getNumRows() == 0) {
            return b;
        }
        if (b.getNumRows() == 0) {
            return a;
        }
        String[] retColNames = a.getColumnNames(false) != null ? (String[])a.getColumnNames().clone() : null;
        ColumnMetadata[] retColMeta = new ColumnMetadata[a.getNumColumns()];
        for (int j = 0; j < nCol; ++j) {
            retColMeta[j] = new ColumnMetadata();
        }
        Array[] retCols = new Array[a.getNumColumns()];
        Types.ValueType[] retSchema = new Types.ValueType[a.getNumColumns()];
        for (int j = 0; j < a.getNumColumns(); ++j) {
            retCols[j] = ArrayFactory.append(a.getColumn(j), b.getColumn(j));
            retSchema[j] = retCols[j].getValueType();
        }
        return new FrameBlock(retSchema, retColNames, retColMeta, retCols);
    }

    private static <T> T[] addAll(T[] a, T[] b) {
        return ArrayUtils.addAll((Object[])a, (Object[])b);
    }
}

