/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.IndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.util.IndexRange;

public final class FrameIndexingCPInstruction
extends IndexingCPInstruction {
    protected FrameIndexingCPInstruction(CPOperand in, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(in, rl, ru, cl, cu, out, opcode, istr);
    }

    protected FrameIndexingCPInstruction(CPOperand lhsInput, CPOperand rhsInput, CPOperand rl, CPOperand ru, CPOperand cl, CPOperand cu, CPOperand out, String opcode, String istr) {
        super(lhsInput, rhsInput, rl, ru, cl, cu, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        IndexRange ixrange = this.getIndexRange(ec);
        if (opcode.equalsIgnoreCase("rightIndex")) {
            FrameBlock in = ec.getFrameInput(this.input1.getName());
            FrameBlock out = in.slice(ixrange, new FrameBlock());
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), out);
        } else if (opcode.equalsIgnoreCase("leftIndex")) {
            FrameBlock lin = ec.getFrameInput(this.input1.getName());
            FrameBlock out = null;
            if (this.input2.getDataType() == Types.DataType.FRAME) {
                FrameBlock rin = ec.getFrameInput(this.input2.getName());
                out = lin.leftIndexingOperations(rin, ixrange, new FrameBlock());
                ec.releaseFrameInput(this.input2.getName());
            } else {
                if (!ixrange.isScalar()) {
                    throw new DMLRuntimeException("Invalid index range of scalar leftindexing: " + ixrange.toString() + ".");
                }
                ScalarObject scalar = ec.getScalarInput(this.input2);
                out = new FrameBlock(lin);
                out.set((int)ixrange.rowStart, (int)ixrange.colStart, scalar.getStringValue());
            }
            ec.releaseFrameInput(this.input1.getName());
            ec.setFrameOutput(this.output.getName(), out);
        } else {
            throw new DMLRuntimeException("Invalid opcode (" + opcode + ") encountered in FrameIndexingCPInstruction.");
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, this.input1, this.input2, this.input3, this.rowLower, this.rowUpper, this.colLower, this.colUpper)));
    }
}

