/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLException;
import org.apache.sysds.api.DMLOptions;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.api.jmlc.Connection;
import py4j.GatewayServer;
import py4j.GatewayServerListener;
import py4j.Py4JNetworkException;
import py4j.Py4JServerConnection;

public class PythonDMLScript {
    private static final Log LOG = LogFactory.getLog((String)PythonDMLScript.class.getName());
    private final Connection _connection = new Connection();

    public static void main(String[] args) throws Exception {
        DMLOptions dmlOptions = DMLOptions.parseCLArguments(args);
        DMLScript.loadConfiguration(dmlOptions.configFile);
        GatewayServer GwS = new GatewayServer((Object)new PythonDMLScript(), dmlOptions.pythonPort);
        GwS.addListener((GatewayServerListener)new DMLGateWayListener());
        try {
            GwS.start();
        }
        catch (Py4JNetworkException p4e) {
            LOG.info((Object)"failed startup", (Throwable)p4e);
            System.exit(-1);
        }
        catch (Exception e) {
            throw new DMLException("Failed startup and maintaining Python gateway", e);
        }
    }

    private PythonDMLScript() {
    }

    public Connection getConnection() {
        return this._connection;
    }

    protected static class DMLGateWayListener
    implements GatewayServerListener {
        private static final Log LOG = LogFactory.getLog((String)DMLGateWayListener.class.getName());

        protected DMLGateWayListener() {
        }

        public void connectionError(Exception e) {
            LOG.warn((Object)("Connection error: " + e.getMessage()));
            System.exit(1);
        }

        public void connectionStarted(Py4JServerConnection gatewayConnection) {
            LOG.debug((Object)("Connection Started: " + gatewayConnection.toString()));
        }

        public void connectionStopped(Py4JServerConnection gatewayConnection) {
            LOG.debug((Object)("Connection stopped: " + gatewayConnection.toString()));
        }

        public void serverError(Exception e) {
            LOG.error((Object)("Server Error " + e.getMessage()));
        }

        public void serverPostShutdown() {
            LOG.info((Object)"Shutdown done");
            System.exit(0);
        }

        public void serverPreShutdown() {
            LOG.info((Object)"Starting JVM shutdown");
        }

        public void serverStarted() {
            LOG.info((Object)"GatewayServer Started");
        }

        public void serverStopped() {
            LOG.info((Object)"GatewayServer Stopped");
            System.exit(0);
        }
    }
}

