/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.offset;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetEmpty;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetSingle;

public class OffsetTwo
extends AOffset {
    private static final long serialVersionUID = -3756723021239389269L;
    private final int first;
    private final int last;

    public OffsetTwo(int first, int last) {
        this.first = first;
        this.last = last;
        if (last <= first) {
            throw new DMLCompressionException("Invalid offsets last should be greater than first");
        }
    }

    @Override
    public AIterator getIterator() {
        return new IterateTwo();
    }

    @Override
    protected AIterator getIteratorFromIndexOff(int row, int dataIndex, int offIdx) {
        throw new NotImplementedException();
    }

    @Override
    public AOffsetIterator getOffsetIterator() {
        return new IterateOffsetTwo();
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9L;
    }

    @Override
    public int getSize() {
        return 2;
    }

    @Override
    public int getOffsetToFirst() {
        return this.first;
    }

    @Override
    public int getOffsetToLast() {
        return this.last;
    }

    @Override
    public long getInMemorySize() {
        return OffsetTwo.estimateInMemorySize();
    }

    public static long estimateInMemorySize() {
        return 24L;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(OffsetFactory.OFF_TYPE_SPECIALIZATIONS.TWO_OFFSET.ordinal());
        out.writeInt(this.first);
        out.writeInt(this.last);
    }

    public static OffsetTwo readFields(DataInput in) throws IOException {
        return new OffsetTwo(in.readInt(), in.readInt());
    }

    @Override
    public AOffset.OffsetSliceInfo slice(int l, int u) {
        if (l <= this.first) {
            if (u < this.first) {
                return new AOffset.OffsetSliceInfo(-1, -1, new OffsetEmpty());
            }
            if (u > this.last) {
                return new AOffset.OffsetSliceInfo(0, 2, this.moveIndex(l));
            }
            return new AOffset.OffsetSliceInfo(0, 1, new OffsetSingle(this.first - l));
        }
        if (l <= this.last && u > this.last) {
            return new AOffset.OffsetSliceInfo(1, 2, new OffsetSingle(this.last - l));
        }
        return new AOffset.OffsetSliceInfo(-1, -1, new OffsetEmpty());
    }

    @Override
    public AOffset moveIndex(int m) {
        return new OffsetTwo(this.first - m, this.last - m);
    }

    @Override
    public int getLength() {
        return 2;
    }

    private class IterateOffsetTwo
    extends AOffsetIterator {
        private IterateOffsetTwo() {
            super(OffsetTwo.this.first);
        }

        @Override
        public int next() {
            this.offset = OffsetTwo.this.last;
            return this.offset;
        }
    }

    private class IterateTwo
    extends AIterator {
        private IterateTwo() {
            super(OffsetTwo.this.first);
        }

        @Override
        public int next() {
            this.offset = OffsetTwo.this.last;
            return OffsetTwo.this.last;
        }

        @Override
        public int skipTo(int idx) {
            if (idx > OffsetTwo.this.first) {
                this.offset = OffsetTwo.this.last;
                return OffsetTwo.this.last;
            }
            return OffsetTwo.this.first;
        }

        @Override
        public IterateTwo clone() {
            IterateTwo ret = new IterateTwo();
            ret.offset = this.offset;
            return ret;
        }

        @Override
        public int getDataIndex() {
            return this.offset == OffsetTwo.this.first ? 0 : 1;
        }

        @Override
        public int getOffsetsIndex() {
            return this.offset == OffsetTwo.this.first ? 0 : 1;
        }
    }
}

