/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.FrameObject;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.caching.TensorObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.functionobjects.ParameterizedBuiltin;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BooleanObject;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.instructions.cp.ParamservBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObjectFactory;
import org.apache.sysds.runtime.instructions.cp.StringObject;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.SimpleOperator;
import org.apache.sysds.runtime.transform.decode.Decoder;
import org.apache.sysds.runtime.transform.decode.DecoderFactory;
import org.apache.sysds.runtime.transform.encode.EncoderFactory;
import org.apache.sysds.runtime.transform.encode.MultiColumnEncoder;
import org.apache.sysds.runtime.transform.meta.TfMetaUtils;
import org.apache.sysds.runtime.transform.tokenize.Tokenizer;
import org.apache.sysds.runtime.transform.tokenize.TokenizerFactory;
import org.apache.sysds.runtime.util.AutoDiff;
import org.apache.sysds.runtime.util.DataConverter;

public class ParameterizedBuiltinCPInstruction
extends ComputationCPInstruction {
    private static final Log LOG = LogFactory.getLog((String)ParameterizedBuiltinCPInstruction.class.getName());
    private static final int TOSTRING_MAXROWS = 100;
    private static final int TOSTRING_MAXCOLS = 100;
    private static final int TOSTRING_DECIMAL = 3;
    private static final boolean TOSTRING_SPARSE = false;
    private static final String TOSTRING_SEPARATOR = " ";
    private static final String TOSTRING_LINESEPARATOR = "\n";
    protected final LinkedHashMap<String, String> params;

    protected ParameterizedBuiltinCPInstruction(Operator op, LinkedHashMap<String, String> paramsMap, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.ParameterizedBuiltin, op, null, null, out, opcode, istr);
        this.params = paramsMap;
    }

    public HashMap<String, String> getParameterMap() {
        return this.params;
    }

    public String getParam(String key) {
        return this.getParameterMap().get(key);
    }

    public static LinkedHashMap<String, String> constructParameterMap(String[] params) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        for (int i = 1; i <= params.length - 2; ++i) {
            String[] parts = params[i].split("=");
            paramMap.put(parts[0], parts[1]);
        }
        return paramMap;
    }

    public static ParameterizedBuiltinCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        CPOperand out = new CPOperand(parts[parts.length - 1]);
        LinkedHashMap<String, String> paramsMap = ParameterizedBuiltinCPInstruction.constructParameterMap(parts);
        ParameterizedBuiltin func = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("invcdf")) {
            if (paramsMap.get("dist") == null) {
                throw new DMLRuntimeException("Invalid distribution: " + str);
            }
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode, paramsMap.get("dist"));
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("groupedagg")) {
            String fnStr = paramsMap.get("fn");
            if (fnStr == null) {
                throw new DMLRuntimeException("Function parameter is missing in groupedAggregate.");
            }
            if (fnStr.equalsIgnoreCase("centralmoment") && paramsMap.get("order") == null) {
                throw new DMLRuntimeException("Mandatory \"order\" must be specified when fn=\"centralmoment\" in groupedAggregate.");
            }
            Operator op = InstructionUtils.parseGroupedAggOperator(fnStr, paramsMap.get("order"));
            return new ParameterizedBuiltinCPInstruction(op, paramsMap, out, opcode, str);
        }
        if (opcode.equalsIgnoreCase("rmempty") || opcode.equalsIgnoreCase("replace") || opcode.equalsIgnoreCase("rexpand") || opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri")) {
            func = ParameterizedBuiltin.getParameterizedBuiltinFnObject(opcode);
            return new ParameterizedBuiltinCPInstruction(new SimpleOperator(func), paramsMap, out, opcode, str);
        }
        if (opcode.equals("transformapply") || opcode.equals("transformdecode") || opcode.equalsIgnoreCase("contains") || opcode.equals("transformcolmap") || opcode.equals("transformmeta") || opcode.equals("tokenize") || opcode.equals("toString") || opcode.equals("nvlist") || opcode.equals("autoDiff")) {
            return new ParameterizedBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        if ("paramserv".equals(opcode)) {
            return new ParamservBuiltinCPInstruction(null, paramsMap, out, opcode, str);
        }
        throw new DMLRuntimeException("Unknown opcode (" + opcode + ") for ParameterizedBuiltin Instruction.");
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        DoubleObject sores = null;
        if (opcode.equalsIgnoreCase("cdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("invcdf")) {
            SimpleOperator op = (SimpleOperator)this._optr;
            double result = op.fn.execute(this.params);
            sores = new DoubleObject(result);
            ec.setScalarOutput(this.output.getName(), sores);
        } else if (opcode.equalsIgnoreCase("autoDiff")) {
            ArrayList lineage = (ArrayList)ec.getListObject(this.params.get("lineage")).getData();
            MatrixObject mo = ec.getMatrixObject(this.params.get("output"));
            ListObject diffs = AutoDiff.getBackward(mo, lineage, ExecutionContextFactory.createContext());
            ec.setVariable(this.output.getName(), diffs);
        } else if (opcode.equalsIgnoreCase("groupedagg")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            MatrixBlock groups = ec.getMatrixInput(this.params.get("groups"));
            MatrixBlock weights = null;
            if (this.params.get("weights") != null) {
                weights = ec.getMatrixInput(this.params.get("weights"));
            }
            int ngroups = -1;
            if (this.params.get("ngroups") != null) {
                ngroups = (int)Double.parseDouble(this.params.get("ngroups"));
            }
            int k = Integer.parseInt(this.params.get("k"));
            MatrixBlock soresBlock = groups.groupedAggOperations(target, weights, new MatrixBlock(), ngroups, this._optr, k);
            ec.setMatrixOutput(this.output.getName(), soresBlock);
            weights = null;
            groups = null;
            target = null;
            ec.releaseMatrixInput(this.params.get("target"));
            ec.releaseMatrixInput(this.params.get("groups"));
            if (this.params.get("weights") != null) {
                ec.releaseMatrixInput(this.params.get("weights"));
            }
        } else if (opcode.equalsIgnoreCase("rmempty")) {
            String margin = this.params.get("margin");
            if (!margin.equals("rows") && !margin.equals("cols")) {
                throw new DMLRuntimeException("Unspupported margin identifier '" + margin + "'.");
            }
            if (ec.isFrameObject(this.params.get("target"))) {
                FrameBlock target = ec.getFrameInput(this.params.get("target"));
                MatrixBlock select = this.params.containsKey("select") ? ec.getMatrixInput(this.params.get("select")) : null;
                boolean emptyReturn = Boolean.parseBoolean(this.params.get("empty.return").toLowerCase());
                FrameBlock soresBlock = target.removeEmptyOperations(margin.equals("rows"), emptyReturn, select);
                ec.setFrameOutput(this.output.getName(), soresBlock);
                ec.releaseFrameInput(this.params.get("target"));
                if (this.params.containsKey("select")) {
                    ec.releaseMatrixInput(this.params.get("select"));
                }
            } else {
                MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
                MatrixBlock select = this.params.containsKey("select") ? ec.getMatrixInput(this.params.get("select")) : null;
                boolean emptyReturn = Boolean.parseBoolean(this.params.get("empty.return").toLowerCase());
                MatrixBlock ret = target.removeEmptyOperations(new MatrixBlock(), margin.equals("rows"), emptyReturn, select);
                if (target == ret) {
                    ec.setVariable(this.output.getName(), ec.getVariable(this.params.get("target")));
                } else {
                    ec.setMatrixOutput(this.output.getName(), ret);
                }
                ec.releaseMatrixInput(this.params.get("target"));
                if (this.params.containsKey("select")) {
                    ec.releaseMatrixInput(this.params.get("select"));
                }
            }
        } else if (opcode.equalsIgnoreCase("contains")) {
            String varName = this.params.get("target");
            MatrixBlock target = ec.getMatrixInput(varName);
            Data pattern = ec.getVariable(this.params.get("pattern"));
            if (pattern == null) {
                pattern = ScalarObjectFactory.createScalarObject(Types.ValueType.FP64, this.params.get("pattern"));
            }
            boolean ret = pattern.getDataType().isScalar() ? target.containsValue(((ScalarObject)pattern).getDoubleValue()) : target.containsVector((MatrixBlock)((MatrixObject)pattern).acquireRead(), true).size() > 0;
            ec.releaseMatrixInput(varName);
            if (!pattern.getDataType().isScalar()) {
                ec.releaseMatrixInput(this.params.get("pattern"));
            }
            ec.setScalarOutput(this.output.getName(), new BooleanObject(ret));
        } else if (opcode.equalsIgnoreCase("replace")) {
            if (ec.isFrameObject(this.params.get("target"))) {
                FrameBlock target = ec.getFrameInput(this.params.get("target"));
                String pattern = this.params.get("pattern");
                String replacement = this.params.get("replacement");
                FrameBlock ret = target.replaceOperations(pattern, replacement);
                ec.setFrameOutput(this.output.getName(), ret);
                ec.releaseFrameInput(this.params.get("target"));
            } else {
                double replacement;
                double pattern;
                MatrixObject targetObj = ec.getMatrixObject(this.params.get("target"));
                MatrixBlock target = (MatrixBlock)targetObj.acquireRead();
                MatrixBlock ret = target.replaceOperations(new MatrixBlock(), pattern = Double.parseDouble(this.params.get("pattern")), replacement = Double.parseDouble(this.params.get("replacement")));
                if (ret == target) {
                    ec.setVariable(this.output.getName(), targetObj);
                } else {
                    ec.setMatrixOutput(this.output.getName(), ret);
                }
                targetObj.release();
            }
        } else if (opcode.equals("lowertri") || opcode.equals("uppertri")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            boolean lower = opcode.equals("lowertri");
            boolean diag = Boolean.parseBoolean(this.params.get("diag"));
            boolean values = Boolean.parseBoolean(this.params.get("values"));
            MatrixBlock ret = target.extractTriangular(new MatrixBlock(), lower, diag, values);
            ec.setMatrixOutput(this.output.getName(), ret);
            ec.releaseMatrixInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("rexpand")) {
            MatrixBlock target = ec.getMatrixInput(this.params.get("target"));
            double maxVal = Double.parseDouble(this.params.get("max"));
            boolean dirVal = this.params.get("dir").equals("rows");
            boolean cast = Boolean.parseBoolean(this.params.get("cast"));
            boolean ignore = Boolean.parseBoolean(this.params.get("ignore"));
            int numThreads = Integer.parseInt(this.params.get("k"));
            MatrixBlock ret = target.rexpandOperations(new MatrixBlock(), maxVal, dirVal, cast, ignore, numThreads);
            ec.setMatrixOutput(this.output.getName(), ret);
            ec.releaseMatrixInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("tokenize")) {
            FrameBlock data = ec.getFrameInput(this.params.get("target"));
            Tokenizer tokenizer = TokenizerFactory.createTokenizer(this.getParameterMap().get("spec"), Integer.parseInt(this.getParameterMap().get("max_tokens")));
            FrameBlock fbout = tokenizer.tokenize(data, OptimizerUtils.getTokenizeNumThreads());
            ec.setFrameOutput(this.output.getName(), fbout);
            ec.releaseFrameInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("transformapply")) {
            FrameBlock data = ec.getFrameInput(this.params.get("target"));
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            MatrixBlock embeddings = this.params.get("embedding") != null ? ec.getMatrixInput(this.params.get("embedding")) : null;
            String[] colNames = data.getColumnNames();
            MultiColumnEncoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, data.getNumColumns(), meta, embeddings);
            MatrixBlock mbout = encoder.apply(data, OptimizerUtils.getTransformNumThreads());
            ec.setMatrixOutput(this.output.getName(), mbout);
            ec.releaseFrameInput(this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
            if (this.params.get("embedding") != null) {
                ec.releaseMatrixInput(this.params.get("embedding"));
            }
        } else if (opcode.equalsIgnoreCase("transformdecode")) {
            MatrixBlock data = ec.getMatrixInput(this.params.get("target"));
            FrameBlock meta = ec.getFrameInput(this.params.get("meta"));
            String[] colnames = meta.getColumnNames();
            Decoder decoder = DecoderFactory.createDecoder(this.getParameterMap().get("spec"), colnames, null, meta, data.getNumColumns());
            FrameBlock fbout = decoder.decode(data, new FrameBlock(decoder.getSchema()));
            fbout.setColumnNames(Arrays.copyOfRange(colnames, 0, fbout.getNumColumns()));
            ec.setFrameOutput(this.output.getName(), fbout);
            ec.releaseMatrixInput(this.params.get("target"));
            ec.releaseFrameInput(this.params.get("meta"));
        } else if (opcode.equalsIgnoreCase("transformcolmap")) {
            FrameBlock meta = ec.getFrameInput(this.params.get("target"));
            String[] colNames = meta.getColumnNames();
            MultiColumnEncoder encoder = EncoderFactory.createEncoder(this.params.get("spec"), colNames, meta.getNumColumns(), null, null);
            MatrixBlock mbout = encoder.getColMapping(meta);
            ec.setMatrixOutput(this.output.getName(), mbout);
            ec.releaseFrameInput(this.params.get("target"));
        } else if (opcode.equalsIgnoreCase("transformmeta")) {
            String spec = this.getParameterMap().get("spec");
            String path = this.getParameterMap().get("transformPath");
            String delim = this.getParameterMap().getOrDefault("sep", ",");
            FrameBlock meta = null;
            try {
                meta = TfMetaUtils.readTransformMetaDataFromFile(spec, path, delim);
            }
            catch (Exception ex) {
                throw new DMLRuntimeException(ex);
            }
            ec.setFrameOutput(this.output.getName(), meta);
        } else if (opcode.equalsIgnoreCase("toString")) {
            int rows = this.getParam("rows") != null ? Integer.parseInt(this.getParam("rows")) : 100;
            int cols = this.getParam("cols") != null ? Integer.parseInt(this.getParam("cols")) : 100;
            int decimal = this.getParam("decimal") != null ? Integer.parseInt(this.getParam("decimal")) : 3;
            boolean sparse = this.getParam("sparse") != null ? Boolean.parseBoolean(this.getParam("sparse")) : false;
            String separator = this.getParam("sep") != null ? this.getParam("sep") : TOSTRING_SEPARATOR;
            String lineSeparator = this.getParam("linesep") != null ? this.getParam("linesep") : TOSTRING_LINESEPARATOR;
            String out = null;
            Data cacheData = ec.getVariable(this.getParam("target"));
            if (cacheData instanceof MatrixObject) {
                MatrixBlock matrix = (MatrixBlock)((MatrixObject)cacheData).acquireRead();
                this.warnOnTrunction(matrix, rows, cols);
                out = DataConverter.toString(matrix, sparse, separator, lineSeparator, rows, cols, decimal);
            } else if (cacheData instanceof TensorObject) {
                TensorBlock tensor = (TensorBlock)((TensorObject)cacheData).acquireRead();
                this.warnOnTrunction(tensor, rows, cols);
                out = DataConverter.toString(tensor, sparse, separator, lineSeparator, "[", "]", rows, cols, decimal);
            } else if (cacheData instanceof FrameObject) {
                FrameBlock frame = (FrameBlock)((FrameObject)cacheData).acquireRead();
                this.warnOnTrunction(frame, rows, cols);
                out = DataConverter.toString(frame, sparse, separator, lineSeparator, rows, cols, decimal);
            } else if (cacheData instanceof ListObject) {
                out = DataConverter.toString((ListObject)cacheData, rows, cols, sparse, separator, lineSeparator, rows, cols, decimal);
            } else {
                throw new DMLRuntimeException("toString only converts matrix, tensors, lists or frames to string: " + cacheData.getClass().getSimpleName());
            }
            if (!(cacheData instanceof ListObject)) {
                ec.releaseCacheableData(this.getParam("target"));
            }
            ec.setScalarOutput(this.output.getName(), new StringObject(out));
        } else if (opcode.equals("nvlist")) {
            List<Data> data = this.params.values().stream().map(d -> ec.containsVariable((String)d) ? ec.getVariable((String)d) : ScalarObjectFactory.createScalarObject(d)).collect(Collectors.toList());
            ArrayList<String> names = new ArrayList<String>(this.params.keySet());
            ListObject list = null;
            if (DMLScript.LINEAGE) {
                CPOperand[] listOperands = (CPOperand[])names.stream().map(n -> ec.containsVariable(this.params.get(n)) ? new CPOperand((String)n, ec.getVariable(this.params.get(n))) : this.getStringLiteral((String)n)).toArray(CPOperand[]::new);
                LineageItem[] liList = LineageItemUtils.getLineage(ec, listOperands);
                list = new ListObject(data, names, Arrays.asList(liList));
            } else {
                list = new ListObject(data, names);
            }
            list.deriveAndSetStatusFromData();
            ec.setVariable(this.output.getName(), list);
        } else {
            throw new DMLRuntimeException("Unknown opcode : " + opcode);
        }
    }

    private void warnOnTrunction(CacheBlock<?> data, int rows, int cols) {
        if (this.getParam("rows") == null && data.getNumRows() > rows || this.getParam("cols") == null && data.getNumColumns() > cols) {
            LOG.warn((Object)("Truncating " + data.getClass().getSimpleName() + " of size " + data.getNumRows() + "x" + data.getNumColumns() + " to " + rows + "x" + cols + ". Use toString(X, rows=..., cols=...) if necessary."));
        }
    }

    private void warnOnTrunction(TensorBlock data, int rows, int cols) {
        if (this.getParam("rows") == null && data.getDim(0) > rows || this.getParam("cols") == null && data.getDim(1) > cols) {
            StringBuilder sb = new StringBuilder();
            IntStream.range(0, data.getNumDims()).forEach(i -> {
                if (i == data.getNumDims() - 1) {
                    sb.append(data.getDim(i));
                } else {
                    sb.append(data.getDim(i)).append("x");
                }
            });
            LOG.warn((Object)("Truncating " + data.getClass().getSimpleName() + " of size " + sb.toString() + " to " + rows + "x" + cols + ". Use toString(X, rows=..., cols=...) if necessary."));
        }
    }

    @Override
    public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
        String opcode = this.getOpcode();
        if (opcode.equalsIgnoreCase("contains")) {
            CPOperand target = this.getTargetOperand();
            CPOperand pattern = this.getFP64Literal("pattern");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, pattern)));
        }
        if (opcode.equalsIgnoreCase("groupedagg")) {
            CPOperand target = this.getTargetOperand();
            CPOperand groups = new CPOperand(this.params.get("groups"), Types.ValueType.FP64, Types.DataType.MATRIX);
            String wt = this.params.containsKey("weights") ? this.params.get("weights") : String.valueOf(-1);
            CPOperand weights = new CPOperand(wt, Types.ValueType.FP64, Types.DataType.MATRIX);
            CPOperand fn = this.getStringLiteral("fn");
            String ng = this.params.containsKey("ngroups") ? this.params.get("ngroups") : String.valueOf(-1);
            CPOperand ngroups = new CPOperand(ng, Types.ValueType.INT64, Types.DataType.SCALAR, true);
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, groups, weights, fn, ngroups)));
        }
        if (opcode.equalsIgnoreCase("rmempty")) {
            CPOperand target = this.getTargetOperand();
            CPOperand margin = this.getStringLiteral("margin");
            String sl = this.params.containsKey("select") ? this.params.get("select") : String.valueOf(-1);
            CPOperand select = new CPOperand(sl, Types.ValueType.FP64, Types.DataType.MATRIX);
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, margin, select)));
        }
        if (opcode.equalsIgnoreCase("replace")) {
            CPOperand target = this.getTargetOperand();
            CPOperand pattern = this.getFP64Literal("pattern");
            CPOperand replace = this.getFP64Literal("replacement");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, pattern, replace)));
        }
        if (opcode.equalsIgnoreCase("rexpand")) {
            CPOperand target = this.getTargetOperand();
            CPOperand max = this.getFP64Literal("max");
            CPOperand dir = this.getStringLiteral("dir");
            CPOperand cast = this.getBoolLiteral("cast");
            CPOperand ignore = this.getBoolLiteral("ignore");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, max, dir, cast, ignore)));
        }
        if (opcode.equalsIgnoreCase("lowertri") || opcode.equalsIgnoreCase("uppertri")) {
            CPOperand target = this.getTargetOperand();
            CPOperand lower = this.getBoolLiteral("lowertri");
            CPOperand diag = this.getBoolLiteral("diag");
            CPOperand values = this.getBoolLiteral("values");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, lower, diag, values)));
        }
        if (opcode.equalsIgnoreCase("transformdecode") || opcode.equalsIgnoreCase("transformapply")) {
            CPOperand target = new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.FRAME);
            CPOperand meta = this.getLiteral("meta", Types.ValueType.UNKNOWN, Types.DataType.FRAME);
            CPOperand spec = this.getStringLiteral("spec");
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, target, meta, spec)));
        }
        if (opcode.equalsIgnoreCase("nvlist") || opcode.equalsIgnoreCase("autoDiff")) {
            ArrayList<String> names = new ArrayList<String>(this.params.keySet());
            CPOperand[] listOperands = (CPOperand[])names.stream().map(n -> ec.containsVariable(this.params.get(n)) ? new CPOperand((String)n, ec.getVariable(this.params.get(n))) : this.getStringLiteral((String)n)).toArray(CPOperand[]::new);
            return Pair.of((Object)this.output.getName(), (Object)new LineageItem(this.getOpcode(), LineageItemUtils.getLineage(ec, listOperands)));
        }
        throw new DMLRuntimeException("Unsupported lineage tracing for: " + opcode);
    }

    public CacheableData<?> getTarget(ExecutionContext ec) {
        return ec.getCacheableData(this.params.get("target"));
    }

    private CPOperand getTargetOperand() {
        return new CPOperand(this.params.get("target"), Types.ValueType.FP64, Types.DataType.MATRIX);
    }

    private CPOperand getFP64Literal(String name) {
        return this.getLiteral(name, Types.ValueType.FP64);
    }

    private CPOperand getStringLiteral(String name) {
        return this.getLiteral(name, Types.ValueType.STRING);
    }

    private CPOperand getBoolLiteral(String name) {
        return this.getLiteral(name, Types.ValueType.BOOLEAN);
    }

    private CPOperand getLiteral(String name, Types.ValueType vt) {
        return new CPOperand(this.params.get(name), vt, Types.DataType.SCALAR, true);
    }

    private CPOperand getLiteral(String name, Types.ValueType vt, Types.DataType dt) {
        return new CPOperand(this.params.get(name), vt, dt);
    }
}

