/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.List;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ResultMergeMatrix
extends ResultMerge<MatrixObject> {
    private static final long serialVersionUID = 5319002218804570071L;

    public ResultMergeMatrix() {
    }

    public ResultMergeMatrix(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super((CacheableData)out, (CacheableData[])in, outputFilename, accum);
    }

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly) {
        this.mergeWithoutComp(out, in, appendOnly, false);
    }

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly, boolean par) {
        if (this._isAccum) {
            out.binaryOperationsInPlace(PLUS, in);
        } else {
            MatrixBlock out2 = out.merge(in, appendOnly, par);
            if (out2 != out) {
                throw new DMLRuntimeException("Failed merge need to allow returned MatrixBlock to be used");
            }
        }
    }

    protected void mergeWithComp(MatrixBlock out, MatrixBlock in, DenseBlock compare) {
        int rows = in.getNumRows();
        int cols = in.getNumColumns();
        if (in.isEmptyBlock(false)) {
            if (this._isAccum) {
                return;
            }
            this.mergeWithCompEmpty(out, rows, cols, compare);
        } else if (in.isInSparseFormat() && this._isAccum) {
            this.mergeSparseAccumulative(out, in, rows, cols, compare);
        } else if (in.isInSparseFormat()) {
            this.mergeSparse(out, in, rows, cols, compare);
        } else {
            this.mergeGeneric(out, in, rows, cols, compare);
        }
    }

    private void mergeWithCompEmpty(MatrixBlock out, int m, int n, DenseBlock compare) {
        for (int i = 0; i < m; ++i) {
            this.mergeWithCompEmptyRow(out, m, n, compare, i);
        }
    }

    private void mergeWithCompEmptyRow(MatrixBlock out, int m, int n, DenseBlock compare, int i) {
        for (int j = 0; j < n; ++j) {
            double valOld = compare.get(i, j);
            if (Util.eq(0.0, valOld)) continue;
            out.quickSetValue(i, j, 0.0);
        }
    }

    private void mergeSparseAccumulative(MatrixBlock out, MatrixBlock in, int m, int n, DenseBlock compare) {
        SparseBlock a = in.getSparseBlock();
        for (int i = 0; i < m; ++i) {
            if (a.isEmpty(i)) continue;
            int apos = a.pos(i);
            int alen = a.size(i) + apos;
            int[] aix = a.indexes(i);
            double[] aval = a.values(i);
            this.mergeSparseRowAccumulative(out, apos, alen, aix, aval, compare, n, i);
        }
    }

    private void mergeSparseRowAccumulative(MatrixBlock out, int apos, int alen, int[] aix, double[] aval, DenseBlock compare, int n, int i) {
        while (apos < alen) {
            double valNew = aval[apos];
            double valOld = compare.get(i, aix[apos]);
            if (!Util.eq(valNew, valOld)) {
                double value = out.quickGetValue(i, aix[apos]) + (valNew - valOld);
                out.quickSetValue(i, aix[apos], value);
            }
            ++apos;
        }
    }

    private void mergeSparse(MatrixBlock out, MatrixBlock in, int m, int n, DenseBlock compare) {
        SparseBlock a = in.getSparseBlock();
        for (int i = 0; i < m; ++i) {
            if (a.isEmpty(i)) {
                this.mergeWithCompEmptyRow(out, m, n, compare, i);
                continue;
            }
            int apos = a.pos(i);
            int alen = a.size(i) + apos;
            int[] aix = a.indexes(i);
            double[] aval = a.values(i);
            this.mergeSparseRow(out, apos, alen, aix, aval, compare, n, i);
        }
    }

    private void mergeSparseRow(MatrixBlock out, int apos, int alen, int[] aix, double[] aval, DenseBlock compare, int n, int i) {
        int j;
        for (j = 0; j < n && apos < alen; ++j) {
            double valNew;
            boolean aposValid = aix[apos] == j;
            double valOld = compare.get(i, j);
            double d = valNew = aix[apos] == j ? aval[apos] : 0.0;
            if (!Util.eq(valNew, valOld)) {
                double value = !this._isAccum ? valNew : out.quickGetValue(i, j) + (valNew - valOld);
                out.quickSetValue(i, j, value);
            }
            if (!aposValid) continue;
            ++apos;
        }
        while (j < n) {
            double valOld = compare.get(i, j);
            if (valOld != 0.0) {
                double value = out.quickGetValue(i, j) - valOld;
                out.quickSetValue(i, j, value);
            }
            ++j;
        }
    }

    private void mergeGeneric(MatrixBlock out, MatrixBlock in, int m, int n, DenseBlock compare) {
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                double valOld = compare.get(i, j);
                double valNew = in.quickGetValue(i, j);
                if (Util.eq(valNew, valOld)) continue;
                double value = !this._isAccum ? valNew : out.quickGetValue(i, j) + (valNew - valOld);
                out.quickSetValue(i, j, value);
            }
        }
    }

    protected long computeNonZeros(MatrixObject out, List<MatrixObject> in) {
        long outNNZ = out.getDataCharacteristics().getNonZeros();
        return outNNZ - (long)in.size() * outNNZ + in.stream().mapToLong(m -> m.getDataCharacteristics().getNonZeros()).sum();
    }
}

