/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.recovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.SummaryEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryService.class);
    protected final AppContext appContext;
    public static final String RECOVERY_FATAL_OCCURRED_DIR = "RecoveryFatalErrorOccurred";
    @VisibleForTesting
    public static final String TEZ_TEST_RECOVERY_DRAIN_EVENTS_WHEN_STOPPED = "tez.test.recovery.drain_event";
    @VisibleForTesting
    public static final boolean TEZ_TEST_RECOVERY_DRAIN_EVENTS_WHEN_STOPPED_DEFAULT = true;
    @VisibleForTesting
    LinkedBlockingQueue<DAGHistoryEvent> eventQueue = new LinkedBlockingQueue();
    private Set<TezDAGID> completedDAGs = new HashSet<TezDAGID>();
    private Set<TezDAGID> skippedDAGs = new HashSet<TezDAGID>();
    public Thread eventHandlingThread;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private int eventCounter = 0;
    private int eventsProcessed = 0;
    private final Object lock = new Object();
    private FileSystem recoveryDirFS;
    Path recoveryPath;
    @VisibleForTesting
    public Map<TezDAGID, RecoveryStream> outputStreamMap = new HashMap<TezDAGID, RecoveryStream>();
    private int bufferSize;
    @VisibleForTesting
    public FSDataOutputStream summaryStream;
    private int unflushedEventsCount = 0;
    private long lastFlushTime = -1L;
    private int maxUnflushedEvents;
    private int flushInterval;
    private AtomicBoolean recoveryFatalErrorOccurred = new AtomicBoolean(false);
    private boolean drainEventsFlag;
    private volatile boolean drained = true;
    private Object waitForDrained = new Object();

    public RecoveryService(AppContext appContext) {
        super(RecoveryService.class.getName());
        this.appContext = appContext;
    }

    public void serviceInit(Configuration conf) throws Exception {
        this.recoveryPath = this.appContext.getCurrentRecoveryDir();
        this.recoveryDirFS = FileSystem.get((URI)this.recoveryPath.toUri(), (Configuration)conf);
        this.bufferSize = conf.getInt("tez.dag.recovery.io.buffer.size", 8192);
        this.flushInterval = conf.getInt("tez.dag.recovery.flush.interval.secs", 30);
        this.maxUnflushedEvents = conf.getInt("tez.dag.recovery.max.unflushed.events", 100);
        this.drainEventsFlag = conf.getBoolean(TEZ_TEST_RECOVERY_DRAIN_EVENTS_WHEN_STOPPED, true);
        LOG.info("RecoveryService initialized with recoveryPath=" + this.recoveryPath + ", bufferSize(bytes)=" + this.bufferSize + ", flushInterval(s)=" + this.flushInterval + ", maxUnflushedEvents=" + this.maxUnflushedEvents);
    }

    public void serviceStart() {
        this.lastFlushTime = this.appContext.getClock().getTime();
        this.eventHandlingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TezUtilsInternal.setHadoopCallerContext((HadoopShim)RecoveryService.this.appContext.getHadoopShim(), (ApplicationId)RecoveryService.this.appContext.getApplicationID());
                while (!RecoveryService.this.stopped.get() && !Thread.currentThread().isInterrupted()) {
                    DAGHistoryEvent event;
                    Object object;
                    RecoveryService.this.drained = RecoveryService.this.eventQueue.isEmpty();
                    if (RecoveryService.this.getServiceState() == Service.STATE.STOPPED) {
                        object = RecoveryService.this.waitForDrained;
                        synchronized (object) {
                            if (RecoveryService.this.drained) {
                                RecoveryService.this.waitForDrained.notify();
                            }
                        }
                    }
                    if (RecoveryService.this.recoveryFatalErrorOccurred.get()) {
                        LOG.error("Recovery failure occurred. Stopping recovery thread. Current eventQueueSize=" + RecoveryService.this.eventQueue.size());
                        RecoveryService.this.eventQueue.clear();
                        return;
                    }
                    if (RecoveryService.this.eventCounter != 0 && RecoveryService.this.eventCounter % 1000 == 0) {
                        LOG.info("Event queue stats, eventsProcessedSinceLastUpdate=" + RecoveryService.this.eventsProcessed + ", eventQueueSize=" + RecoveryService.this.eventQueue.size());
                        RecoveryService.this.eventCounter = 0;
                        RecoveryService.this.eventsProcessed = 0;
                    } else {
                        ++RecoveryService.this.eventCounter;
                    }
                    try {
                        event = RecoveryService.this.eventQueue.take();
                    }
                    catch (InterruptedException e) {
                        LOG.info("EventQueue take interrupted. Returning");
                        return;
                    }
                    object = RecoveryService.this.lock;
                    synchronized (object) {
                        try {
                            ++RecoveryService.this.eventsProcessed;
                            RecoveryService.this.handleRecoveryEvent(event);
                        }
                        catch (Exception e) {
                            LOG.warn("Error handling recovery event", (Throwable)e);
                        }
                    }
                }
            }
        }, "RecoveryEventHandlingThread");
        this.eventHandlingThread.start();
        this.started.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        Object object;
        LOG.info("Stopping RecoveryService");
        if (this.drainEventsFlag) {
            LOG.info("Handle the remaining events in queue, queue size=" + this.eventQueue.size());
            object = this.waitForDrained;
            synchronized (object) {
                while (!this.drained && this.eventHandlingThread.isAlive()) {
                    this.waitForDrained.wait(1000L);
                    LOG.info("Waiting for RecoveryEventHandlingThread to drain.");
                }
            }
        }
        this.stopped.set(true);
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
            try {
                this.eventHandlingThread.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupted Exception while stopping", (Throwable)ie);
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.summaryStream != null) {
                try {
                    LOG.info("Closing Summary Stream");
                    this.summaryStream.hflush();
                    this.summaryStream.close();
                }
                catch (IOException ioe) {
                    if (!this.recoveryDirFS.exists(this.recoveryPath)) {
                        LOG.warn("Ignoring error while closing summary stream. The recovery directory at {} has already been deleted externally", (Object)this.recoveryPath);
                    }
                    LOG.warn("Error when closing summary stream", (Throwable)ioe);
                }
            }
            for (Map.Entry<TezDAGID, RecoveryStream> entry : this.outputStreamMap.entrySet()) {
                try {
                    LOG.info("Closing Output Stream for DAG " + entry.getKey());
                    entry.getValue().close();
                }
                catch (IOException ioe) {
                    if (!this.recoveryDirFS.exists(this.recoveryPath)) {
                        LOG.warn("Ignoring error while closing output stream. The recovery directory at {} has already been deleted externally", (Object)this.recoveryPath);
                        break;
                    }
                    LOG.warn("Error when closing output stream", (Throwable)ioe);
                }
            }
        }
    }

    private void addToEventQueue(DAGHistoryEvent event) {
        this.drained = false;
        this.eventQueue.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(DAGHistoryEvent event) throws IOException {
        DAGSubmittedEvent dagSubmittedEvent;
        String dagName;
        if (this.stopped.get()) {
            LOG.warn("Igoring event as service stopped, eventType" + (Object)((Object)event.getHistoryEvent().getEventType()));
            return;
        }
        HistoryEventType eventType = event.getHistoryEvent().getEventType();
        if (this.recoveryFatalErrorOccurred.get()) {
            return;
        }
        if (!this.started.get()) {
            LOG.warn("Adding event of type " + (Object)((Object)eventType) + " to queue as service not started");
            this.addToEventQueue(event);
            return;
        }
        TezDAGID dagId = event.getDAGID();
        if (eventType.equals((Object)HistoryEventType.DAG_SUBMITTED) && (dagName = (dagSubmittedEvent = (DAGSubmittedEvent)event.getHistoryEvent()).getDAGName()) != null && dagName.startsWith("TezPreWarmDAG")) {
            this.skippedDAGs.add(dagId);
            return;
        }
        if (dagId == null || this.skippedDAGs.contains(dagId)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping event for DAG, eventType=" + (Object)((Object)eventType) + ", dagId=" + (dagId == null ? "null" : dagId.toString()) + ", isSkippedDAG=" + (dagId == null ? "null" : Boolean.valueOf(this.skippedDAGs.contains(dagId))));
            }
            return;
        }
        if (event.getHistoryEvent() instanceof SummaryEvent) {
            Object object = this.lock;
            synchronized (object) {
                block22: {
                    if (this.stopped.get()) {
                        LOG.warn("Ignoring event as service stopped, eventType" + (Object)((Object)event.getHistoryEvent().getEventType()));
                        return;
                    }
                    try {
                        SummaryEvent summaryEvent = (SummaryEvent)((Object)event.getHistoryEvent());
                        this.handleSummaryEvent(dagId, eventType, summaryEvent);
                        if (summaryEvent.writeToRecoveryImmediately()) {
                            this.handleRecoveryEvent(event);
                            if (this.outputStreamMap.containsKey(event.getDAGID())) {
                                this.doFlush(this.outputStreamMap.get(event.getDAGID()), this.appContext.getClock().getTime());
                            }
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Queueing Non-immediate Summary/Recovery event of type" + eventType.name());
                            }
                            this.addToEventQueue(event);
                        }
                        if (eventType.equals((Object)HistoryEventType.DAG_FINISHED)) {
                            LOG.info("DAG completed, dagId=" + event.getDAGID() + ", queueSize=" + this.eventQueue.size());
                            this.completedDAGs.add(dagId);
                            if (this.outputStreamMap.containsKey(dagId)) {
                                try {
                                    this.outputStreamMap.get(dagId).close();
                                    this.outputStreamMap.remove(dagId);
                                }
                                catch (IOException ioe) {
                                    LOG.warn("Error when trying to flush/close recovery file for dag, dagId=" + event.getDAGID());
                                }
                            }
                        }
                    }
                    catch (IOException ioe) {
                        LOG.error("Error handling summary event, eventType=" + (Object)((Object)event.getHistoryEvent().getEventType()), (Throwable)ioe);
                        this.createFatalErrorFlagDir();
                        if (!eventType.equals((Object)HistoryEventType.DAG_SUBMITTED)) break block22;
                        throw ioe;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queueing Non-Summary Recovery event of type " + eventType.name());
        }
        this.addToEventQueue(event);
    }

    private void createFatalErrorFlagDir() throws IOException {
        Path fatalErrorDir = new Path(this.recoveryPath, RECOVERY_FATAL_OCCURRED_DIR);
        try {
            LOG.error("Adding a flag to ensure next AM attempt does not start up, flagFile=" + fatalErrorDir.toString());
            this.recoveryFatalErrorOccurred.set(true);
            this.recoveryDirFS.mkdirs(fatalErrorDir);
            if (!this.recoveryDirFS.exists(fatalErrorDir)) {
                throw new IOException("Failed to create fatal error flag dir " + fatalErrorDir.toString());
            }
            LOG.error("Recovery failure occurred. Skipping all events");
        }
        catch (IOException e) {
            LOG.error("Failed to create fatal error flag dir " + fatalErrorDir.toString(), (Throwable)e);
        }
    }

    protected void handleSummaryEvent(TezDAGID dagID, HistoryEventType eventType, SummaryEvent summaryEvent) throws IOException {
        LOG.debug("Handling summary event, dagID={}, eventType={}", (Object)dagID, (Object)eventType);
        if (this.summaryStream == null) {
            Path summaryPath = TezCommonUtils.getSummaryRecoveryPath((Path)this.recoveryPath);
            if (LOG.isDebugEnabled()) {
                LOG.debug("AppId :" + this.appContext.getApplicationID() + " summaryPath " + summaryPath);
            }
            try {
                this.summaryStream = this.recoveryDirFS.create(summaryPath, false, this.bufferSize);
            }
            catch (IOException e) {
                LOG.error("Error handling summary event, eventType=" + (Object)((Object)eventType), (Throwable)e);
                this.createFatalErrorFlagDir();
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing recovery event to summary stream, dagId=" + dagID + ", eventType=" + (Object)((Object)eventType));
        }
        summaryEvent.toSummaryProtoStream((OutputStream)this.summaryStream);
        this.summaryStream.hflush();
    }

    @VisibleForTesting
    protected void handleRecoveryEvent(DAGHistoryEvent event) throws IOException {
        TezDAGID dagID;
        HistoryEventType eventType = event.getHistoryEvent().getEventType();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling recovery event of type " + (Object)((Object)event.getHistoryEvent().getEventType()));
        }
        if (this.completedDAGs.contains(dagID = event.getDAGID())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping Recovery Event as DAG completed, dagId=" + dagID + ", completed=" + this.completedDAGs.contains(dagID) + ", skipped=" + this.skippedDAGs.contains(dagID) + ", eventType=" + (Object)((Object)eventType));
            }
            return;
        }
        RecoveryStream recoveryStream = this.outputStreamMap.get(dagID);
        if (recoveryStream == null) {
            Path dagFilePath = TezCommonUtils.getDAGRecoveryPath((Path)this.recoveryPath, (String)dagID.toString());
            try {
                FSDataOutputStream outputStream = this.recoveryDirFS.create(dagFilePath, false, this.bufferSize);
                LOG.debug("Opened DAG recovery file in create mode, filePath={}", (Object)dagFilePath);
                recoveryStream = new RecoveryStream(outputStream);
            }
            catch (IOException ioe) {
                LOG.error("Error handling history event, eventType=" + (Object)((Object)eventType), (Throwable)ioe);
                this.createFatalErrorFlagDir();
                return;
            }
            this.outputStreamMap.put(dagID, recoveryStream);
        }
        LOG.debug("Writing recovery event to output stream, dagId={}, eventType={}", (Object)dagID, (Object)eventType);
        ++this.unflushedEventsCount;
        recoveryStream.codedOutputStream.writeFixed32NoTag(event.getHistoryEvent().getEventType().ordinal());
        event.getHistoryEvent().toProtoStream(recoveryStream.codedOutputStream);
        if (!EnumSet.of(HistoryEventType.DAG_SUBMITTED, HistoryEventType.DAG_FINISHED).contains((Object)eventType)) {
            this.maybeFlush(recoveryStream);
        }
    }

    private void maybeFlush(RecoveryStream recoveryStream) throws IOException {
        long currentTime = this.appContext.getClock().getTime();
        boolean doFlush = false;
        if (this.maxUnflushedEvents >= 0 && this.unflushedEventsCount >= this.maxUnflushedEvents) {
            LOG.debug("Max unflushed events count reached. Flushing recovery data, unflushedEventsCount={}, maxUnflushedEvents={}", (Object)this.unflushedEventsCount, (Object)this.maxUnflushedEvents);
            doFlush = true;
        } else if (this.flushInterval >= 0 && currentTime - this.lastFlushTime >= (long)(this.flushInterval * 1000)) {
            LOG.debug("Flush interval time period elapsed. Flushing recovery data, lastTimeSinceFLush=" + this.lastFlushTime + ", timeSinceLastFlush=" + (currentTime - this.lastFlushTime));
            doFlush = true;
        }
        if (!doFlush) {
            return;
        }
        this.doFlush(recoveryStream, currentTime);
    }

    private void doFlush(RecoveryStream recoveryStream, long currentTime) throws IOException {
        recoveryStream.flush();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing output stream, lastTimeSinceFLush=" + this.lastFlushTime + ", timeSinceLastFlush=" + (currentTime - this.lastFlushTime) + ", unflushedEventsCount=" + this.unflushedEventsCount + ", maxUnflushedEvents=" + this.maxUnflushedEvents);
        }
        this.unflushedEventsCount = 0;
        this.lastFlushTime = currentTime;
    }

    public boolean hasRecoveryFailed() {
        return this.recoveryFatalErrorOccurred.get();
    }

    public void await() {
        while (!this.drained) {
            Thread.yield();
        }
    }

    public void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    @VisibleForTesting
    public static class RecoveryStream {
        private final FSDataOutputStream outputStream;
        private final CodedOutputStream codedOutputStream;

        RecoveryStream(FSDataOutputStream outputStream) {
            this.outputStream = outputStream;
            this.codedOutputStream = CodedOutputStream.newInstance((OutputStream)outputStream);
        }

        public void write(byte[] bytes) throws IOException {
            this.codedOutputStream.writeRawBytes(bytes);
        }

        public void flush() throws IOException {
            this.codedOutputStream.flush();
            this.outputStream.hflush();
        }

        public void close() throws IOException {
            this.flush();
            this.outputStream.close();
        }
    }
}

