/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.AnalyzeString;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLMatchingSubstring;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class XSLAnalyzeString
extends StyleElement {
    private Expression select;
    private Expression regex;
    private Expression flags;
    private StyleElement matching;
    private StyleElement nonMatching;
    private RegularExpression pattern;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainFallback() {
        return true;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public void prepareAttributes() throws XPathException {
        String string;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            string = this.getNamePool().getClarkName(n);
            if (string == "regex") {
                string3 = attributeCollection.getValue(i);
                continue;
            }
            if (string == "select") {
                string2 = attributeCollection.getValue(i);
                continue;
            }
            if (string == "flags") {
                string4 = attributeCollection.getValue(i).trim();
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string2 == null) {
            this.reportAbsence("select");
            string2 = ".";
        }
        this.select = this.makeExpression(string2);
        if (string3 == null) {
            this.reportAbsence("regex");
            string3 = "xxx";
        }
        this.regex = this.makeAttributeValueTemplate(string3);
        if (string4 == null) {
            string4 = "";
        }
        this.flags = this.makeAttributeValueTemplate(string4);
        if (this.regex instanceof StringLiteral && this.flags instanceof StringLiteral) {
            try {
                Platform platform = Configuration.getPlatform();
                String string5 = ((StringLiteral)this.regex).getStringValue();
                string = ((StringLiteral)this.flags).getStringValue();
                this.pattern = platform.compileRegularExpression(string5, true, string);
                if (this.pattern.matches("")) {
                    this.invalidRegex("The regular expression must not be one that matches a zero-length string", "XTDE1150");
                }
            }
            catch (XPathException xPathException) {
                if ("FORX0001".equals(xPathException.getErrorCodeLocalPart())) {
                    this.invalidRegex("Error in regular expression flags: " + xPathException, "XTDE1145");
                }
                this.invalidRegex("Error in regular expression: " + xPathException, "XTDE1140");
            }
        }
    }

    private void invalidRegex(String string, String string2) throws XPathException {
        this.compileError(string, string2);
        this.pattern = null;
    }

    public void validate() throws XPathException {
        Object object;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((object = (NodeInfo)axisIterator.next()) != null) {
            if (object instanceof XSLFallback) continue;
            if (object instanceof XSLMatchingSubstring) {
                boolean bl = object.getLocalPart().equals("matching-substring");
                if (bl) {
                    if (this.matching != null) {
                        this.compileError("xsl:matching-substring element must only appear once", "XTSE0010");
                    }
                    this.matching = (StyleElement)object;
                    continue;
                }
                if (this.nonMatching != null) {
                    this.compileError("xsl:non-matching-substring element must only appear once", "XTSE0010");
                }
                this.nonMatching = (StyleElement)object;
                continue;
            }
            this.compileError("Only xsl:matching-substring and xsl:non-matching-substring are allowed here", "XTSE0010");
        }
        if (this.matching == null && this.nonMatching == null) {
            this.compileError("At least one xsl:matching-substring or xsl:non-matching-substring element must be present", "XTSE1130");
        }
        this.select = this.typeCheck("select", this.select);
        this.regex = this.typeCheck("regex", this.regex);
        this.flags = this.typeCheck("flags", this.flags);
        try {
            object = new RoleLocator(4, "xsl:analyze-string/select", 0, null);
            ExpressionLocation expressionLocation = new ExpressionLocation(this);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
            object = new RoleLocator(4, "xsl:analyze-string/regex", 0, null);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.regex = TypeChecker.staticTypeCheck(this.regex, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
            object = new RoleLocator(4, "xsl:analyze-string/flags", 0, null);
            ((RoleLocator)object).setSourceLocator(expressionLocation);
            this.flags = TypeChecker.staticTypeCheck(this.flags, SequenceType.SINGLE_STRING, false, (RoleLocator)object, this.getStaticContext());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    public Expression compile(Executable executable) throws XPathException {
        Expression expression = null;
        if (this.matching != null) {
            expression = this.matching.compileSequenceConstructor(executable, this.matching.iterateAxis((byte)3), false);
        }
        Expression expression2 = null;
        if (this.nonMatching != null) {
            expression2 = this.nonMatching.compileSequenceConstructor(executable, this.nonMatching.iterateAxis((byte)3), false);
        }
        try {
            AnalyzeString analyzeString = new AnalyzeString(this.select, this.regex, this.flags, expression == null ? null : expression.simplify(this.matching.getStaticContext()), expression2 == null ? null : expression2.simplify(this.nonMatching.getStaticContext()), this.pattern);
            ExpressionTool.makeParentReferences(analyzeString);
            return analyzeString;
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return null;
        }
    }
}

