/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

public class FieldComparators {
    @VisibleForTesting
    Map<FieldLocation, Comparator<?>> fieldComparators = new TreeMap();

    public void registerComparator(FieldLocation fieldLocation, Comparator<?> comparator) {
        this.fieldComparators.put(fieldLocation, comparator);
    }

    public boolean isEmpty() {
        return this.fieldComparators.isEmpty();
    }

    public int hashCode() {
        return this.fieldComparators.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof FieldComparators && Objects.equals(this.fieldComparators, ((FieldComparators)obj).fieldComparators);
    }

    public String toString() {
        ArrayList<String> registeredComparatorsDescription = new ArrayList<String>();
        for (Map.Entry<FieldLocation, Comparator<?>> fieldComparator : this.fieldComparators.entrySet()) {
            registeredComparatorsDescription.add(FieldComparators.formatRegisteredComparator(fieldComparator));
        }
        return String.format("{%s}", Strings.join(registeredComparatorsDescription).with(", "));
    }

    private static String formatRegisteredComparator(Map.Entry<FieldLocation, Comparator<?>> fieldComparator) {
        return String.format("%s -> %s", fieldComparator, fieldComparator.getValue());
    }

    public boolean hasComparatorForField(FieldLocation fieldLocation) {
        return this.fieldComparators.containsKey(fieldLocation);
    }

    public Comparator<?> getComparatorForField(FieldLocation fieldLocation) {
        return this.fieldComparators.get(fieldLocation);
    }

    public Stream<Map.Entry<FieldLocation, Comparator<?>>> comparatorByFields() {
        return this.fieldComparators.entrySet().stream();
    }
}

