/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;

@Command(scope="unomi", name="profile-view", description="This command will dump a profile as a JSON string")
@Service
public class ProfileView
implements Action {
    @Reference
    ProfileService profileService;
    @Argument(index=0, name="profile", description="The identifier for the profile", required=true, multiValued=false)
    String profileIdentifier;

    public Object execute() throws Exception {
        Profile profile = this.profileService.load(this.profileIdentifier);
        if (profile == null) {
            System.out.println("Couldn't find a profile with id=" + this.profileIdentifier);
            return null;
        }
        String jsonProfile = CustomObjectMapper.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)profile);
        System.out.println(jsonProfile);
        return null;
    }
}

