/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.page.IPageManager;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.protocol.ws.IWebSocketSettings;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.IWebSocketProcessor;
import org.apache.wicket.protocol.ws.api.ServletRequestCopy;
import org.apache.wicket.protocol.ws.api.WebSocketMessageBroadcastHandler;
import org.apache.wicket.protocol.ws.api.WebSocketRequest;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.WebSocketRequestMapper;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.protocol.ws.api.event.WebSocketBinaryPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketClosedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketConnectedPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketPushPayload;
import org.apache.wicket.protocol.ws.api.event.WebSocketTextPayload;
import org.apache.wicket.protocol.ws.api.message.BinaryMessage;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.protocol.ws.api.registry.PageIdKey;
import org.apache.wicket.protocol.ws.api.registry.ResourceNameKey;
import org.apache.wicket.request.IExceptionMapper;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.AbstractRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebSocketProcessor
implements IWebSocketProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebSocketProcessor.class);
    static final int NO_PAGE_ID = -1;
    private static final Method GET_FILTER_PATH_METHOD;
    private final WebRequest webRequest;
    private final int pageId;
    private final String resourceName;
    private final Url baseUrl;
    private final WebApplication application;
    private final String sessionId;
    private final IWebSocketSettings webSocketSettings;
    private final IWebSocketConnectionRegistry connectionRegistry;

    public AbstractWebSocketProcessor(HttpServletRequest request, WebApplication application) {
        this.sessionId = request.getSession(true).getId();
        String pageId = request.getParameter("pageId");
        this.resourceName = request.getParameter("resourceName");
        if (Strings.isEmpty((CharSequence)pageId) && Strings.isEmpty((CharSequence)this.resourceName)) {
            throw new IllegalArgumentException("The request should have either 'pageId' or 'resourceName' parameter!");
        }
        this.pageId = !Strings.isEmpty((CharSequence)pageId) ? Integer.parseInt(pageId, 10) : -1;
        String baseUrl = request.getParameter("wicket-ajax-baseurl");
        Checks.notNull((Object)baseUrl, (String)String.format("Request parameter '%s' is required!", "wicket-ajax-baseurl"), (Object[])new Object[0]);
        this.baseUrl = Url.parse((CharSequence)baseUrl);
        WicketFilter wicketFilter = application.getWicketFilter();
        this.application = (WebApplication)Args.notNull((Object)application, (String)"application");
        this.webSocketSettings = IWebSocketSettings.Holder.get((Application)application);
        this.webRequest = this.createWebSocketRequest(request, this.getFilterPath(wicketFilter));
        this.connectionRegistry = this.webSocketSettings.getConnectionRegistry();
    }

    private String getFilterPath(WicketFilter wicketFilter) {
        String filterPath;
        try {
            filterPath = (String)GET_FILTER_PATH_METHOD.invoke((Object)wicketFilter, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return filterPath;
    }

    @Override
    public void onMessage(String message) {
        this.broadcastMessage(new TextMessage(message));
    }

    @Override
    public void onMessage(byte[] data, int offset, int length) {
        BinaryMessage binaryMessage = new BinaryMessage(data, offset, length);
        this.broadcastMessage(binaryMessage);
    }

    protected final void onConnect(IWebSocketConnection connection) {
        IKey key = this.getRegistryKey();
        this.connectionRegistry.setConnection((Application)this.getApplication(), this.getSessionId(), key, connection);
        this.broadcastMessage(new ConnectedMessage((Application)this.getApplication(), this.getSessionId(), key));
    }

    @Override
    public void onClose(int closeCode, String message) {
        IKey key = this.getRegistryKey();
        this.broadcastMessage(new ClosedMessage((Application)this.getApplication(), this.getSessionId(), key));
        this.connectionRegistry.removeConnection((Application)this.getApplication(), this.getSessionId(), key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void broadcastMessage(IWebSocketMessage message) {
        IKey key = this.getRegistryKey();
        IWebSocketConnection connection = this.connectionRegistry.getConnection((Application)this.application, this.sessionId, key);
        if (connection != null && connection.isOpen()) {
            Application oldApplication = ThreadContext.getApplication();
            Session oldSession = ThreadContext.getSession();
            RequestCycle oldRequestCycle = ThreadContext.getRequestCycle();
            WebResponse webResponse = this.createWebSocketResponse(connection);
            try {
                Session session;
                WebSocketRequestMapper requestMapper = new WebSocketRequestMapper(this.application.getRootRequestMapper());
                RequestCycle requestCycle = this.createRequestCycle(requestMapper, webResponse);
                ThreadContext.setRequestCycle((RequestCycle)requestCycle);
                ThreadContext.setApplication((Application)this.application);
                if (oldSession == null || message instanceof IWebSocketPushMessage) {
                    ISessionStore sessionStore = this.application.getSessionStore();
                    session = sessionStore.lookup((Request)this.webRequest);
                    ThreadContext.setSession((Session)session);
                } else {
                    session = oldSession;
                }
                IPageManager pageManager = session.getPageManager();
                Page page = this.getPage(pageManager);
                if (page != null) {
                    WebSocketRequestHandler requestHandler = new WebSocketRequestHandler((Component)page, connection);
                    WebSocketPayload payload = this.createEventPayload(message, requestHandler);
                    if (!(message instanceof ConnectedMessage) && !(message instanceof ClosedMessage)) {
                        requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)requestHandler);
                    }
                    WebSocketMessageBroadcastHandler broadcastingHandler = new WebSocketMessageBroadcastHandler(this.pageId, this.resourceName, payload);
                    requestMapper.setHandler(broadcastingHandler);
                    requestCycle.processRequestAndDetach();
                }
                LOG.debug("Page with id '{}' has been expired. No message will be broadcast!", (Object)this.pageId);
            }
            catch (Exception x) {
                LOG.error("An error occurred during processing of a WebSocket message", (Throwable)x);
            }
            finally {
                try {
                    webResponse.close();
                }
                finally {
                    ThreadContext.setApplication((Application)oldApplication);
                    ThreadContext.setRequestCycle((RequestCycle)oldRequestCycle);
                    ThreadContext.setSession((Session)oldSession);
                }
            }
        } else {
            LOG.debug("Either there is no connection({}) or it is closed.", (Object)connection);
        }
    }

    private WebResponse createWebSocketResponse(IWebSocketConnection connection) {
        WebSocketResponse webResponse = this.webSocketSettings instanceof WebSocketSettings ? ((WebSocketSettings)this.webSocketSettings).newWebSocketResponse(connection) : new WebSocketResponse(connection);
        return webResponse;
    }

    private WebRequest createWebSocketRequest(HttpServletRequest request, String filterPath) {
        Object webRequest = this.webSocketSettings instanceof WebSocketSettings ? ((WebSocketSettings)this.webSocketSettings).newWebSocketRequest(request, filterPath) : new WebSocketRequest(new ServletRequestCopy(request), filterPath);
        return webRequest;
    }

    private RequestCycle createRequestCycle(WebSocketRequestMapper requestMapper, WebResponse webResponse) {
        RequestCycleContext context = new RequestCycleContext((Request)this.webRequest, (Response)webResponse, (IRequestMapper)requestMapper, (IExceptionMapper)this.application.getExceptionMapperProvider().get());
        RequestCycle requestCycle = (RequestCycle)this.application.getRequestCycleProvider().get((Object)context);
        requestCycle.getListeners().add((Object)this.application.getRequestCycleListeners());
        requestCycle.getListeners().add((Object)new AbstractRequestCycleListener(){

            public void onDetach(RequestCycle requestCycle) {
                if (Session.exists()) {
                    Session.get().getPageManager().commitRequest();
                }
            }
        });
        requestCycle.getUrlRenderer().setBaseUrl(this.baseUrl);
        return requestCycle;
    }

    private Page getPage(IPageManager pageManager) {
        WebSocketResourcePage page = this.pageId != -1 ? (Page)pageManager.getPage(this.pageId) : new WebSocketResourcePage();
        return page;
    }

    protected final WebApplication getApplication() {
        return this.application;
    }

    protected final String getSessionId() {
        return this.sessionId;
    }

    private WebSocketPayload createEventPayload(IWebSocketMessage message, WebSocketRequestHandler handler) {
        WebSocketPayload payload;
        if (message instanceof TextMessage) {
            payload = new WebSocketTextPayload((TextMessage)message, handler);
        } else if (message instanceof BinaryMessage) {
            payload = new WebSocketBinaryPayload((BinaryMessage)message, handler);
        } else if (message instanceof ConnectedMessage) {
            payload = new WebSocketConnectedPayload((ConnectedMessage)message, handler);
        } else if (message instanceof ClosedMessage) {
            payload = new WebSocketClosedPayload((ClosedMessage)message, handler);
        } else if (message instanceof IWebSocketPushMessage) {
            payload = new WebSocketPushPayload((IWebSocketPushMessage)message, handler);
        } else {
            throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
        }
        return payload;
    }

    private IKey getRegistryKey() {
        IKey key = Strings.isEmpty((CharSequence)this.resourceName) ? new PageIdKey(this.pageId) : new ResourceNameKey(this.resourceName);
        return key;
    }

    static {
        try {
            GET_FILTER_PATH_METHOD = WicketFilter.class.getDeclaredMethod("getFilterPath", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        GET_FILTER_PATH_METHOD.setAccessible(true);
    }

    private static class WebSocketResourcePage
    extends WebPage
    implements IMarkupResourceStreamProvider {
        private WebSocketResourcePage() {
            this.setStatelessHint(true);
        }

        public IResourceStream getMarkupResourceStream(MarkupContainer container, Class<?> containerClass) {
            return new StringResourceStream((CharSequence)"");
        }
    }
}

