/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.TagUtils;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedMarkup
extends Markup {
    private static final Logger log = LoggerFactory.getLogger(MergedMarkup.class);

    public MergedMarkup(Markup markup, Markup baseMarkup, int extendIndex) {
        super(markup.getMarkupResourceStream());
        this.getMarkupResourceStream().setBaseMarkup(baseMarkup);
        MarkupResourceStream baseResourceStream = baseMarkup.getMarkupResourceStream();
        this.getMarkupResourceStream().setEncoding(baseResourceStream.getEncoding());
        this.getMarkupResourceStream().setWicketNamespace(baseResourceStream.getWicketNamespace());
        if (log.isDebugEnabled()) {
            String derivedResource = Strings.afterLast((String)markup.getMarkupResourceStream().getResource().toString(), (char)'/');
            String baseResource = Strings.afterLast((String)baseMarkup.getMarkupResourceStream().getResource().toString(), (char)'/');
            log.debug("Merge markup: derived markup: " + derivedResource + "; base markup: " + baseResource);
        }
        this.merge(markup, baseMarkup, extendIndex);
        if (log.isDebugEnabled()) {
            log.debug("Merge markup: " + this.toString());
        }
    }

    @Override
    public String locationAsString() {
        String l1 = this.getMarkupResourceStream().getBaseMarkup().locationAsString();
        String l2 = this.getMarkupResourceStream().locationAsString();
        if (l1 == null && l2 == null) {
            return null;
        }
        return l1 + ":" + l2;
    }

    private void merge(IMarkupFragment markup, IMarkupFragment baseMarkup, int extendIndex) {
        ComponentTag tag;
        MarkupElement element;
        int baseIndex;
        boolean wicketHeadProcessed = false;
        boolean foundHeadTag = false;
        WicketTag childTag = null;
        MarkupResourceStream markupResourceStream = baseMarkup.getMarkupResourceStream();
        IResourceStream resource = markupResourceStream.getResource();
        Class<? extends Component> markupClass = markupResourceStream.getMarkupClass();
        for (baseIndex = 0; baseIndex < baseMarkup.size(); ++baseIndex) {
            element = baseMarkup.get(baseIndex);
            if (element instanceof RawMarkup) {
                this.addMarkupElement(element);
                continue;
            }
            tag = (ComponentTag)element;
            if (resource != null && tag.getMarkupClass() == null) {
                tag.setMarkupClass(markupClass);
            }
            if (element instanceof WicketTag) {
                WicketTag wtag = (WicketTag)element;
                if (wtag.isChildTag() && tag.getMarkupClass() == markupClass) {
                    if (wtag.isOpenClose()) {
                        childTag = wtag;
                        WicketTag childOpenTag = (WicketTag)wtag.mutable();
                        childOpenTag.getXmlTag().setType(XmlTag.TagType.OPEN);
                        childOpenTag.setMarkupClass(markupClass);
                        this.addMarkupElement(childOpenTag);
                        break;
                    }
                    if (wtag.isOpen()) {
                        this.addMarkupElement(wtag);
                        break;
                    }
                    throw new WicketRuntimeException("Did not expect a </wicket:child> tag in " + baseMarkup.toString());
                }
                if (!wicketHeadProcessed) {
                    if (wtag.isClose() && wtag.isHeadTag() && !foundHeadTag) {
                        wicketHeadProcessed = true;
                        this.addMarkupElement(wtag);
                        this.copyWicketHead(markup, extendIndex);
                        continue;
                    }
                    if (wtag.isOpen() && wtag.isMajorWicketComponentTag()) {
                        wicketHeadProcessed = true;
                        this.copyWicketHead(markup, extendIndex);
                    }
                }
            }
            if (!wicketHeadProcessed) {
                if (tag.isOpen() && TagUtils.isHeadTag(tag)) {
                    foundHeadTag = true;
                }
                if (tag.isClose() && TagUtils.isHeadTag(tag) || tag.isClose() && TagUtils.isWicketHeaderItemsTag(tag) || tag.isOpen() && TagUtils.isBodyTag(tag)) {
                    wicketHeadProcessed = true;
                    this.copyWicketHead(markup, extendIndex);
                }
            }
            this.addMarkupElement(element);
        }
        if (baseIndex == baseMarkup.size()) {
            throw new WicketRuntimeException("Expected to find <wicket:child/> in base markup: " + baseMarkup.toString());
        }
        while (extendIndex < markup.size()) {
            WicketTag wtag;
            element = markup.get(extendIndex);
            this.addMarkupElement(element);
            if (element instanceof WicketTag && (wtag = (WicketTag)element).isExtendTag() && wtag.isClose()) break;
            ++extendIndex;
        }
        if (extendIndex == markup.size()) {
            throw new WicketRuntimeException("Missing close tag </wicket:extend> in derived markup: " + markup.toString());
        }
        if (((ComponentTag)baseMarkup.get(baseIndex)).isOpen()) {
            ++baseIndex;
            while (baseIndex < baseMarkup.size()) {
                element = baseMarkup.get(baseIndex);
                if (element instanceof WicketTag) {
                    tag = (WicketTag)element;
                    if (((WicketTag)tag).isChildTag() && tag.isClose()) {
                        tag.setMarkupClass(markupClass);
                        this.addMarkupElement(tag);
                        break;
                    }
                    throw new WicketRuntimeException("Wicket tags like <wicket:xxx> are not allowed in between <wicket:child> and </wicket:child> tags: " + markup.toString());
                }
                if (element instanceof ComponentTag) {
                    throw new WicketRuntimeException("Wicket tags identified by wicket:id are not allowed in between <wicket:child> and </wicket:child> tags: " + markup.toString());
                }
                ++baseIndex;
            }
            if (baseIndex == baseMarkup.size()) {
                throw new WicketRuntimeException("Expected to find </wicket:child> in base markup: " + baseMarkup.toString());
            }
        } else {
            WicketTag childCloseTag = (WicketTag)childTag.mutable();
            childCloseTag.getXmlTag().setType(XmlTag.TagType.CLOSE);
            childCloseTag.setMarkupClass(markupClass);
            this.addMarkupElement(childCloseTag);
        }
        ++baseIndex;
        while (baseIndex < baseMarkup.size()) {
            element = baseMarkup.get(baseIndex);
            this.addMarkupElement(element);
            if (element instanceof ComponentTag && resource != null && (tag = (ComponentTag)element).getMarkupClass() == null) {
                tag.setMarkupClass(markupClass);
            }
            ++baseIndex;
        }
        if (Page.class.isAssignableFrom(markup.getMarkupResourceStream().getMarkupClass())) {
            int hasOpenWicketHead = -1;
            int hasCloseWicketHead = -1;
            int hasHead = -1;
            for (int i = 0; i < this.size(); ++i) {
                boolean isHeadTag;
                MarkupElement element2 = this.get(i);
                boolean bl = isHeadTag = element2 instanceof WicketTag && ((WicketTag)element2).isHeadTag();
                if (hasOpenWicketHead == -1 && isHeadTag) {
                    hasOpenWicketHead = i;
                    continue;
                }
                if (isHeadTag && ((ComponentTag)element2).isClose()) {
                    hasCloseWicketHead = i;
                    continue;
                }
                if (hasHead == -1 && element2 instanceof ComponentTag && TagUtils.isHeadTag(element2)) {
                    hasHead = i;
                    continue;
                }
                if (hasHead != -1 && hasOpenWicketHead != -1) break;
            }
            if (hasOpenWicketHead != -1 && hasHead == -1) {
                XmlTag headOpenTag = new XmlTag();
                headOpenTag.setName("head");
                headOpenTag.setType(XmlTag.TagType.OPEN);
                ComponentTag openTag = new ComponentTag(headOpenTag);
                openTag.setId("_header_");
                openTag.setAutoComponentTag(true);
                XmlTag headCloseTag = new XmlTag();
                headCloseTag.setName(headOpenTag.getName());
                headCloseTag.setType(XmlTag.TagType.CLOSE);
                ComponentTag closeTag = new ComponentTag(headCloseTag);
                closeTag.setOpenTag(openTag);
                closeTag.setId("_header_");
                this.addMarkupElement(hasOpenWicketHead, openTag);
                this.addMarkupElement(hasCloseWicketHead + 2, closeTag);
            }
        }
    }

    private void copyWicketHead(IMarkupFragment markup, int extendIndex) {
        boolean copy = false;
        for (int i = 0; i < extendIndex; ++i) {
            WicketTag etag;
            MarkupElement elem = markup.get(i);
            if (elem instanceof WicketTag && (etag = (WicketTag)elem).isHeadTag()) {
                if (etag.isOpen()) {
                    copy = true;
                } else {
                    this.addMarkupElement(elem);
                    break;
                }
            }
            if (!copy) continue;
            this.addMarkupElement(elem);
        }
    }
}

