/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.proxy.ILazyInitProxy;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.util.io.IClusterable;

public class LazyInitProxyFactory {
    private static final List PRIMITIVES = Arrays.asList(String.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, Boolean.TYPE, Boolean.class);
    private static final int CGLIB_CALLBACK_NO_OVERRIDE = 0;
    private static final int CGLIB_CALLBACK_HANDLER = 1;

    public static Object createProxy(Class<?> type, IProxyTargetLocator locator) {
        if (PRIMITIVES.contains(type) || Enum.class.isAssignableFrom(type)) {
            return locator.locateProxyTarget();
        }
        if (type.isInterface()) {
            JdkHandler handler = new JdkHandler(type, locator);
            try {
                return Proxy.newProxyInstance(LazyInitProxyFactory.resolveClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, IWriteReplace.class}, (InvocationHandler)handler);
            }
            catch (IllegalArgumentException e) {
                return Proxy.newProxyInstance(LazyInitProxyFactory.class.getClassLoader(), new Class[]{type, Serializable.class, ILazyInitProxy.class, IWriteReplace.class}, (InvocationHandler)handler);
            }
        }
        CGLibInterceptor handler = new CGLibInterceptor(type, locator);
        Callback[] callbacks = new Callback[]{SerializableNoOpCallback.INSTANCE, handler};
        Enhancer e = new Enhancer();
        e.setClassLoader(LazyInitProxyFactory.resolveClassLoader());
        e.setInterfaces(new Class[]{Serializable.class, ILazyInitProxy.class, IWriteReplace.class});
        e.setSuperclass(type);
        e.setCallbackFilter(NoOpForProtectedMethodsCGLibCallbackFilter.INSTANCE);
        e.setCallbacks(callbacks);
        e.setNamingPolicy((NamingPolicy)WicketNamingPolicy.INSTANCE);
        return e.create();
    }

    private static ClassLoader resolveClassLoader() {
        ClassLoader classLoader = null;
        if (Application.exists()) {
            classLoader = Application.get().getApplicationSettings().getClassResolver().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        return classLoader;
    }

    public static boolean isEqualsMethod(Method method) {
        return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class && method.getName().equals("equals");
    }

    public static boolean isHashCodeMethod(Method method) {
        return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0 && method.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(Method method) {
        return method.getReturnType() == String.class && method.getParameterTypes().length == 0 && method.getName().equals("toString");
    }

    public static boolean isFinalizeMethod(Method method) {
        return method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && method.getName().equals("finalize");
    }

    public static boolean isWriteReplaceMethod(Method method) {
        return method.getReturnType() == Object.class && method.getParameterTypes().length == 0 && method.getName().equals("writeReplace");
    }

    private static final class WicketNamingPolicy
    extends DefaultNamingPolicy {
        private static final WicketNamingPolicy INSTANCE = new WicketNamingPolicy();

        private WicketNamingPolicy() {
        }

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return super.getClassName("WICKET_" + prefix, source, key, names);
        }
    }

    private static class JdkHandler
    implements InvocationHandler,
    ILazyInitProxy,
    Serializable,
    IWriteReplace {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String typeName;
        private transient Object target;

        public JdkHandler(Class<?> type, IProxyTargetLocator locator) {
            this.locator = locator;
            this.typeName = type.getName();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (LazyInitProxyFactory.isFinalizeMethod(method)) {
                return null;
            }
            if (LazyInitProxyFactory.isEqualsMethod(method)) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (LazyInitProxyFactory.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (LazyInitProxyFactory.isToStringMethod(method)) {
                return this.toString();
            }
            if (method.getDeclaringClass().equals(ILazyInitProxy.class)) {
                return this.getObjectLocator();
            }
            if (LazyInitProxyFactory.isWriteReplaceMethod(method)) {
                return this.writeReplace();
            }
            if (this.target == null) {
                this.target = this.locator.locateProxyTarget();
            }
            try {
                method.setAccessible(true);
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public IProxyTargetLocator getObjectLocator() {
            return this.locator;
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new ProxyReplacement(this.typeName, this.locator);
        }
    }

    private static class NoOpForProtectedMethodsCGLibCallbackFilter
    implements CallbackFilter {
        private static final CallbackFilter INSTANCE = new NoOpForProtectedMethodsCGLibCallbackFilter();

        private NoOpForProtectedMethodsCGLibCallbackFilter() {
        }

        public int accept(Method method) {
            if (Modifier.isProtected(method.getModifiers())) {
                return 0;
            }
            return 1;
        }
    }

    public static class SerializableNoOpCallback
    implements NoOp,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final NoOp INSTANCE = new SerializableNoOpCallback();
    }

    private static class CGLibInterceptor
    implements MethodInterceptor,
    ILazyInitProxy,
    Serializable,
    IWriteReplace {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String typeName;
        private transient Object target;

        public CGLibInterceptor(Class<?> type, IProxyTargetLocator locator) {
            this.typeName = type.getName();
            this.locator = locator;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (LazyInitProxyFactory.isFinalizeMethod(method)) {
                return null;
            }
            if (LazyInitProxyFactory.isEqualsMethod(method)) {
                return this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (LazyInitProxyFactory.isHashCodeMethod(method)) {
                return this.hashCode();
            }
            if (LazyInitProxyFactory.isToStringMethod(method)) {
                return this.toString();
            }
            if (LazyInitProxyFactory.isWriteReplaceMethod(method)) {
                return this.writeReplace();
            }
            if (method.getDeclaringClass().equals(ILazyInitProxy.class)) {
                return this.getObjectLocator();
            }
            if (this.target == null) {
                this.target = this.locator.locateProxyTarget();
            }
            return proxy.invoke(this.target, args);
        }

        @Override
        public IProxyTargetLocator getObjectLocator() {
            return this.locator;
        }

        @Override
        public Object writeReplace() throws ObjectStreamException {
            return new ProxyReplacement(this.typeName, this.locator);
        }
    }

    static class ProxyReplacement
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final IProxyTargetLocator locator;
        private final String type;

        public ProxyReplacement(String type, IProxyTargetLocator locator) {
            this.type = type;
            this.locator = locator;
        }

        private Object readResolve() throws ObjectStreamException {
            Class<?> clazz = WicketObjects.resolveClass((String)this.type);
            if (clazz == null) {
                try {
                    clazz = Class.forName(this.type, false, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException ignored1) {
                    try {
                        clazz = Class.forName(this.type, false, LazyInitProxyFactory.class.getClassLoader());
                    }
                    catch (ClassNotFoundException ignored2) {
                        ClassNotFoundException cause = new ClassNotFoundException("Could not resolve type [" + this.type + "] with the currently configured org.apache.wicket.application.IClassResolver");
                        throw new WicketRuntimeException((Throwable)cause);
                    }
                }
            }
            return LazyInitProxyFactory.createProxy(clazz, this.locator);
        }
    }

    public static interface IWriteReplace {
        public Object writeReplace() throws ObjectStreamException;
    }
}

