/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.atmosphere;

import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.atmosphere.AtmosphereEvent;
import org.apache.wicket.atmosphere.EventSubscription;
import org.apache.wicket.atmosphere.PageKey;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;

class AtmosphereWebRequest
extends ServletWebRequest {
    private final ServletWebRequest wrappedRequest;
    private final PageKey pageKey;
    private final Iterator<EventSubscription> subscriptions;
    private final AtmosphereEvent event;

    AtmosphereWebRequest(ServletWebRequest wrappedRequest, PageKey pageKey, Iterator<EventSubscription> subscriptions, AtmosphereEvent event) {
        super(wrappedRequest.getContainerRequest(), wrappedRequest.getFilterPrefix());
        this.wrappedRequest = wrappedRequest;
        this.pageKey = pageKey;
        this.subscriptions = subscriptions;
        this.event = event;
    }

    public PageKey getPageKey() {
        return this.pageKey;
    }

    public Iterator<EventSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public AtmosphereEvent getEvent() {
        return this.event;
    }

    public List<Cookie> getCookies() {
        return this.wrappedRequest.getCookies();
    }

    public List<String> getHeaders(String name) {
        return this.wrappedRequest.getHeaders(name);
    }

    public String getHeader(String name) {
        return this.wrappedRequest.getHeader(name);
    }

    public Time getDateHeader(String name) {
        return this.wrappedRequest.getDateHeader(name);
    }

    public Url getUrl() {
        return this.wrappedRequest.getUrl();
    }

    public Url getClientUrl() {
        return this.wrappedRequest.getClientUrl();
    }

    public Locale getLocale() {
        return this.wrappedRequest.getLocale();
    }

    public Charset getCharset() {
        if (this.wrappedRequest == null) {
            return RequestUtils.getCharset((HttpServletRequest)super.getContainerRequest());
        }
        return this.wrappedRequest.getCharset();
    }

    public Cookie getCookie(String cookieName) {
        return this.wrappedRequest.getCookie(cookieName);
    }

    public int hashCode() {
        return this.wrappedRequest.hashCode();
    }

    public Url getOriginalUrl() {
        return this.wrappedRequest.getOriginalUrl();
    }

    public IRequestParameters getQueryParameters() {
        return this.wrappedRequest.getQueryParameters();
    }

    public IRequestParameters getRequestParameters() {
        return this.wrappedRequest.getRequestParameters();
    }

    public boolean equals(Object obj) {
        return this.wrappedRequest.equals(obj);
    }

    public String getFilterPrefix() {
        return this.wrappedRequest.getFilterPrefix();
    }

    public String toString() {
        return this.wrappedRequest.toString();
    }

    public IRequestParameters getPostParameters() {
        return this.wrappedRequest.getPostParameters();
    }

    public ServletWebRequest cloneWithUrl(Url url) {
        return this.wrappedRequest.cloneWithUrl(url);
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload) throws FileUploadException {
        return this.wrappedRequest.newMultipartWebRequest(maxSize, upload);
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        return this.wrappedRequest.newMultipartWebRequest(maxSize, upload, factory);
    }

    public String getPrefixToContextPath() {
        return this.wrappedRequest.getPrefixToContextPath();
    }

    public HttpServletRequest getContainerRequest() {
        return this.wrappedRequest.getContainerRequest();
    }

    public String getContextPath() {
        return this.wrappedRequest.getContextPath();
    }

    public String getFilterPath() {
        return this.wrappedRequest.getFilterPath();
    }

    public boolean shouldPreserveClientUrl() {
        return this.wrappedRequest.shouldPreserveClientUrl();
    }

    public boolean isAjax() {
        return true;
    }
}

