/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.pages.BrowserInfoForm;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.util.time.Duration;

public class AjaxClientInfoBehavior
extends AbstractAjaxTimerBehavior {
    public AjaxClientInfoBehavior() {
        this(Duration.milliseconds((long)50L));
    }

    public AjaxClientInfoBehavior(Duration duration) {
        super(duration);
    }

    @Override
    protected final void onTimer(AjaxRequestTarget target) {
        this.stop(target);
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters requestParameters = requestCycle.getRequest().getRequestParameters();
        String navigatorAppName = requestParameters.getParameterValue("navigatorAppName").toString("N/A");
        String navigatorAppVersion = requestParameters.getParameterValue("navigatorAppVersion").toString("N/A");
        String navigatorAppCodeName = requestParameters.getParameterValue("navigatorAppCodeName").toString("N/A");
        boolean navigatorCookieEnabled = requestParameters.getParameterValue("navigatorCookieEnabled").toBoolean(false);
        Boolean navigatorJavaEnabled = requestParameters.getParameterValue("navigatorJavaEnabled").toBoolean(false);
        String navigatorLanguage = requestParameters.getParameterValue("navigatorLanguage").toString("N/A");
        String navigatorPlatform = requestParameters.getParameterValue("navigatorPlatform").toString("N/A");
        String navigatorUserAgent = requestParameters.getParameterValue("navigatorUserAgent").toString("N/A");
        int screenWidth = requestParameters.getParameterValue("screenWidth").toInt(-1);
        int screenHeight = requestParameters.getParameterValue("screenHeight").toInt(-1);
        int screenColorDepth = requestParameters.getParameterValue("screenColorDepth").toInt(-1);
        String utcOffset = requestParameters.getParameterValue("utcOffset").toString("N/A");
        String utcDSTOffset = requestParameters.getParameterValue("utcDSTOffset").toString("N/A");
        int browserWidth = requestParameters.getParameterValue("browserWidth").toInt(-1);
        int browserHeight = requestParameters.getParameterValue("browserHeight").toInt(-1);
        String hostname = requestParameters.getParameterValue("hostname").toString("N/A");
        WebClientInfo clientInfo = new WebClientInfo(requestCycle);
        Session.get().setClientInfo(clientInfo);
        ClientProperties properties = clientInfo.getProperties();
        properties.setNavigatorAppCodeName(navigatorAppCodeName);
        properties.setNavigatorAppName(navigatorAppName);
        properties.setNavigatorAppVersion(navigatorAppVersion);
        properties.setCookiesEnabled(navigatorCookieEnabled);
        properties.setJavaEnabled(navigatorJavaEnabled);
        properties.setNavigatorLanguage(navigatorLanguage);
        properties.setNavigatorPlatform(navigatorPlatform);
        properties.setNavigatorUserAgent(navigatorUserAgent);
        properties.setScreenWidth(screenWidth);
        properties.setScreenHeight(screenHeight);
        properties.setScreenColorDepth(screenColorDepth);
        properties.setUtcOffset(utcOffset);
        properties.setUtcDSTOffset(utcDSTOffset);
        properties.setBrowserWidth(browserWidth);
        properties.setBrowserHeight(browserHeight);
        properties.setHostname(hostname);
        this.onClientInfo(target, clientInfo);
    }

    protected void onClientInfo(AjaxRequestTarget target, WebClientInfo clientInfo) {
    }

    @Override
    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getDynamicExtraParameters().add("return Wicket.BrowserInfo.collect()");
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render(JavaScriptHeaderItem.forReference(new JavaScriptResourceReference(BrowserInfoForm.class, "wicket-browser-info.js")));
    }
}

