/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.parser.XmlPullParser;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.markup.parser.filter.HtmlHandler;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;

public class TagTester {
    private static final Pattern AJAX_COMPONENT_CDATA_OPEN = Pattern.compile("<component.*?><!\\[CDATA\\[");
    private static final Pattern AJAX_COMPONENT_CDATA_CLOSE = Pattern.compile("\\]\\]></component>");
    private final XmlTag openTag;
    private final XmlTag closeTag;
    private final XmlPullParser parser;

    private TagTester(XmlPullParser parser, XmlTag openTag, XmlTag closeTag) {
        this.parser = parser;
        this.openTag = openTag;
        this.closeTag = closeTag;
    }

    public String getName() {
        return this.openTag.getName();
    }

    public boolean hasAttribute(String attribute) {
        boolean hasAttribute = false;
        if (this.getAttribute(attribute) != null) {
            hasAttribute = true;
        }
        return hasAttribute;
    }

    public String getAttribute(String attribute) {
        String value = null;
        IValueMap attributeMap = this.openTag.getAttributes();
        if (attributeMap != null) {
            for (String attr : attributeMap.keySet()) {
                if (!attr.equalsIgnoreCase(attribute)) continue;
                value = attributeMap.getString(attr);
            }
        }
        return value;
    }

    public boolean getAttributeContains(String attribute, String partialValue) {
        String value;
        boolean contains = false;
        if (partialValue != null && (value = this.getAttribute(attribute)) != null && value.contains(partialValue)) {
            contains = true;
        }
        return contains;
    }

    public boolean getAttributeIs(String attribute, String expected) {
        boolean is = false;
        String val = this.getAttribute(attribute);
        if (val == null && expected == null || expected != null && expected.equals(val)) {
            is = true;
        }
        return is;
    }

    public boolean getAttributeEndsWith(String attribute, String expected) {
        String val;
        boolean endsWith = false;
        if (expected != null && (val = this.getAttribute(attribute)) != null && val.endsWith(expected)) {
            endsWith = true;
        }
        return endsWith;
    }

    public boolean hasChildTag(String tagName) {
        boolean hasChild;
        block4: {
            Args.notEmpty((CharSequence)tagName, (String)"tagName");
            hasChild = false;
            if (this.openTag.isOpen()) {
                try {
                    XmlTag tag;
                    int startPos = this.openTag.getPos() + this.openTag.getLength();
                    int endPos = this.closeTag.getPos();
                    String markup = ((Object)this.parser.getInput(startPos, endPos)).toString();
                    if (Strings.isEmpty((CharSequence)markup)) break block4;
                    XmlPullParser p = new XmlPullParser();
                    p.parse(markup);
                    while ((tag = p.nextTag()) != null) {
                        if (!tagName.equalsIgnoreCase(tag.getName())) continue;
                        hasChild = true;
                        break;
                    }
                }
                catch (Exception e) {
                    throw new WicketRuntimeException(e);
                }
            }
        }
        return hasChild;
    }

    public TagTester getChild(String tagName) {
        Args.notNull((Object)tagName, (String)"tagName");
        TagTester childTagTester = null;
        if (this.openTag.isOpen()) {
            int startPos = this.openTag.getPos() + this.openTag.getLength();
            int endPos = this.closeTag.getPos();
            String markup = ((Object)this.parser.getInput(startPos, endPos)).toString();
            childTagTester = TagTester.createTagByAttribute(markup, tagName);
        }
        return childTagTester;
    }

    public TagTester getChild(String attribute, String value) {
        String markup;
        TagTester childTag = null;
        if (this.openTag.isOpen() && !Strings.isEmpty((CharSequence)(markup = this.getMarkup()))) {
            childTag = TagTester.createTagByAttribute(markup, attribute, value);
        }
        return childTag;
    }

    public String getMarkup() {
        int openPos = this.openTag.getPos();
        int closePos = this.closeTag.getPos() + this.closeTag.getLength();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public String getValue() {
        if (this.openTag == this.closeTag) {
            return null;
        }
        int openPos = this.openTag.getPos() + this.openTag.getLength();
        int closePos = this.closeTag.getPos();
        return ((Object)this.parser.getInput(openPos, closePos)).toString();
    }

    public static TagTester createTagByName(String markup, final String tagName) {
        List<TagTester> tester = TagTester.createTags(markup, new Predicate<XmlTag>(){

            @Override
            public boolean apply(XmlTag xmlTag) {
                return xmlTag.getName().equalsIgnoreCase(tagName);
            }
        }, true);
        if (tester == null || tester.size() == 0) {
            return null;
        }
        return tester.get(0);
    }

    @Deprecated
    public static TagTester createTagByAttribute(String markup, String tagName) {
        return TagTester.createTagByName(markup, tagName);
    }

    public static TagTester createTagByAttribute(String markup, String attribute, String value) {
        List<TagTester> tester = TagTester.createTagsByAttribute(markup, attribute, value, true);
        if (tester == null || tester.size() == 0) {
            return null;
        }
        return tester.get(0);
    }

    @Deprecated
    public static TagTester createTagsByAttribute(String markup, String attribute, String value) {
        return TagTester.createTagByAttribute(markup, attribute, value);
    }

    public static List<TagTester> createTagsByAttribute(String markup, final String attribute, final String value, boolean stopAfterFirst) {
        if (Strings.isEmpty((CharSequence)attribute) || Strings.isEmpty((CharSequence)value)) {
            return Collections.emptyList();
        }
        return TagTester.createTags(markup, new Predicate<XmlTag>(){

            @Override
            public boolean apply(XmlTag xmlTag) {
                return value.equals(xmlTag.getAttributes().get((Object)attribute));
            }
        }, stopAfterFirst);
    }

    private static List<TagTester> createTags(String markup, Predicate<XmlTag> accept, boolean stopAfterFirst) {
        ArrayList<TagTester> testers = new ArrayList<TagTester>();
        if (!Strings.isEmpty((CharSequence)markup)) {
            try {
                XmlTag xmlTag;
                markup = AJAX_COMPONENT_CDATA_OPEN.matcher(markup).replaceAll("<component>");
                markup = AJAX_COMPONENT_CDATA_CLOSE.matcher(markup).replaceAll("</component>");
                XmlPullParser parser = new XmlPullParser();
                parser.parse(markup);
                XmlTag openTag = null;
                XmlTag closeTag = null;
                Stack<XmlTag> stack = new Stack<XmlTag>();
                while ((xmlTag = parser.nextTag()) != null) {
                    if (openTag == null) {
                        if (accept.apply(xmlTag)) {
                            if (xmlTag.isOpen()) {
                                openTag = xmlTag;
                            } else if (xmlTag.isOpenClose()) {
                                openTag = xmlTag;
                                closeTag = xmlTag;
                            }
                        }
                    } else {
                        XmlTag foundTag;
                        if (xmlTag.isOpen() && !xmlTag.isOpenClose()) {
                            stack.push(xmlTag);
                        }
                        if (xmlTag.isClose() && (foundTag = TagTester.findOpenTag(xmlTag, stack)) == null) {
                            if (xmlTag.getName().equals(openTag.getName())) {
                                closeTag = xmlTag;
                                closeTag.setOpenTag(openTag);
                            } else if (!HtmlHandler.requiresCloseTag(openTag.getName())) {
                                closeTag = openTag;
                            } else {
                                openTag = null;
                                closeTag = null;
                            }
                        }
                    }
                    if (openTag != null && closeTag != null) {
                        TagTester tester = new TagTester(parser, openTag, closeTag);
                        testers.add(tester);
                        openTag = null;
                        closeTag = null;
                    }
                    if (!stopAfterFirst || closeTag == null) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new WicketRuntimeException(e);
            }
        }
        return testers;
    }

    private static XmlTag findOpenTag(XmlTag closeTag, Stack<XmlTag> stack) {
        while (stack.size() > 0) {
            XmlTag popped = stack.pop();
            if (!popped.getName().equals(closeTag.getName())) continue;
            return popped;
        }
        return null;
    }

    private static interface Predicate<T> {
        public boolean apply(T var1);
    }
}

