/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.internal.InlineEnclosure;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;

public final class InlineEnclosureHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    public static final String INLINE_ENCLOSURE_ID_PREFIX = "InlineEnclosure-";
    public static final String INLINE_ENCLOSURE_ATTRIBUTE_NAME = "enclosure";
    private Deque<ComponentTag> enclosures;

    public InlineEnclosureHandler() {
        this(null);
    }

    public InlineEnclosureHandler(MarkupResourceStream resourceStream) {
        super(resourceStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag instanceof WicketTag) {
            return tag;
        }
        String enclosureAttr = this.getAttribute(tag, null);
        if (enclosureAttr != null) {
            if (!tag.isOpen()) throw new ParseException("Open-close tags don't make sense for InlineEnclosure. Tag:" + tag.toString(), tag.getPos());
            String htmlId = tag.getAttribute("id");
            if (tag.getId() != null && !Strings.isEmpty((CharSequence)htmlId) && !htmlId.equals(tag.getId())) {
                throw new ParseException("Make sure that 'id' and 'wicket:id' are the same if both are provided. Tag:" + tag.toString(), tag.getPos());
            }
            if (Strings.isEmpty((CharSequence)tag.getId())) {
                if (Strings.isEmpty((CharSequence)htmlId)) {
                    String id = this.getWicketNamespace() + "_" + INLINE_ENCLOSURE_ID_PREFIX + this.getRequestUniqueId();
                    tag.setId(id);
                } else {
                    tag.setId(htmlId);
                }
                tag.setAutoComponentTag(true);
                tag.setAutoComponentFactory(new ComponentTag.IAutoComponentFactory(){

                    @Override
                    public Component newComponent(MarkupContainer container, ComponentTag tag) {
                        String attributeName = InlineEnclosureHandler.this.getInlineEnclosureAttributeName(null);
                        String childId = tag.getAttribute(attributeName);
                        return new InlineEnclosure(tag.getId(), childId);
                    }
                });
                tag.setModified(true);
            }
            if (this.enclosures == null) {
                this.enclosures = new ArrayDeque<ComponentTag>();
            }
            this.enclosures.push(tag);
            return tag;
        } else {
            if (this.enclosures == null || this.enclosures.size() <= 0) return tag;
            if (tag.isOpen() && tag.getId() != null && !(tag instanceof WicketTag) && !tag.isAutoComponentTag()) {
                Iterator<ComponentTag> componentTagIterator = this.enclosures.descendingIterator();
                while (componentTagIterator.hasNext()) {
                    ComponentTag lastEnclosure = componentTagIterator.next();
                    String attr = this.getAttribute(lastEnclosure, null);
                    if (!Strings.isEmpty((CharSequence)attr)) continue;
                    lastEnclosure.getAttributes().put((Object)this.getInlineEnclosureAttributeName(null), (Object)tag.getId());
                    lastEnclosure.setModified(true);
                }
                return tag;
            } else {
                ComponentTag lastEnclosure;
                String attr;
                if (!tag.isClose() || !tag.closes(this.enclosures.peek()) || !Strings.isEmpty((CharSequence)(attr = this.getAttribute(lastEnclosure = this.enclosures.pop(), null)))) return tag;
                throw new ParseException("Did not find any child for InlineEnclosure. Tag:" + lastEnclosure.toString(), tag.getPos());
            }
        }
    }

    private String getAttribute(ComponentTag tag, MarkupStream markupStream) {
        return tag.getAttributes().getString(this.getInlineEnclosureAttributeName(markupStream));
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        String inlineEnclosureChildId = this.getAttribute(tag, markupStream);
        if (!Strings.isEmpty((CharSequence)inlineEnclosureChildId)) {
            String id = tag.getId();
            return new InlineEnclosure(id, inlineEnclosureChildId);
        }
        return null;
    }

    private String getInlineEnclosureAttributeName(MarkupStream markupStream) {
        return this.getWicketNamespace(markupStream) + ':' + INLINE_ENCLOSURE_ATTRIBUTE_NAME;
    }
}

