/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.collections.IntHashMap;

public class PageWindowManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<PageWindowInternal> windows = new ArrayList<PageWindowInternal>();
    private IntHashMap<Integer> idToWindowIndex = null;
    private IntHashMap<Integer> windowIndexToPageId = null;
    private int indexPointer = -1;
    private int totalSize = 0;
    private final long maxSize;

    private void putWindowIndex(int pageId, int windowIndex) {
        if (this.idToWindowIndex != null && pageId != -1 && windowIndex != -1) {
            Integer oldPageId = (Integer)this.windowIndexToPageId.remove(windowIndex);
            if (oldPageId != null) {
                this.idToWindowIndex.remove(oldPageId.intValue());
            }
            this.idToWindowIndex.put(pageId, (Object)windowIndex);
            this.windowIndexToPageId.put(windowIndex, (Object)pageId);
        }
    }

    private void removeWindowIndex(int pageId) {
        Integer windowIndex = (Integer)this.idToWindowIndex.remove(pageId);
        if (windowIndex != null) {
            this.windowIndexToPageId.remove(windowIndex.intValue());
        }
    }

    private void rebuildIndices() {
        this.idToWindowIndex = null;
        this.idToWindowIndex = new IntHashMap();
        this.windowIndexToPageId = null;
        this.windowIndexToPageId = new IntHashMap();
        for (int i = 0; i < this.windows.size(); ++i) {
            PageWindowInternal window = this.windows.get(i);
            this.putWindowIndex(window.pageId, i);
        }
    }

    private int getWindowIndex(int pageId) {
        Integer result;
        if (this.idToWindowIndex == null) {
            this.rebuildIndices();
        }
        return (result = (Integer)this.idToWindowIndex.get(pageId)) != null ? result : -1;
    }

    private int incrementIndexPointer() {
        this.indexPointer = this.maxSize > 0L && (long)this.totalSize >= this.maxSize && this.indexPointer == this.windows.size() - 1 ? 0 : ++this.indexPointer;
        return this.indexPointer;
    }

    private int getWindowFileOffset(int index) {
        if (index > 0) {
            PageWindowInternal window = this.windows.get(index - 1);
            return window.filePartOffset + window.filePartSize;
        }
        return 0;
    }

    private void splitWindow(int index, int size) {
        PageWindowInternal window = this.windows.get(index);
        int delta = window.filePartSize - size;
        if (index == this.windows.size() - 1) {
            this.totalSize -= delta;
            window.filePartSize = size;
        } else if (window.filePartSize != size) {
            PageWindowInternal newWindow = new PageWindowInternal();
            newWindow.pageId = -1;
            window.filePartSize = size;
            this.windows.add(index + 1, newWindow);
            newWindow.filePartOffset = this.getWindowFileOffset(index + 1);
            newWindow.filePartSize = delta;
        }
        this.idToWindowIndex = null;
        this.windowIndexToPageId = null;
    }

    private void mergeWindowWithNext(int index) {
        if (index < this.windows.size() - 1) {
            PageWindowInternal window = this.windows.get(index);
            PageWindowInternal next = this.windows.get(index + 1);
            PageWindowInternal pageWindowInternal = window;
            pageWindowInternal.filePartSize = pageWindowInternal.filePartSize + next.filePartSize;
            this.windows.remove(index + 1);
            this.idToWindowIndex = null;
            this.windowIndexToPageId = null;
        }
    }

    private void adjustWindowSize(int index, int size) {
        PageWindowInternal window = this.windows.get(index);
        if (index == this.windows.size() - 1) {
            int delta = size - window.filePartSize;
            this.totalSize += delta;
            window.filePartSize = size;
        } else {
            while (window.filePartSize < size && index < this.windows.size() - 1) {
                this.mergeWindowWithNext(index);
            }
            if (window.filePartSize < size) {
                int delta = size - window.filePartSize;
                this.totalSize += delta;
                window.filePartSize = size;
            } else {
                this.splitWindow(index, size);
            }
        }
        window.pageId = -1;
    }

    private PageWindowInternal allocatePageWindow(int index, int size) {
        PageWindowInternal window;
        if (index == this.windows.size()) {
            window = new PageWindowInternal();
            window.filePartOffset = this.getWindowFileOffset(index);
            this.totalSize += size;
            window.filePartSize = size;
            this.windows.add(window);
        } else {
            window = this.windows.get(index);
            if (window.filePartSize != size) {
                this.adjustWindowSize(index, size);
            }
        }
        return window;
    }

    public synchronized PageWindow createPageWindow(int pageId, int size) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            this.removeWindowIndex(pageId);
            this.windows.get(index).pageId = -1;
        }
        if (index == -1 || index != this.indexPointer) {
            index = this.incrementIndexPointer();
        }
        PageWindowInternal window = this.allocatePageWindow(index, size);
        window.pageId = pageId;
        this.putWindowIndex(pageId, index);
        return new PageWindow(window);
    }

    public synchronized PageWindow getPageWindow(int pageId) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            return new PageWindow(this.windows.get(index));
        }
        return null;
    }

    public synchronized void removePage(int pageId) {
        int index = this.getWindowIndex(pageId);
        if (index != -1) {
            PageWindowInternal window = this.windows.get(index);
            this.removeWindowIndex(pageId);
            if (index == this.windows.size() - 1) {
                this.windows.remove(index);
                this.totalSize -= window.filePartSize;
                if (this.indexPointer == index) {
                    --this.indexPointer;
                }
            } else {
                window.pageId = -1;
            }
        }
    }

    public synchronized List<PageWindow> getLastPageWindows(int count) {
        ArrayList<PageWindow> result = new ArrayList<PageWindow>();
        int currentIndex = this.indexPointer;
        while (currentIndex != -1) {
            PageWindowInternal window;
            if (currentIndex < this.windows.size() && (window = this.windows.get(currentIndex)).pageId != -1) {
                result.add(new PageWindow(window));
            }
            if (--currentIndex == -1) {
                currentIndex = this.windows.size() - 1;
            }
            if (result.size() < count && currentIndex != this.indexPointer) continue;
        }
        return result;
    }

    public PageWindowManager(long maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized int getTotalSize() {
        return this.totalSize;
    }

    public static class PageWindow {
        private final PageWindowInternal pageWindowInternal;

        private PageWindow(PageWindowInternal pageWindowInternal) {
            this.pageWindowInternal = pageWindowInternal;
        }

        public int getPageId() {
            return this.pageWindowInternal.pageId;
        }

        public int getFilePartOffset() {
            return this.pageWindowInternal.filePartOffset;
        }

        public int getFilePartSize() {
            return this.pageWindowInternal.filePartSize;
        }
    }

    private static class PageWindowInternal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int pageId;
        private int filePartOffset;
        private int filePartSize;

        private PageWindowInternal() {
        }
    }
}

