/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.FormValidatorAdapter;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.resource.loader.ComponentStringResourceLoader;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidatorAdapter;

public class ValidatorStringResourceLoader
extends ComponentStringResourceLoader {
    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        if (clazz == null || !IValidator.class.isAssignableFrom(clazz) && !IFormValidator.class.isAssignableFrom(clazz)) {
            return null;
        }
        return super.loadStringResource(clazz, key, locale, style, variation);
    }

    @Override
    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        String resource = component instanceof FormComponent ? this.loadStringResource((FormComponent)component, key, locale, style, variation) : (component instanceof Form ? this.loadStringResource((Form)component, key, locale, style, variation) : null);
        return resource;
    }

    private String loadStringResource(Form<?> form, String key, Locale locale, String style, String variation) {
        for (IFormValidator validator : form.getFormValidators()) {
            Class<? extends IFormValidator> scope = this.getScope(validator);
            String resource = this.loadStringResource(scope, key, locale, style, variation);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private String loadStringResource(FormComponent<?> fc, String key, Locale locale, String style, String variation) {
        for (IValidator<?> validator : fc.getValidators()) {
            Class<? extends IValidator> scope = this.getScope(validator);
            String resource = this.loadStringResource(scope, key, locale, style, variation);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private Class<? extends IValidator> getScope(IValidator<?> validator) {
        Class<?> scope = validator instanceof ValidatorAdapter ? ((ValidatorAdapter)validator).getValidator().getClass() : validator.getClass();
        return scope;
    }

    private Class<? extends IFormValidator> getScope(IFormValidator formValidator) {
        Class<?> scope = formValidator instanceof FormValidatorAdapter ? ((FormValidatorAdapter)formValidator).getValidator().getClass() : formValidator.getClass();
        return scope;
    }
}

