/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-smtpsid.c,v 1.2 2004/04/06 00:41:58 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/mta.h"
#include "sm/limits.h"
#include "sm/io.h"
#include "sm/test.h"

void
test(void)
{
	sm_ret_T ret;
	int pid;
	id_count_T idc, idr, step;
	sessta_id_T sessid;

	pid = 1;
	step = UINT64_MAX / (uint64_t) 64;
	for (idc = 65535; idc < UINT64_MAX; idc += step)
	{
		sm_snprintf(sessid, sizeof(sessid), SMTPS_STID_FORMAT,
			idc, pid);
		ret = sm_id2idc(sessid, &idr);
		SM_TEST(ret == SM_SUCCESS);
		SM_TEST(idr == idc);
	}
}

int
main(int argc, char *argv[])
{
	int c;

	while ((c = getopt(argc, argv, "d")) != -1)
	{
		switch (c)
		{
		  default:
/*
			usage(argv[0]);
*/
			return 1;
		}
	}

	sm_test_begin(argc, argv, "test smtps id");
	test();
	return sm_test_end();
}
